/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import phex.gui.dialogs.filter.ConditionVisualizer;
import phex.gui.dialogs.filter.ConsequenceVisualizer;
import phex.gui.dialogs.filter.RuleDescOwnerDialog;
import phex.gui.dialogs.filter.RuleDescriptionVisualizer;
import phex.gui.dialogs.filter.editors.FileNameCondEditor;
import phex.gui.dialogs.filter.editors.FileSizeCondEditor;
import phex.gui.dialogs.filter.editors.MediaTypeCondEditor;
import phex.rules.Rule;
import phex.rules.condition.Condition;
import phex.rules.condition.FileSizeCondition;
import phex.rules.condition.FilenameCondition;
import phex.rules.condition.MediaTypeCondition;
import phex.rules.condition.NotCondition;
import phex.rules.consequence.Consequence;
import phex.utils.Localizer;
import phex.utils.NLogger;

public class RuleDescriptionPanel
extends JPanel {
    private RuleDescOwnerDialog parent;
    private JTextPane ruleDescArea;

    public RuleDescriptionPanel(RuleDescOwnerDialog ruleDescOwnerDialog) {
        this.parent = ruleDescOwnerDialog;
        this.prepareComponent();
    }

    private void prepareComponent() {
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("fill:d:grow", "p, 2dlu, fill:75dlu:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        JLabel jLabel = new JLabel(Localizer.getString("RuleWizard_RuleDescription"));
        panelBuilder.add((Component)jLabel, cellConstraints.xywh(1, 1, 1, 1));
        this.ruleDescArea = new JTextPane();
        this.ruleDescArea.setEditable(false);
        DescPaneMouseListener descPaneMouseListener = new DescPaneMouseListener();
        this.ruleDescArea.addMouseListener(descPaneMouseListener);
        this.ruleDescArea.addMouseMotionListener(descPaneMouseListener);
        panelBuilder.add((Component)new JScrollPane(this.ruleDescArea), cellConstraints.xywh(1, 3, 1, 1));
    }

    public void updateRuleData() {
        Rule rule = this.parent.getEditRule();
        try {
            Cloneable cloneable;
            Object object;
            StyledDocument styledDocument = this.ruleDescArea.getStyledDocument();
            styledDocument.remove(0, styledDocument.getLength());
            if (rule == null) {
                return;
            }
            this.ruleDescArea.setEnabled(!rule.isDefaultRule());
            RuleDescriptionVisualizer.insertStandardPart(Localizer.getString("RuleVisualization_Prefix"), rule, styledDocument);
            List list = rule.getConditions();
            Iterator iterator = list.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                object = (Condition)iterator.next();
                if (object instanceof NotCondition) continue;
                ConditionVisualizer.visualize((Condition)object, !bl, styledDocument);
                bl = false;
            }
            object = rule.getConsequences();
            iterator = object.iterator();
            bl = true;
            while (iterator.hasNext()) {
                cloneable = (Consequence)iterator.next();
                ConsequenceVisualizer.visualize(cloneable, !bl, styledDocument);
                bl = false;
            }
            list = rule.getConditions();
            iterator = list.iterator();
            bl = true;
            while (iterator.hasNext()) {
                cloneable = (Condition)iterator.next();
                if (!(cloneable instanceof NotCondition)) continue;
                ConditionVisualizer.visualize((Condition)cloneable, !bl, styledDocument);
                bl = false;
            }
        }
        catch (BadLocationException badLocationException) {
            NLogger.error(this.getClass(), (Object)badLocationException, (Throwable)badLocationException);
        }
    }

    private JDialog determineRuleLinkEditor(Object object) {
        if (object instanceof NotCondition) {
            object = ((NotCondition)object).getContainedCondition();
        }
        if (object instanceof FileSizeCondition) {
            return new FileSizeCondEditor((FileSizeCondition)object, this, (JDialog)((Object)this.parent));
        }
        if (object instanceof FilenameCondition) {
            return new FileNameCondEditor((FilenameCondition)object, this, (JDialog)((Object)this.parent));
        }
        if (object instanceof MediaTypeCondition) {
            return new MediaTypeCondEditor((MediaTypeCondition)object, this, (JDialog)((Object)this.parent));
        }
        throw new IllegalArgumentException("Unknown rule link editor.");
    }

    private class DescPaneMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private final Cursor LINK_CURSOR = Cursor.getPredefinedCursor(12);
        private final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
        private Position.Bias[] bias = new Position.Bias[1];
        private Element curElem = null;
        private Element linkElem = null;

        private DescPaneMouseListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            JTextPane jTextPane = (JTextPane)mouseEvent.getSource();
            boolean bl = true;
            Cursor cursor = this.DEFAULT_CURSOR;
            if (!jTextPane.isEditable()) {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                int n = jTextPane.getUI().viewToModel(jTextPane, point, this.bias);
                if (this.bias[0] == Position.Bias.Backward && n > 0) {
                    --n;
                }
                if (n >= 0) {
                    StyledDocument styledDocument = (StyledDocument)jTextPane.getDocument();
                    Element element = styledDocument.getCharacterElement(n);
                    if (!this.doesElementContainLocation(jTextPane, element, n, mouseEvent.getX(), mouseEvent.getY())) {
                        element = null;
                    }
                    if (this.curElem != element) {
                        AttributeSet attributeSet;
                        Object object;
                        this.curElem = element;
                        Element element2 = null;
                        if (element != null && (object = (attributeSet = element.getAttributes()).getAttribute("Link")) != null) {
                            element2 = element;
                        }
                        if (element2 != this.linkElem) {
                            this.linkElem = element2;
                            if (element2 != null) {
                                cursor = this.LINK_CURSOR;
                            }
                        } else {
                            bl = false;
                        }
                    } else {
                        bl = false;
                    }
                }
            }
            if (bl && jTextPane.getCursor() != cursor) {
                jTextPane.setCursor(cursor);
            }
        }

        private boolean doesElementContainLocation(JEditorPane jEditorPane, Element element, int n, int n2, int n3) {
            if (element != null && n > 0 && element.getStartOffset() == n) {
                try {
                    TextUI textUI = jEditorPane.getUI();
                    Rectangle rectangle = textUI.modelToView(jEditorPane, n, Position.Bias.Forward);
                    if (rectangle == null) {
                        return false;
                    }
                    Rectangle rectangle2 = rectangle instanceof Rectangle ? rectangle : rectangle.getBounds();
                    Rectangle rectangle3 = textUI.modelToView(jEditorPane, element.getEndOffset(), Position.Bias.Backward);
                    if (rectangle3 != null) {
                        Rectangle rectangle4 = rectangle3 instanceof Rectangle ? rectangle3 : rectangle3.getBounds();
                        rectangle2.add(rectangle4);
                    }
                    return rectangle2.contains(n2, n3);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return true;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.linkElem == null) {
                return;
            }
            AttributeSet attributeSet = this.linkElem.getAttributes();
            Object object = attributeSet.getAttribute("Link");
            JDialog jDialog = RuleDescriptionPanel.this.determineRuleLinkEditor(object);
            jDialog.show();
            RuleDescriptionPanel.this.updateRuleData();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }
}

