/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter.editors;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import phex.gui.dialogs.filter.RuleDescriptionPanel;
import phex.rules.condition.FilenameCondition;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.utils.StringUtils;

public class FileNameCondEditor
extends JDialog {
    private RuleDescriptionPanel ruleDescPanel;
    private FilenameCondition orgCondition;
    private FilenameCondition condition;
    private JTextField termTF;
    private JList termsList;
    private TermsModel termsModel;

    public FileNameCondEditor(FilenameCondition filenameCondition, RuleDescriptionPanel ruleDescriptionPanel, JDialog jDialog) {
        super(jDialog, Localizer.getString("FileNameCondEditor_DialogTitle"), true);
        this.ruleDescPanel = ruleDescriptionPanel;
        this.orgCondition = filenameCondition;
        this.condition = new FilenameCondition(filenameCondition);
        this.prepareComponent();
    }

    private void prepareComponent() {
        CloseEventHandler closeEventHandler = new CloseEventHandler();
        this.addWindowListener(closeEventHandler);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        container.add((Component)jPanel, "Center");
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("4dlu, d, 2dlu, d, d:grow, 4dlu, d, 4dlu", "4dlu, p, 2dlu, p, 10dlu, p, 2dlu, p, fill:p:grow, 4dlu, p, 2dlu, p 4dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        int n = formLayout.getColumnCount();
        int n2 = formLayout.getRowCount();
        JLabel jLabel = new JLabel(Localizer.getString("FileNameCondEditor_ConditionToAdd"));
        panelBuilder.add((Component)jLabel, cellConstraints.xywh(2, 2, 5, 1));
        jLabel = new JLabel(Localizer.getString("FileNameCondEditor_Term"));
        jLabel.setToolTipText(Localizer.getString("FileNameCondEditor_TTTTerm"));
        panelBuilder.add((Component)jLabel, cellConstraints.xywh(2, 4, 1, 1));
        this.termTF = new JTextField(25);
        this.termTF.setToolTipText(Localizer.getString("FileNameCondEditor_TTTTerm"));
        panelBuilder.add((Component)this.termTF, cellConstraints.xywh(4, 4, 1, 1));
        JButton jButton = new JButton(Localizer.getString("FileNameCondEditor_Add"));
        jButton.addActionListener(new AddActionListener());
        jButton.setToolTipText(Localizer.getString("FileNameCondEditor_TTTAdd"));
        panelBuilder.add((Component)jButton, cellConstraints.xywh(7, 4, 1, 1));
        jLabel = new JLabel(Localizer.getString("FileNameCondEditor_FileNameConditions"));
        panelBuilder.add((Component)jLabel, cellConstraints.xywh(2, 6, 5, 1));
        this.termsModel = new TermsModel();
        this.termsList = new JList(this.termsModel);
        this.termsList.setCellRenderer(new TermsRenderer());
        panelBuilder.add((Component)new JScrollPane(this.termsList), cellConstraints.xywh(2, 8, 4, 2));
        JButton jButton2 = new JButton(Localizer.getString("FileNameCondEditor_Remove"));
        jButton2.addActionListener(new RemoveActionListener());
        jButton2.setToolTipText(Localizer.getString("FileNameCondEditor_TTTRemove"));
        panelBuilder.add((Component)jButton2, cellConstraints.xywh(7, 8, 1, 1));
        panelBuilder.add((Component)new JSeparator(), cellConstraints.xywh(1, n2 - 3, n, 1));
        JButton jButton3 = new JButton(Localizer.getString("OK"));
        jButton3.addActionListener(new OkBtnListener());
        jButton3.setDefaultCapable(true);
        jButton3.setRequestFocusEnabled(true);
        JButton jButton4 = new JButton(Localizer.getString("Cancel"));
        jButton4.addActionListener(closeEventHandler);
        JPanel jPanel2 = ButtonBarFactory.buildOKCancelBar(jButton3, jButton4);
        panelBuilder.add((Component)jPanel2, cellConstraints.xywh(2, n2 - 1, n - 2, 1));
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(jButton3);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public final class TermsRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object == null) {
                this.setText("");
            } else {
                this.setText("'" + object.toString() + "'");
            }
            return this;
        }
    }

    public final class TermsModel
    extends AbstractListModel {
        public int getSize() {
            return FileNameCondEditor.this.condition.getTermsCount();
        }

        public Object getElementAt(int n) {
            return FileNameCondEditor.this.condition.getTermsList().get(n);
        }

        public void fireChange() {
            this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
        }
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            FileNameCondEditor.this.closeDialog();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FileNameCondEditor.this.closeDialog();
        }
    }

    private final class OkBtnListener
    implements ActionListener {
        private OkBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FileNameCondEditor.this.orgCondition.update(FileNameCondEditor.this.condition);
                FileNameCondEditor.this.ruleDescPanel.updateRuleData();
                FileNameCondEditor.this.closeDialog();
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }
    }

    private final class RemoveActionListener
    implements ActionListener {
        private RemoveActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2 = FileNameCondEditor.this.termsList.getSelectedIndex();
            Object[] objectArray = FileNameCondEditor.this.termsList.getSelectedValues();
            for (n = 0; n < objectArray.length; ++n) {
                FileNameCondEditor.this.condition.removeTerm((String)objectArray[n]);
            }
            FileNameCondEditor.this.termsModel.fireChange();
            n = FileNameCondEditor.this.termsModel.getSize();
            if (n == 0) {
                FileNameCondEditor.this.termTF.requestFocusInWindow();
            } else {
                FileNameCondEditor.this.termsList.setSelectedIndex(Math.max(0, Math.min(n2, n - 1)));
            }
        }
    }

    private final class AddActionListener
    implements ActionListener {
        private AddActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = FileNameCondEditor.this.termTF.getText().trim();
            if (StringUtils.isEmpty(string)) {
                return;
            }
            FileNameCondEditor.this.condition.addTerm(string);
            FileNameCondEditor.this.termTF.setText("");
            FileNameCondEditor.this.termsModel.fireChange();
            FileNameCondEditor.this.termTF.requestFocusInWindow();
        }
    }
}

