/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter.editors;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import phex.common.MediaType;
import phex.gui.dialogs.filter.RuleDescriptionPanel;
import phex.rules.condition.MediaTypeCondition;
import phex.utils.Localizer;
import phex.utils.NLogger;

public class MediaTypeCondEditor
extends JDialog {
    private RuleDescriptionPanel ruleDescPanel;
    private MediaTypeCondition orgCondition;
    private MediaTypeCondition condition;
    private JTable mediaTypeTable;
    private MediaTypeModel mediaTypeModel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public MediaTypeCondEditor(MediaTypeCondition mediaTypeCondition, RuleDescriptionPanel ruleDescriptionPanel, JDialog jDialog) {
        super(jDialog, Localizer.getString("MediaTypeCondEditor_DialogTitle"), true);
        this.ruleDescPanel = ruleDescriptionPanel;
        this.orgCondition = mediaTypeCondition;
        this.condition = new MediaTypeCondition(mediaTypeCondition);
        this.prepareComponent();
    }

    private void prepareComponent() {
        CloseEventHandler closeEventHandler = new CloseEventHandler();
        this.addWindowListener(closeEventHandler);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        container.add((Component)jPanel, "Center");
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("4dlu, d:grow, 4dlu", "4dlu, p, 2dlu, fill:100dlu:grow, 4dlu, p, 2dlu, p 4dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        int n = formLayout.getColumnCount();
        int n2 = formLayout.getRowCount();
        JLabel jLabel = new JLabel(Localizer.getString("MediaTypeCondEditor_ConditionToAdd"));
        panelBuilder.add((Component)jLabel, cellConstraints.xywh(2, 2, 1, 1));
        this.mediaTypeModel = new MediaTypeModel();
        this.mediaTypeTable = new JTable(this.mediaTypeModel);
        JTableHeader jTableHeader = this.mediaTypeTable.getTableHeader();
        jTableHeader.setResizingAllowed(false);
        jTableHeader.setReorderingAllowed(false);
        JCheckBox jCheckBox = (JCheckBox)((Object)this.mediaTypeTable.getDefaultRenderer(Boolean.class));
        TableColumn tableColumn = this.mediaTypeTable.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(jCheckBox.getPreferredSize().width + 2);
        tableColumn.setMinWidth(jCheckBox.getPreferredSize().width + 2);
        this.mediaTypeTable.getColumnModel().getColumn(1).setCellRenderer(new MediaTypeCellRenderer());
        panelBuilder.add((Component)new JScrollPane(this.mediaTypeTable), cellConstraints.xywh(2, 4, 1, 1));
        panelBuilder.add((Component)new JSeparator(), cellConstraints.xywh(1, n2 - 3, n, 1));
        JButton jButton = new JButton(Localizer.getString("OK"));
        jButton.addActionListener(new OkBtnListener());
        jButton.setDefaultCapable(true);
        jButton.setRequestFocusEnabled(true);
        JButton jButton2 = new JButton(Localizer.getString("Cancel"));
        jButton2.addActionListener(closeEventHandler);
        JPanel jPanel2 = ButtonBarFactory.buildOKCancelBar(jButton, jButton2);
        panelBuilder.add((Component)jPanel2, cellConstraints.xywh(2, n2 - 1, n - 2, 1));
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(jButton);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public final class MediaTypeCellRenderer
    extends DefaultTableCellRenderer {
        public void setValue(Object object) {
            if (object instanceof MediaType) {
                MediaType mediaType = (MediaType)object;
                this.setText(Localizer.getString(mediaType.getName()));
                this.setToolTipText(mediaType.getFileTypesUIText());
            }
        }
    }

    private final class MediaTypeModel
    extends AbstractTableModel {
        protected Object[][] conditionTypes = new Object[MediaType.getAllMediaTypes().length][2];

        public MediaTypeModel() {
            MediaType[] mediaTypeArray = MediaType.getAllMediaTypes();
            Set set = MediaTypeCondEditor.this.condition.getTypes();
            for (int i = 0; i < mediaTypeArray.length; ++i) {
                this.conditionTypes[i][0] = set.contains(mediaTypeArray[i]) ? Boolean.TRUE : Boolean.FALSE;
                this.conditionTypes[i][1] = mediaTypeArray[i];
            }
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.conditionTypes.length;
        }

        public Object getValueAt(int n, int n2) {
            return this.conditionTypes[n][n2];
        }

        public String getColumnName(int n) {
            return "";
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return class$java$lang$Boolean == null ? (class$java$lang$Boolean = MediaTypeCondEditor.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                }
                case 1: {
                    return class$java$lang$String == null ? (class$java$lang$String = MediaTypeCondEditor.class$("java.lang.String")) : class$java$lang$String;
                }
            }
            return class$java$lang$Object == null ? (class$java$lang$Object = MediaTypeCondEditor.class$("java.lang.Object")) : class$java$lang$Object;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            Boolean bl = (Boolean)object;
            this.conditionTypes[n][0] = object;
            if (bl.booleanValue()) {
                MediaTypeCondEditor.this.condition.addType((MediaType)this.conditionTypes[n][1]);
            } else {
                MediaTypeCondEditor.this.condition.removeType((MediaType)this.conditionTypes[n][1]);
            }
        }

        public int getRowOf(MediaType mediaType) {
            for (int i = 0; i < this.conditionTypes.length; ++i) {
                if (this.conditionTypes[i][1] != mediaType) continue;
                return i;
            }
            return -1;
        }
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            MediaTypeCondEditor.this.closeDialog();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MediaTypeCondEditor.this.closeDialog();
        }
    }

    private final class OkBtnListener
    implements ActionListener {
        private OkBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                MediaTypeCondEditor.this.orgCondition.update(MediaTypeCondEditor.this.condition);
                MediaTypeCondEditor.this.ruleDescPanel.updateRuleData();
                MediaTypeCondEditor.this.closeDialog();
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }
    }
}

