/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter.wizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import phex.gui.dialogs.filter.wizard.FilterWizardDialog;
import phex.rules.Rule;
import phex.utils.Localizer;

public class RulePropertiesPanel
extends JPanel {
    private FilterWizardDialog parent;
    private JTextField nameTF;
    private JCheckBox permanentActiveRule;

    public RulePropertiesPanel(FilterWizardDialog filterWizardDialog) {
        this.parent = filterWizardDialog;
        this.prepareComponent();
    }

    private void prepareComponent() {
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("fill:d:grow", "p, 8dlu, p, 2dlu, p, 8dlu, p, 4dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        JLabel jLabel = new JLabel(Localizer.getString("RuleWizard_FinalizeRule"));
        panelBuilder.add((Component)jLabel, cellConstraints.xywh(1, 1, 1, 1));
        jLabel = new JLabel(Localizer.getString("RuleWizard_RuleName"));
        panelBuilder.add((Component)jLabel, cellConstraints.xywh(1, 3, 1, 1));
        this.nameTF = new JTextField(20);
        this.nameTF.getDocument().addDocumentListener(new NameDocumentListener());
        this.nameTF.setToolTipText(Localizer.getString("RuleWizard_TTTRuleName"));
        panelBuilder.add((Component)this.nameTF, cellConstraints.xywh(1, 5, 1, 1));
        jLabel = new JLabel(Localizer.getString("RuleWizard_RuleOptions"));
        panelBuilder.add((Component)jLabel, cellConstraints.xywh(1, 7, 1, 1));
        this.permanentActiveRule = new JCheckBox(Localizer.getString("RuleWizard_PermanentlyEnableRule"));
        this.permanentActiveRule.setToolTipText(Localizer.getString("RuleWizard_TTTPermanentlyEnableRule"));
        this.permanentActiveRule.addActionListener(new PermanentActiveActionListener());
        panelBuilder.add((Component)this.permanentActiveRule, cellConstraints.xywh(1, 9, 1, 1));
    }

    public void addNotify() {
        super.addNotify();
        this.nameTF.requestFocusInWindow();
    }

    public void updateRuleData() {
        Rule rule = this.parent.getEditRule();
        this.nameTF.setText(rule.getName());
        this.permanentActiveRule.setSelected(rule.isPermanentlyEnabled());
        this.nameTF.setEnabled(!rule.isDefaultRule());
    }

    public class NameDocumentListener
    implements DocumentListener {
        public void changedUpdate(DocumentEvent documentEvent) {
            this.validateContent(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.validateContent(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.validateContent(documentEvent);
        }

        private void validateContent(DocumentEvent documentEvent) {
            String string = RulePropertiesPanel.this.nameTF.getText().trim();
            RulePropertiesPanel.this.parent.getEditRule().setName(string);
            RulePropertiesPanel.this.parent.setFinishBtnEnabled(string.length() > 0);
        }
    }

    private final class PermanentActiveActionListener
    implements ActionListener {
        private PermanentActiveActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Rule rule = RulePropertiesPanel.this.parent.getEditRule();
            rule.setPermanentlyEnabled(RulePropertiesPanel.this.permanentActiveRule.isSelected());
        }
    }
}

