/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter.wizard.consequence;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import phex.gui.common.table.FWTable;
import phex.gui.dialogs.filter.wizard.FilterWizardDialog;
import phex.gui.dialogs.filter.wizard.consequence.ConsequenceCellRenderer;
import phex.gui.dialogs.filter.wizard.consequence.ConsequenceTableModel;
import phex.rules.Rule;
import phex.rules.consequence.Consequence;
import phex.utils.Localizer;
import phex.utils.NLogger;

public class ConsequencePanel
extends JPanel {
    private FilterWizardDialog parent;
    private ConsequenceTableModel consequenceTableModel;
    private FWTable consequenceTable;
    private JLabel selectConsequenceLbl;

    public ConsequencePanel(FilterWizardDialog filterWizardDialog) {
        this.parent = filterWizardDialog;
        this.prepareComponent();
    }

    private void prepareComponent() {
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("fill:d:grow", "p, 2dlu, fill:75dlu:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        this.selectConsequenceLbl = new JLabel(Localizer.getString("RuleWizard_SelectRuleConsequence"));
        panelBuilder.add((Component)this.selectConsequenceLbl, cellConstraints.xywh(1, 1, 1, 1));
        this.consequenceTableModel = new ConsequenceTableModel(this);
        this.consequenceTable = new FWTable(this.consequenceTableModel);
        this.consequenceTable.setShowVerticalLines(false);
        JTableHeader jTableHeader = this.consequenceTable.getTableHeader();
        jTableHeader.setResizingAllowed(false);
        jTableHeader.setReorderingAllowed(false);
        JCheckBox jCheckBox = (JCheckBox)((Object)this.consequenceTable.getDefaultRenderer(Boolean.class));
        TableColumn tableColumn = this.consequenceTable.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(jCheckBox.getPreferredSize().width + 2);
        tableColumn.setMinWidth(jCheckBox.getPreferredSize().width + 2);
        this.consequenceTable.getColumnModel().getColumn(1).setCellRenderer(new ConsequenceCellRenderer());
        panelBuilder.add((Component)FWTable.createFWTableScrollPane(this.consequenceTable), cellConstraints.xywh(1, 3, 1, 1));
    }

    public void updateRuleData() {
        Rule rule = this.parent.getEditRule();
        int n = this.consequenceTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.consequenceTableModel.consequences[i][0] = Boolean.FALSE;
        }
        List list = rule.getConsequences();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Consequence consequence = (Consequence)iterator.next();
            int n2 = this.consequenceTableModel.getRowOf(consequence);
            this.consequenceTableModel.consequences[n2][0] = Boolean.TRUE;
        }
        this.consequenceTable.setEnabled(!rule.isDefaultRule());
        this.selectConsequenceLbl.setEnabled(!rule.isDefaultRule());
        this.consequenceTableModel.fireTableDataChanged();
    }

    public void ruleStatusChanged(Class clazz, boolean bl) {
        Rule rule = this.parent.getEditRule();
        if (bl) {
            try {
                Consequence consequence = (Consequence)clazz.newInstance();
                rule.addConsequence(consequence);
                this.parent.updateRuleData();
            }
            catch (InstantiationException instantiationException) {
                NLogger.error(ConsequencePanel.class, (Object)instantiationException, (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error(ConsequencePanel.class, (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
        } else {
            List list = rule.getConsequences();
            for (int i = list.size() - 1; i >= 0; --i) {
                Consequence consequence = (Consequence)list.get(i);
                if (consequence.getClass() != clazz) continue;
                rule.removeConsequence(consequence);
            }
            this.parent.updateRuleData();
        }
    }
}

