/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter.wizard.exception;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import phex.gui.common.table.FWTable;
import phex.gui.dialogs.filter.wizard.FilterWizardDialog;
import phex.gui.dialogs.filter.wizard.exception.ExceptionCellRenderer;
import phex.gui.dialogs.filter.wizard.exception.ExceptionTableModel;
import phex.rules.Rule;
import phex.rules.condition.Condition;
import phex.rules.condition.NotCondition;
import phex.utils.Localizer;
import phex.utils.NLogger;

public class ExceptionPanel
extends JPanel {
    private FilterWizardDialog parent;
    private ExceptionTableModel exceptionTableModel;
    private FWTable exceptionsTable;
    private JLabel selectExceptionLabel;

    public ExceptionPanel(FilterWizardDialog filterWizardDialog) {
        this.parent = filterWizardDialog;
        this.prepareComponent();
    }

    private void prepareComponent() {
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("fill:d:grow", "p, 2dlu, fill:75dlu:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        this.selectExceptionLabel = new JLabel(Localizer.getString("RuleWizard_SelectRuleException"));
        panelBuilder.add((Component)this.selectExceptionLabel, cellConstraints.xywh(1, 1, 1, 1));
        this.exceptionTableModel = new ExceptionTableModel(this);
        this.exceptionsTable = new FWTable(this.exceptionTableModel);
        this.exceptionsTable.setShowVerticalLines(false);
        JTableHeader jTableHeader = this.exceptionsTable.getTableHeader();
        jTableHeader.setResizingAllowed(false);
        jTableHeader.setReorderingAllowed(false);
        JCheckBox jCheckBox = (JCheckBox)((Object)this.exceptionsTable.getDefaultRenderer(Boolean.class));
        TableColumn tableColumn = this.exceptionsTable.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(jCheckBox.getPreferredSize().width + 2);
        tableColumn.setMinWidth(jCheckBox.getPreferredSize().width + 2);
        this.exceptionsTable.getColumnModel().getColumn(1).setCellRenderer(new ExceptionCellRenderer());
        panelBuilder.add((Component)FWTable.createFWTableScrollPane(this.exceptionsTable), cellConstraints.xywh(1, 3, 1, 1));
    }

    public void updateRuleData() {
        Rule rule = this.parent.getEditRule();
        int n = this.exceptionTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.exceptionTableModel.conditions[i][0] = Boolean.FALSE;
        }
        List list = rule.getConditions();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Condition condition = (Condition)iterator.next();
            if (!(condition instanceof NotCondition)) continue;
            int n2 = this.exceptionTableModel.getRowOf(condition);
            this.exceptionTableModel.conditions[n2][0] = Boolean.TRUE;
        }
        this.exceptionsTable.setEnabled(!rule.isDefaultRule());
        this.selectExceptionLabel.setEnabled(!rule.isDefaultRule());
        this.exceptionTableModel.fireTableDataChanged();
    }

    public void ruleStatusChanged(Class clazz, boolean bl) {
        Rule rule = this.parent.getEditRule();
        if (bl) {
            try {
                Condition condition = (Condition)clazz.newInstance();
                rule.addCondition(new NotCondition(condition));
                this.parent.updateRuleData();
            }
            catch (InstantiationException instantiationException) {
                NLogger.error(ExceptionPanel.class, (Object)instantiationException, (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error(ExceptionPanel.class, (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
        } else {
            List list = rule.getConditions();
            for (int i = list.size() - 1; i >= 0; --i) {
                NotCondition notCondition;
                Condition condition = (Condition)list.get(i);
                if (!(condition instanceof NotCondition) || (notCondition = (NotCondition)condition).getContainedCondition().getClass() != clazz) continue;
                rule.removeCondition(condition);
            }
            this.parent.updateRuleData();
        }
    }
}

