/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import phex.common.ServiceManager;
import phex.gui.common.GUIRegistry;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;

public class DisplayPromptsPane
extends OptionsSettingsPane {
    private GUIRegistry guiRegistry = GUIRegistry.getInstance();
    private JCheckBox showCloseOptionsChkbx;
    private JCheckBox showBetaUpdateNotificationChkbx;
    private JCheckBox showCopyrightLawsWarningChkbx;

    public DisplayPromptsPane() {
        super("PromptSettings_Prompts");
    }

    protected void prepareComponent() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "Center");
        FormLayout formLayout = new FormLayout("10dlu, d, 6dlu, d, 2dlu:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p");
        formLayout.setRowGroups(new int[][]{{3, 5}});
        jPanel.setLayout(formLayout);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator(Localizer.getString("PromptSettings_PromptSettings"), cellConstraints.xywh(1, 1, 5, 1));
        this.showCloseOptionsChkbx = new JCheckBox(Localizer.getString("PromptSettings_ClosePhexOptions"), ServiceManager.sCfg.showCloseOptionsDialog);
        this.showCloseOptionsChkbx.setToolTipText(Localizer.getString("PromptSettings_TTTClosePhexOptions"));
        panelBuilder.add((Component)this.showCloseOptionsChkbx, cellConstraints.xy(2, 3));
        this.showBetaUpdateNotificationChkbx = new JCheckBox(Localizer.getString("PromptSettings_NotifyOnNewBeta"), ServiceManager.sCfg.showBetaUpdateNotification);
        this.showBetaUpdateNotificationChkbx.setToolTipText(Localizer.getString("PromptSettings_TTTNotifyOnNewBeta"));
        panelBuilder.add((Component)this.showBetaUpdateNotificationChkbx, cellConstraints.xy(2, 5));
        this.showCopyrightLawsWarningChkbx = new JCheckBox(Localizer.getString("PromptSettings_RespectCopyrightNotice"), this.guiRegistry.isRespectCopyrightNoticeShown());
        this.showCopyrightLawsWarningChkbx.setToolTipText(Localizer.getString("PromptSettings_TTTRespectCopyrightNotice"));
        panelBuilder.add((Component)this.showCopyrightLawsWarningChkbx, cellConstraints.xy(2, 7));
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        boolean bl;
        boolean bl2 = this.showCloseOptionsChkbx.isSelected();
        if (ServiceManager.sCfg.showCloseOptionsDialog != bl2) {
            ServiceManager.sCfg.showCloseOptionsDialog = bl2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.showBetaUpdateNotification != (bl = this.showBetaUpdateNotificationChkbx.isSelected())) {
            ServiceManager.sCfg.showBetaUpdateNotification = bl;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        boolean bl3 = this.showCopyrightLawsWarningChkbx.isSelected();
        if (this.guiRegistry.isRespectCopyrightNoticeShown() != bl3) {
            this.guiRegistry.setRespectCopyrightNoticeShown(bl3);
        }
    }
}

