/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import phex.common.ServiceManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.HTMLMultiLinePanel;
import phex.gui.common.IconFactory;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.gui.renderer.FWListCellRenderer;
import phex.utils.Localizer;

public class LanguagePane
extends OptionsSettingsPane {
    private JList languageList;

    public LanguagePane() {
        super("LanguageSettings_Language");
    }

    protected void prepareComponent() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "Center");
        FormLayout formLayout = new FormLayout("10dlu, d, 2dlu:grow", "p, 3dlu, p, 2dlu, fill:d:grow, 3dlu, p");
        jPanel.setLayout(formLayout);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator(Localizer.getString("LanguageSettings_LanguageSettings"), cellConstraints.xywh(1, 1, 3, 1));
        HTMLMultiLinePanel hTMLMultiLinePanel = new HTMLMultiLinePanel(Localizer.getString("LanguageSettings_SelectYourLanguage"));
        panelBuilder.add((Component)hTMLMultiLinePanel, cellConstraints.xy(2, 3));
        this.languageList = new JList<Object>(Localizer.getAvailableLocales().toArray());
        this.languageList.setSelectionMode(0);
        this.languageList.setVisibleRowCount(5);
        this.languageList.setCellRenderer(new LanguageListCellRenderer());
        Font font = this.getLanugageListFont();
        this.languageList.setFont(font);
        this.languageList.setFixedCellHeight(font.getSize() * 2);
        JScrollPane jScrollPane = new JScrollPane(this.languageList);
        panelBuilder.add((Component)jScrollPane, cellConstraints.xy(2, 5));
        HTMLMultiLinePanel hTMLMultiLinePanel2 = new HTMLMultiLinePanel(Localizer.getString("LanguageSettings_RestartNote"));
        panelBuilder.add((Component)hTMLMultiLinePanel2, cellConstraints.xy(2, 7));
        Locale locale = Localizer.getUsedLocale();
        this.languageList.setSelectedValue(locale, true);
    }

    public void updateUI() {
        super.updateUI();
        if (this.languageList != null) {
            Font font = this.getLanugageListFont();
            this.languageList.setFont(font);
            this.languageList.setFixedCellHeight(font.getSize() * 2);
        }
    }

    private Font getLanugageListFont() {
        return UIManager.getFont("TitledBorder.font").deriveFont(1);
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        if (this.languageList.getSelectedIndex() == -1) {
            return;
        }
        Locale locale = (Locale)this.languageList.getSelectedValue();
        String string = locale.toString();
        if (!string.equals(ServiceManager.sCfg.usedLocale)) {
            ServiceManager.sCfg.usedLocale = string;
            Localizer.setUsedLocale(locale);
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
    }

    public class LanguageListCellRenderer
    extends FWListCellRenderer {
        private IconFactory iconFactory = GUIRegistry.getInstance().getIconFactory();

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (object instanceof Locale) {
                String string;
                Locale locale = (Locale)object;
                String string2 = locale.getDisplayLanguage(locale);
                String string3 = locale.getDisplayVariant(locale);
                if (string3 != null && string3.length() > 0) {
                    string2 = string2 + " / " + string3;
                }
                if ((string = locale.getDisplayCountry(locale)) != null && string.length() > 0) {
                    string2 = string2 + " (" + string + ")";
                }
                this.setText(string2);
                String string4 = locale.getCountry();
                Icon icon = null;
                if (string4 != null && string4.length() > 0) {
                    icon = this.iconFactory.getIcon("Flag_" + string4);
                }
                this.setIcon(icon);
            }
            return this;
        }
    }
}

