/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import phex.common.ServiceManager;
import phex.connection.NetworkManager;
import phex.gui.common.GUIUtils;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;

public class NetworkPane
extends OptionsSettingsPane {
    private static final String LISTENING_PORT_KEY = "ListeningPort";
    private static final String LISTENING_PORT_EXCESS_ERROR_KEY = "ListeningPortExcessErrorKey";
    private static final String CONNECTION_TIMEOUT_KEY = "ConnectionTimeout";
    private static final String UP_2_UP_CONNECTIONS_KEY = "UP2UPConnections";
    private static final String UP_2_LEAF_CONNECTIONS_KEY = "UP2LeafConnections";
    private static final String LEAF_2_UP_CONNECTIONS_KEY = "Leaf2UPConnections";
    private static final String LEAF_2_UP_CONNECTIONS_EXCESS_ERROR_KEY = "Leaf2UPConnectionsExcessErrorKey";
    private static final String MAX_CONCURRENT_CONNECT_ATTEMPTS_KEY = "MaxConcurrentConnectAttempts";
    private IntegerTextField listeningPortTF;
    private IntegerTextField connectionTimeoutTF;
    private IntegerTextField maxConcurrentConnectAttemptsTF;
    private JCheckBox autoConnectChkbx;
    private JCheckBox connectedToLANChkbx;
    private JCheckBox allowToBeUPChkbx;
    private JCheckBox forceToBeUPChkbx;
    private JLabel up2upConnectionsLabel;
    private IntegerTextField up2upConnectionsTF;
    private JLabel up2LeafConnectionsLabel;
    private IntegerTextField up2LeafConnectionsTF;
    private JLabel leaf2upConnectionsLabel;
    private IntegerTextField leaf2upConnectionsTF;

    public NetworkPane() {
        super("Network");
    }

    protected void prepareComponent() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "Center");
        FormLayout formLayout = new FormLayout("10dlu, right:d, 2dlu, d, 10dlu, right:d, 2dlu, d, 2dlu:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 8dlu, p, 3dlu, p, 3dlu, p, 8dlu, p, 3dlu, p");
        formLayout.setColumnGroups(new int[][]{{4, 8}, {2, 6}});
        formLayout.setRowGroups(new int[][]{{3, 5, 9, 11, 13, 17}});
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.addSeparator(Localizer.getString("NetworkSettings"), cellConstraints.xywh(1, n, 9, 1));
        panelBuilder.addLabel(Localizer.getString(LISTENING_PORT_KEY) + ": ", cellConstraints.xy(2, n += 2));
        this.listeningPortTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mListeningPort), 5, 5);
        panelBuilder.add((Component)this.listeningPortTF, cellConstraints.xy(4, n));
        panelBuilder.addLabel(Localizer.getString(CONNECTION_TIMEOUT_KEY) + ": ", cellConstraints.xy(6, n));
        this.connectionTimeoutTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mNetConnectionTimeout / 1000), 3, 3);
        panelBuilder.add((Component)this.connectionTimeoutTF, cellConstraints.xy(8, n));
        JLabel jLabel = panelBuilder.addLabel(Localizer.getString("NetworkSettings_MaxConcurrentConnectAttempts") + ": ", cellConstraints.xy(6, n += 2));
        jLabel.setToolTipText(Localizer.getString("NetworkSettings_TTTMaxConcurrentConnectAttempts"));
        this.maxConcurrentConnectAttemptsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.maxConcurrentConnectAttempts), 2, 2);
        this.maxConcurrentConnectAttemptsTF.setToolTipText(Localizer.getString("NetworkSettings_TTTMaxConcurrentConnectAttempts"));
        panelBuilder.add((Component)this.maxConcurrentConnectAttemptsTF, cellConstraints.xy(8, n));
        this.autoConnectChkbx = new JCheckBox(Localizer.getString("AutoConnectOnStartup"), ServiceManager.sCfg.mAutoConnect);
        panelBuilder.add((Component)this.autoConnectChkbx, cellConstraints.xywh(2, n += 2, 3, 1));
        this.connectedToLANChkbx = new JCheckBox(Localizer.getString("ConnectedToLAN"), ServiceManager.sCfg.connectedToLAN);
        this.connectedToLANChkbx.setToolTipText(Localizer.getString("TTTConnectedToLAN"));
        panelBuilder.add((Component)this.connectedToLANChkbx, cellConstraints.xywh(6, n, 3, 1));
        panelBuilder.addSeparator(Localizer.getString("UltrapeerSettings"), cellConstraints.xywh(1, n += 2, 9, 1));
        this.allowToBeUPChkbx = new JCheckBox(Localizer.getString("AllowToBecomeUltrapeer"), ServiceManager.sCfg.allowToBecomeUP);
        this.allowToBeUPChkbx.setToolTipText(Localizer.getString("TTTAllowToBecomeUltrapeer"));
        this.allowToBeUPChkbx.addActionListener(new CheckboxActionListener());
        panelBuilder.add((Component)this.allowToBeUPChkbx, cellConstraints.xywh(2, n += 2, 3, 1));
        this.forceToBeUPChkbx = new JCheckBox(Localizer.getString("ForceToBeUltrapeer"), ServiceManager.sCfg.forceToBeUltrapeer);
        this.forceToBeUPChkbx.setToolTipText(Localizer.getString("TTTForceToBeUltrapeer"));
        this.forceToBeUPChkbx.addActionListener(new CheckboxActionListener());
        panelBuilder.add((Component)this.forceToBeUPChkbx, cellConstraints.xywh(6, n, 3, 1));
        this.up2upConnectionsLabel = panelBuilder.addLabel(Localizer.getString("ConnectionsToUltrapeers") + ": ", cellConstraints.xy(2, n += 2));
        this.up2upConnectionsLabel.setToolTipText(Localizer.getString("TTTToUltrapeers"));
        this.up2upConnectionsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.up2upConnections), 2, 2);
        this.up2upConnectionsTF.setToolTipText(Localizer.getString("TTTToUltrapeers"));
        panelBuilder.add((Component)this.up2upConnectionsTF, cellConstraints.xy(4, n));
        this.up2LeafConnectionsLabel = panelBuilder.addLabel(Localizer.getString("ConnectionsToLeafs") + ": ", cellConstraints.xy(6, n));
        this.up2LeafConnectionsLabel.setToolTipText(Localizer.getString("TTTToLeafs"));
        this.up2LeafConnectionsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.up2leafConnections), 2, 2);
        this.up2LeafConnectionsTF.setToolTipText(Localizer.getString("TTTToLeafs"));
        panelBuilder.add((Component)this.up2LeafConnectionsTF, cellConstraints.xy(8, n));
        panelBuilder.addSeparator(Localizer.getString("LeafSettings"), cellConstraints.xywh(1, n += 2, 9, 1));
        this.leaf2upConnectionsLabel = panelBuilder.addLabel(Localizer.getString("ConnectionsToUltrapeers") + ": ", cellConstraints.xy(2, n += 2));
        this.leaf2upConnectionsLabel.setToolTipText(Localizer.getString("TTTToUltrapeers"));
        this.leaf2upConnectionsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.leaf2upConnections), 2, 1);
        this.leaf2upConnectionsTF.setToolTipText(Localizer.getString("TTTToUltrapeers"));
        panelBuilder.add((Component)this.leaf2upConnectionsTF, cellConstraints.xy(4, n));
        this.refreshEnableState();
    }

    public void checkInput(HashMap hashMap) {
        Integer n;
        String string;
        try {
            string = this.listeningPortTF.getText();
            n = new Integer(string);
            if (n > 65500) {
                hashMap.put(LISTENING_PORT_EXCESS_ERROR_KEY, this.listeningPortTF);
                this.setInputValid(hashMap, false);
                return;
            }
            hashMap.put(LISTENING_PORT_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.listeningPortTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.connectionTimeoutTF.getText();
            n = new Integer(string);
            hashMap.put(CONNECTION_TIMEOUT_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.connectionTimeoutTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.up2upConnectionsTF.getText();
            n = new Integer(string);
            hashMap.put(UP_2_UP_CONNECTIONS_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.up2upConnectionsTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.up2LeafConnectionsTF.getText();
            n = new Integer(string);
            hashMap.put(UP_2_LEAF_CONNECTIONS_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.up2LeafConnectionsTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.leaf2upConnectionsTF.getText();
            n = new Integer(string);
            if (n > 5) {
                hashMap.put(LEAF_2_UP_CONNECTIONS_EXCESS_ERROR_KEY, this.leaf2upConnectionsTF);
                this.setInputValid(hashMap, false);
                return;
            }
            hashMap.put(LEAF_2_UP_CONNECTIONS_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.leaf2upConnectionsTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.maxConcurrentConnectAttemptsTF.getText();
            n = new Integer(string);
            hashMap.put(MAX_CONCURRENT_CONNECT_ATTEMPTS_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.maxConcurrentConnectAttemptsTF);
            this.setInputValid(hashMap, false);
            return;
        }
        this.setInputValid(hashMap, true);
    }

    public void displayErrorMessage(HashMap hashMap) {
        if (hashMap.containsKey("NumberFormatError")) {
            this.displayNumberFormatError(hashMap);
        } else if (hashMap.containsKey(LEAF_2_UP_CONNECTIONS_EXCESS_ERROR_KEY)) {
            this.leaf2upConnectionsTF.setText(String.valueOf(5));
            this.leaf2upConnectionsTF.requestFocus();
            this.leaf2upConnectionsTF.selectAll();
            JOptionPane.showMessageDialog(this, Localizer.getFormatedString("NetworkSettings_Leaf2UpLimitExceeded", new Object[]{new Integer(5)}), Localizer.getString("NetworkSettings_LimitExceeded"), 0);
        } else if (hashMap.containsKey(LISTENING_PORT_EXCESS_ERROR_KEY)) {
            this.listeningPortTF.setText(String.valueOf(ServiceManager.sCfg.mListeningPort));
            this.listeningPortTF.requestFocus();
            this.listeningPortTF.selectAll();
            JOptionPane.showMessageDialog(this, Localizer.getString("NetworkSettings_ListeningPortLimitExceeded"), Localizer.getString("NetworkSettings_LimitExceeded"), 0);
        }
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        Integer n;
        int n2;
        Integer n3;
        int n4;
        Integer n5;
        int n6;
        Integer n7;
        int n8;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        Integer n9;
        int n10;
        Integer n11 = (Integer)hashMap.get(LISTENING_PORT_KEY);
        int n12 = n11;
        if (ServiceManager.sCfg.mListeningPort != n12) {
            ServiceManager.sCfg.mListeningPort = n12;
            OptionsSettingsPane.triggerConfigSave(hashMap);
            try {
                NetworkManager.getInstance().restartServer();
            }
            catch (Exception exception) {
                GUIUtils.showErrorMessage(Localizer.getString("FailedToListenOnNewPort"), Localizer.getString("ListenerError"));
            }
        }
        if (ServiceManager.sCfg.mNetConnectionTimeout != (n10 = (n9 = (Integer)hashMap.get(CONNECTION_TIMEOUT_KEY)) * 1000)) {
            ServiceManager.sCfg.mNetConnectionTimeout = n10;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mAutoConnect != (bl4 = this.autoConnectChkbx.isSelected())) {
            ServiceManager.sCfg.mAutoConnect = bl4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.connectedToLAN != (bl3 = this.connectedToLANChkbx.isSelected())) {
            ServiceManager.sCfg.connectedToLAN = bl3;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.allowToBecomeUP != (bl2 = this.allowToBeUPChkbx.isSelected())) {
            ServiceManager.sCfg.allowToBecomeUP = bl2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.forceToBeUltrapeer != (bl = this.forceToBeUPChkbx.isSelected())) {
            ServiceManager.sCfg.forceToBeUltrapeer = bl;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.up2upConnections != (n8 = (n7 = (Integer)hashMap.get(UP_2_UP_CONNECTIONS_KEY)).intValue())) {
            ServiceManager.sCfg.up2upConnections = n8;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.up2leafConnections != (n6 = (n5 = (Integer)hashMap.get(UP_2_LEAF_CONNECTIONS_KEY)).intValue())) {
            ServiceManager.sCfg.up2leafConnections = n6;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.leaf2upConnections != (n4 = (n3 = (Integer)hashMap.get(LEAF_2_UP_CONNECTIONS_KEY)).intValue())) {
            ServiceManager.sCfg.leaf2upConnections = n4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.maxConcurrentConnectAttempts != (n2 = (n = (Integer)hashMap.get(MAX_CONCURRENT_CONNECT_ATTEMPTS_KEY)).intValue())) {
            ServiceManager.sCfg.maxConcurrentConnectAttempts = n2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
    }

    private void refreshEnableState() {
        this.up2LeafConnectionsLabel.setEnabled(this.allowToBeUPChkbx.isSelected());
        this.up2LeafConnectionsTF.setEnabled(this.allowToBeUPChkbx.isSelected());
        this.up2upConnectionsLabel.setEnabled(this.allowToBeUPChkbx.isSelected());
        this.up2upConnectionsTF.setEnabled(this.allowToBeUPChkbx.isSelected());
        this.forceToBeUPChkbx.setEnabled(this.allowToBeUPChkbx.isSelected());
    }

    class CheckboxActionListener
    implements ActionListener {
        CheckboxActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NetworkPane.this.refreshEnableState();
        }
    }
}

