/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import javax.swing.AbstractListModel;
import phex.event.BookmarkedHostsChangeListener;
import phex.host.FavoriteHost;
import phex.host.FavoritesContainer;
import phex.host.HostManager;

public class FavoritesListModel
extends AbstractListModel {
    private FavoritesContainer favoritesContainer;

    public FavoritesListModel() {
        HostManager hostManager = HostManager.getInstance();
        this.favoritesContainer = hostManager.getFavoritesContainer();
        this.favoritesContainer.addBookmarkedHostsChangeListener(new FavoritesListener());
    }

    public int getSize() {
        return this.favoritesContainer.getBookmarkedHostsCount();
    }

    public Object getElementAt(int n) {
        FavoriteHost favoriteHost = this.favoritesContainer.getBookmarkedHostAt(n);
        if (favoriteHost == null) {
            this.fireIntervalRemoved(this, n, n);
            return "";
        }
        return favoriteHost;
    }

    private class FavoritesListener
    implements BookmarkedHostsChangeListener {
        private FavoritesListener() {
        }

        public void bookmarkedHostAdded(int n) {
            FavoritesListModel.this.fireIntervalAdded(this, n, n);
        }

        public void bookmarkedHostRemoved(int n) {
            FavoritesListModel.this.fireIntervalRemoved(this, n, n);
        }
    }
}

