/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import javax.swing.table.AbstractTableModel;
import phex.host.Host;
import phex.msg.QueryMsg;
import phex.query.QueryHistoryMonitor;
import phex.query.QueryManager;
import phex.utils.Localizer;

public class QueryHistoryMonitorTableModel
extends AbstractTableModel {
    private static final int numColRoutedFrom = 0;
    private static final int numColSearchText = 1;
    private static final int numColHopsTtl = 2;
    private static final String[] tableColumns = new String[]{Localizer.getString("SearchMonitorTab_RoutedFrom"), Localizer.getString("SearchMonitorTab_SearchText"), Localizer.getString("SearchMonitorTab_HopsTtl")};
    private QueryHistoryMonitor history = QueryManager.getInstance().getQueryHistoryMonitor();

    public String getColumnName(int n) {
        return tableColumns[n];
    }

    public int getColumnCount() {
        return tableColumns.length;
    }

    public int getRowCount() {
        return this.history.getHistorySize();
    }

    public Object getValueAt(int n, int n2) {
        QueryMsg queryMsg = this.history.getSearchQueryAt(n);
        if (queryMsg == null) {
            this.fireTableRowsDeleted(n, n);
            return null;
        }
        switch (n2) {
            case 0: {
                Host host = queryMsg.getHeader().getFromHost();
                if (host == null) {
                    return "<Unknown>";
                }
                return host.getHostAddress().getFullHostName();
            }
            case 1: {
                return queryMsg.getSearchString();
            }
            case 2: {
                byte by = queryMsg.getHeader().getHopsTaken();
                int n3 = by + queryMsg.getHeader().getTTL();
                return by + " / " + n3;
            }
        }
        return "";
    }

    public Class getColumnClass(int n) {
        return String.class;
    }
}

