/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.renderer;

import java.awt.Component;
import javax.swing.JTable;
import phex.common.TransferDataProvider;
import phex.common.format.TimeFormatUtils;
import phex.gui.renderer.CellColorHandler;
import phex.gui.renderer.FWTableCellRenderer;
import phex.utils.Localizer;

public class ETACellRenderer
extends FWTableCellRenderer {
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (object instanceof TransferDataProvider) {
            TransferDataProvider transferDataProvider = (TransferDataProvider)object;
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
            } else {
                CellColorHandler.applyCellColor(transferDataProvider, this);
            }
            long l = transferDataProvider.getTransferredDataSize();
            long l2 = transferDataProvider.getTransferDataSize();
            long l3 = transferDataProvider.getLongTermTransferRate();
            if (l2 == -1L || transferDataProvider.getDataTransferStatus() != 10) {
                this.setText("");
            } else {
                long l4;
                if (l3 == 0L) {
                    l4 = 31536000L;
                } else {
                    l4 = (l2 - l) / l3;
                    l4 = Math.max(0L, l4);
                }
                if (l4 < 31536000L) {
                    this.setText(TimeFormatUtils.formatSignificantElapsedTime(l4));
                } else {
                    this.setText(Localizer.getDecimalFormatSymbols().getInfinity());
                }
            }
        }
        return this;
    }
}

