/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import phex.common.URN;
import phex.download.RemoteFile;
import phex.download.swarming.SwarmingManager;
import phex.gui.common.LabeledIcon;
import phex.gui.tabs.search.SearchResultElement;
import phex.share.ShareManager;
import phex.share.SharedFilesService;

public class SearchTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Color DOWNLOAD_COLOR = new Color(0, 127, 0);
    private static final Color SHARE_COLOR = Color.lightGray;
    private SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
    private SwarmingManager swarmingMgr = SwarmingManager.getInstance();
    private JTree tree;

    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.tree != null) {
            font = this.tree.getFont();
        }
        return font;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (bl) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        String string = this.convertValueToText(object, bl, bl2, bl3, n, bl4);
        this.tree = jTree;
        this.hasFocus = bl4;
        this.setText(string);
        if (!jTree.isEnabled()) {
            this.setEnabled(false);
            if (bl3) {
                this.setDisabledIcon(this.getLeafIcon());
            } else if (bl2) {
                this.setDisabledIcon(this.getOpenIcon());
            } else {
                this.setDisabledIcon(this.getClosedIcon());
            }
        } else {
            this.setEnabled(true);
            if (bl3) {
                this.setIcon(this.getLeafIcon());
            } else if (bl2) {
                this.setIcon(this.getOpenIcon());
            } else {
                LabeledIcon labeledIcon = (LabeledIcon)this.getClosedIcon();
                if (object instanceof SearchResultElement) {
                    int n2 = ((SearchResultElement)object).getRemoteFileListCount();
                    labeledIcon.setLabel(String.valueOf(n2));
                } else {
                    labeledIcon.setLabel(null);
                }
                this.setIcon(labeledIcon);
            }
        }
        this.setComponentOrientation(jTree.getComponentOrientation());
        this.selected = bl;
        return this;
    }

    public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        RemoteFile remoteFile = object instanceof SearchResultElement ? ((SearchResultElement)object).getSingleRemoteFile() : (object instanceof RemoteFile ? (RemoteFile)object : null);
        if (remoteFile == null) {
            return "";
        }
        URN uRN = remoteFile.getURN();
        boolean bl5 = this.sharedFilesService.isURNShared(uRN);
        if (bl5) {
            this.setForeground(SHARE_COLOR);
        } else {
            boolean bl6 = this.swarmingMgr.isURNDownloaded(uRN);
            if (bl6) {
                this.setForeground(DOWNLOAD_COLOR);
            }
        }
        return remoteFile.getDisplayName();
    }
}

