/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import phex.gui.actions.FWAction;
import phex.gui.common.FWElegantPanel;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.dialogs.SecurityRuleConfigDialog;
import phex.gui.models.SecurityTableModel;
import phex.gui.renderer.SecurityRuleRowRenderer;
import phex.gui.tabs.FWTab;
import phex.security.IPAccessRule;
import phex.security.PhexSecurityManager;
import phex.security.SecurityRule;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;
import phex.xml.sax.gui.DTableColumnList;

public class SecurityTab
extends FWTab {
    private static final String SECURITY_TABLE_IDENTIFIER = "SecurityTable";
    private static final SecurityRule[] EMPTY_SECURITYRULE_ARRAY = new SecurityRule[0];
    private JPopupMenu securityPopup;
    private SecurityTableModel securityModel;
    private FWTableColumnModel securityColumnModel;
    private FWTable securityTable;
    private JScrollPane securityTableScrollPane;
    private PhexSecurityManager securityMgr = PhexSecurityManager.getInstance();
    private static final String EDIT_SECURITY_RULE_ACTION_KEY = "EditSecurityRuleAction";

    public SecurityTab() {
        super(1005, Localizer.getString("Security"), GUIRegistry.getInstance().getIconFactory().getIcon("Security"), Localizer.getString("TTTSecurity"), Localizer.getChar("SecurityMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("SecurityAccelerator")), 5);
    }

    public void initComponent(DGuiSettings dGuiSettings) {
        Serializable serializable;
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, fill:p:grow, 2dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        JPanel jPanel = new JPanel();
        FWElegantPanel fWElegantPanel = new FWElegantPanel(Localizer.getString("Security"), jPanel);
        panelBuilder.add((Component)fWElegantPanel, cellConstraints.xy(2, 2));
        FormLayout formLayout2 = new FormLayout("fill:d:grow", "fill:d:grow, 1dlu, p");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout2, jPanel);
        MouseHandler mouseHandler = new MouseHandler();
        this.securityModel = new SecurityTableModel();
        DTable dTable = GUIUtils.getDGuiTableByIdentifier(dGuiSettings, SECURITY_TABLE_IDENTIFIER);
        this.buildSecurityTableColumnModel(dTable);
        this.securityTable = new FWTable((TableModel)new FWSortedTableModel(this.securityModel), this.securityColumnModel);
        SecurityRuleRowRenderer securityRuleRowRenderer = new SecurityRuleRowRenderer();
        Enumeration<TableColumn> enumeration = this.securityColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            ((TableColumn)serializable).setCellRenderer(securityRuleRowRenderer);
        }
        this.securityTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.securityTable.activateAllHeaderActions();
        this.securityTable.setAutoResizeMode(0);
        this.securityTable.addMouseListener(mouseHandler);
        this.securityTableScrollPane = FWTable.createFWTableScrollPane(this.securityTable);
        this.securityTableScrollPane.addMouseListener(mouseHandler);
        panelBuilder2.add((Component)this.securityTableScrollPane, cellConstraints.xy(1, 1));
        serializable = new FWToolBar(0);
        ((JToolBar)serializable).setBorderPainted(false);
        ((JToolBar)serializable).setFloatable(false);
        panelBuilder2.add((Component)serializable, cellConstraints.xy(1, 3));
        this.securityPopup = new JPopupMenu();
        FWAction fWAction = new NewSecurityRuleAction();
        this.addTabAction(fWAction);
        ((FWToolBar)serializable).addAction(fWAction);
        this.securityPopup.add(fWAction);
        fWAction = new EditSecurityRuleAction();
        this.addTabAction(EDIT_SECURITY_RULE_ACTION_KEY, fWAction);
        ((FWToolBar)serializable).addAction(fWAction);
        this.securityPopup.add(fWAction);
        fWAction = new RemoveSecurityRuleAction();
        this.addTabAction(fWAction);
        ((FWToolBar)serializable).addAction(fWAction);
        this.securityPopup.add(fWAction);
    }

    public boolean isVisibleByDefault() {
        return false;
    }

    public void updateUI() {
        super.updateUI();
        if (this.securityTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.securityTableScrollPane);
        }
    }

    private SecurityRule[] getSelectedSecurityRules() {
        if (this.securityTable.getSelectedRowCount() == 0) {
            return EMPTY_SECURITYRULE_ARRAY;
        }
        int[] nArray = this.securityTable.getSelectedRows();
        int[] nArray2 = this.securityTable.convertRowIndicesToModel(nArray);
        SecurityRule[] securityRuleArray = this.securityMgr.getIPAccessRulesAt(nArray2);
        return securityRuleArray;
    }

    private void buildSecurityTableColumnModel(DTable dTable) {
        int[] nArray = SecurityTableModel.getColumnIdArray();
        DTableColumnList dTableColumnList = null;
        if (dTable != null) {
            dTableColumnList = dTable.getTableColumnList();
        }
        this.securityColumnModel = new FWTableColumnModel(this.securityModel, nArray, dTableColumnList);
    }

    public void appendDGuiSettings(DGuiSettings dGuiSettings) {
        super.appendDGuiSettings(dGuiSettings);
        DTableColumnList dTableColumnList = this.securityColumnModel.createDGuiTableColumnList();
        DTable dTable = new DTable();
        dTable.setTableColumnList(dTableColumnList);
        dTable.setTableIdentifier(SECURITY_TABLE_IDENTIFIER);
        dGuiSettings.getTableList().getTableList().add(dTable);
    }

    public class RemoveSecurityRuleAction
    extends FWAction {
        public RemoveSecurityRuleAction() {
            super(Localizer.getString("RemoveSecurityRule"), GUIRegistry.getInstance().getIconFactory().getIcon("Remove"), Localizer.getString("TTTRemoveSecurityRule"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (SecurityTab.this.securityTable.getSelectedRow() < 0) {
                    this.setEnabled(false);
                    return;
                }
                SecurityRule[] securityRuleArray = SecurityTab.this.getSelectedSecurityRules();
                for (int i = 0; i < securityRuleArray.length; ++i) {
                    if (securityRuleArray[i] == null || securityRuleArray[i].isSystemRule()) continue;
                    PhexSecurityManager.getInstance().removeSecurityRule(securityRuleArray[i]);
                }
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }

        public void refreshActionState() {
            int n = SecurityTab.this.securityTable.getSelectedRow();
            if (n < 0) {
                this.setEnabled(false);
                return;
            }
            SecurityRule[] securityRuleArray = SecurityTab.this.getSelectedSecurityRules();
            for (int i = 0; i < securityRuleArray.length; ++i) {
                if (securityRuleArray[i] == null || securityRuleArray[i].isSystemRule()) continue;
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    public class EditSecurityRuleAction
    extends FWAction {
        public EditSecurityRuleAction() {
            super(Localizer.getString("EditSecurityRule"), GUIRegistry.getInstance().getIconFactory().getIcon("Edit"), Localizer.getString("TTTEditSecurityRule"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (SecurityTab.this.securityTable.getSelectedRowCount() != 1) {
                    return;
                }
                int n = SecurityTab.this.securityTable.getSelectedRow();
                int n2 = SecurityTab.this.securityTable.convertRowIndexToModel(n);
                IPAccessRule iPAccessRule = SecurityTab.this.securityMgr.getIPAccessRule(n2);
                if (iPAccessRule == null || iPAccessRule.isSystemRule()) {
                    return;
                }
                SecurityRuleConfigDialog securityRuleConfigDialog = new SecurityRuleConfigDialog(iPAccessRule);
                securityRuleConfigDialog.show();
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }

        public void refreshActionState() {
            if (SecurityTab.this.securityTable.getSelectedRowCount() == 1) {
                int n = SecurityTab.this.securityTable.getSelectedRow();
                int n2 = SecurityTab.this.securityTable.convertRowIndexToModel(n);
                IPAccessRule iPAccessRule = SecurityTab.this.securityMgr.getIPAccessRule(n2);
                if (iPAccessRule == null || iPAccessRule.isSystemRule()) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(true);
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    public class NewSecurityRuleAction
    extends FWAction {
        public NewSecurityRuleAction() {
            super(Localizer.getString("NewSecurityRule"), GUIRegistry.getInstance().getIconFactory().getIcon("New"), Localizer.getString("TTTNewSecurityRule"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                SecurityRuleConfigDialog securityRuleConfigDialog = new SecurityRuleConfigDialog();
                securityRuleConfigDialog.show();
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }

        public void refreshActionState() {
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getSource() == SecurityTab.this.securityTable) {
                    SecurityTab.this.getTabAction(SecurityTab.EDIT_SECURITY_RULE_ACTION_KEY).actionPerformed(null);
                }
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            try {
                if (mouseEvent.isPopupTrigger()) {
                    this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            try {
                Component component;
                if (SwingUtilities.isRightMouseButton(mouseEvent) && (component = (Component)mouseEvent.getSource()) == SecurityTab.this.securityTable) {
                    Point point = mouseEvent.getPoint();
                    int n = SecurityTab.this.securityTable.rowAtPoint(point);
                    int n2 = SecurityTab.this.securityTable.columnAtPoint(point);
                    SecurityTab.this.securityTable.changeSelection(n, n2, false, false);
                }
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == SecurityTab.this.securityTable || component == SecurityTab.this.securityTableScrollPane) {
                SecurityTab.this.securityPopup.show(component, n, n2);
            }
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            try {
                SecurityTab.this.refreshTabActions();
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }
    }
}

