/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import phex.gui.common.FWElegantPanel;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.models.StatisticsTableModel;
import phex.gui.tabs.FWTab;
import phex.utils.Localizer;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;
import phex.xml.sax.gui.DTableColumnList;

public class StatisticsTab
extends FWTab {
    private static final String STATISTICS_TABLE_IDENTIFIER = "StatisticsTable";
    private StatisticsTableModel statisticsModel;
    private FWTableColumnModel statisticsColumnModel;
    private FWTable statisticsTable;
    private JScrollPane statisticsTableScrollPane;

    public StatisticsTab() {
        super(1006, Localizer.getString("Statistics"), GUIRegistry.getInstance().getIconFactory().getIcon("Statistics"), Localizer.getString("TTTStatistics"), Localizer.getChar("StatisticsMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("StatisticsAccelerator")), 6);
    }

    public void initComponent(DGuiSettings dGuiSettings) {
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, fill:p:grow, 2dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        JPanel jPanel = new JPanel();
        FWElegantPanel fWElegantPanel = new FWElegantPanel(Localizer.getString("Statistics"), jPanel);
        panelBuilder.add((Component)fWElegantPanel, cellConstraints.xy(2, 2));
        FormLayout formLayout2 = new FormLayout("fill:d:grow", "fill:d:grow");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout2, jPanel);
        this.statisticsModel = new StatisticsTableModel();
        DTable dTable = GUIUtils.getDGuiTableByIdentifier(dGuiSettings, STATISTICS_TABLE_IDENTIFIER);
        this.buildStatisticsTableColumnModel(dTable);
        this.statisticsTable = new FWTable((TableModel)new FWSortedTableModel(this.statisticsModel), this.statisticsColumnModel);
        this.statisticsTable.activateAllHeaderActions();
        this.statisticsTable.setAutoResizeMode(0);
        GUIRegistry.getInstance().getTableUpdateService().registerTable(this.statisticsTable);
        this.statisticsTableScrollPane = FWTable.createFWTableScrollPane(this.statisticsTable);
        panelBuilder2.add((Component)this.statisticsTableScrollPane, cellConstraints.xy(1, 1));
    }

    public boolean isVisibleByDefault() {
        return false;
    }

    public void updateUI() {
        super.updateUI();
        if (this.statisticsTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.statisticsTableScrollPane);
        }
    }

    private void buildStatisticsTableColumnModel(DTable dTable) {
        int[] nArray = StatisticsTableModel.getColumnIdArray();
        DTableColumnList dTableColumnList = null;
        if (dTable != null) {
            dTableColumnList = dTable.getTableColumnList();
        }
        this.statisticsColumnModel = new FWTableColumnModel(this.statisticsModel, nArray, dTableColumnList);
    }

    public void appendDGuiSettings(DGuiSettings dGuiSettings) {
        super.appendDGuiSettings(dGuiSettings);
        DTableColumnList dTableColumnList = this.statisticsColumnModel.createDGuiTableColumnList();
        DTable dTable = new DTable();
        dTable.setTableColumnList(dTableColumnList);
        dTable.setTableIdentifier(STATISTICS_TABLE_IDENTIFIER);
        dGuiSettings.getTableList().getTableList().add(dTable);
    }
}

