/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.download;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.commons.lang.SystemUtils;
import phex.common.format.NumberFormatUtils;
import phex.download.swarming.SWDownloadFile;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.IconFactory;
import phex.gui.common.MultiScopeProgressBar;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.utils.SystemShellExecute;
import phex.xml.sax.gui.DGuiSettings;

public class DownloadOverviewPanel
extends JPanel {
    private DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
    private SWDownloadFile lastDownloadFile;
    private long lastFinishedScopeLength;
    private Icon defProgressIcon;
    private Icon twinkleProgressIcon;
    private MultiScopeProgressBar progressBar;
    private JLabel progressLabel;
    private Timer resetProgressTwinkleTimer;
    private JLabel progressIconLabel;
    private JLabel downloadedLabel;
    private JLabel remainingLabel;
    private JLabel etaLabel;
    private JLabel createdLabel;
    private JLabel totalSizeLabel;
    private JLabel lastDownloadedLabel;
    private JLabel downloadRateLabel;
    private JLabel maxRateLabel;
    private JLabel downloadingCandidatesLabel;
    private JLabel queuedCandidatesLabel;
    private JLabel connectingCandidatesLabel;
    private JLabel goodCandidatesLabel;
    private JLabel badCandidatesLabel;
    private JLabel totalCandidatesLabel;
    private JTextField fileNameTxt;
    private JTextField incompleteFileTxt;

    public DownloadOverviewPanel() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DownloadOverviewPanel.this.updateInterface();
                }
                catch (Throwable throwable) {
                    NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
                }
            }
        };
        Timer timer = new Timer(2000, actionListener);
        timer.start();
    }

    public void initializeComponent(DGuiSettings dGuiSettings) {
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("6dlu, fill:d:grow, 6dlu", "6dlu, p, 6dlu, p, 6dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        JPanel jPanel = this.buildProgressPanel();
        panelBuilder.add((Component)jPanel, cellConstraints.xy(2, 2));
        JPanel jPanel2 = this.buildInfoPanel();
        panelBuilder.add((Component)jPanel2, cellConstraints.xy(2, 4));
        JPanel jPanel3 = this.buildInfo2Panel();
        panelBuilder.add((Component)jPanel3, cellConstraints.xy(2, 6));
    }

    private JPanel buildProgressPanel() {
        JPanel jPanel = new JPanel();
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("d, 2dlu, d, 2dlu, fill:d:grow, 2dlu, right:25dlu", "p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        IconFactory iconFactory = GUIRegistry.getInstance().getIconFactory();
        this.defProgressIcon = iconFactory.getIcon("PhexWizard");
        this.twinkleProgressIcon = iconFactory.getIcon("PhexWizardTwinkle");
        this.progressIconLabel = new JLabel(Localizer.getString("DownloadOverview_Progress"));
        this.progressIconLabel.setIcon(this.defProgressIcon);
        panelBuilder.add((Component)this.progressIconLabel, cellConstraints.xy(3, 1));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DownloadOverviewPanel.this.progressIconLabel.setIcon(DownloadOverviewPanel.this.defProgressIcon);
                }
                catch (Throwable throwable) {
                    NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
                }
            }
        };
        this.resetProgressTwinkleTimer = new Timer(175, actionListener);
        this.resetProgressTwinkleTimer.setRepeats(false);
        this.progressBar = new MultiScopeProgressBar();
        panelBuilder.add((Component)this.progressBar, cellConstraints.xy(5, 1));
        this.progressLabel = new JLabel(" 100 %");
        panelBuilder.add((Component)this.progressLabel, cellConstraints.xy(7, 1));
        return jPanel;
    }

    private JPanel buildInfoPanel() {
        JPanel jPanel = new JPanel();
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("d, 4dlu, right:d, fill:8dlu:grow, d, 4dlu, right:d, fill:8dlu:grow, d, 4dlu, right:d", "p, 2dlu, p, 2dlu, p, 2dlu, p, 6dlu, p, 2dlu, p, 2dlu, p");
        formLayout.setColumnGroups(new int[][]{{1, 5, 9}, {3, 7, 11}});
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        panelBuilder.addSeparator(Localizer.getString("DownloadOverview_Transfer"), cellConstraints.xywh(1, 1, formLayout.getColumnCount(), 1));
        JLabel jLabel = new JLabel(Localizer.getString("DownloadOverview_Downloaded"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(1, 3));
        this.downloadedLabel = new JLabel();
        panelBuilder.add((Component)this.downloadedLabel, cellConstraints.xy(3, 3));
        jLabel = new JLabel(Localizer.getString("DownloadOverview_Remaining"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(5, 3));
        this.remainingLabel = new JLabel();
        panelBuilder.add((Component)this.remainingLabel, cellConstraints.xy(7, 3));
        jLabel = new JLabel(Localizer.getString("DownloadOverview_DownloadRate"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(9, 3));
        this.downloadRateLabel = new JLabel();
        panelBuilder.add((Component)this.downloadRateLabel, cellConstraints.xy(11, 3));
        jLabel = new JLabel(Localizer.getString("DownloadOverview_FileSize"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(1, 5));
        this.totalSizeLabel = new JLabel();
        panelBuilder.add((Component)this.totalSizeLabel, cellConstraints.xy(3, 5));
        jLabel = new JLabel(Localizer.getString("DownloadOverview_EstimatedTime"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(5, 5));
        this.etaLabel = new JLabel();
        panelBuilder.add((Component)this.etaLabel, cellConstraints.xy(7, 5));
        jLabel = new JLabel(Localizer.getString("DownloadOverview_MaximalRate"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(9, 5));
        this.maxRateLabel = new JLabel();
        panelBuilder.add((Component)this.maxRateLabel, cellConstraints.xy(11, 5));
        jLabel = new JLabel(Localizer.getString("DownloadOverview_LastDownloaded"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(1, 7));
        this.lastDownloadedLabel = new JLabel();
        panelBuilder.add((Component)this.lastDownloadedLabel, cellConstraints.xy(3, 7));
        jLabel = new JLabel(Localizer.getString("DownloadOverview_Created"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(9, 7));
        this.createdLabel = new JLabel();
        panelBuilder.add((Component)this.createdLabel, cellConstraints.xy(11, 7));
        panelBuilder.addSeparator(Localizer.getString("DownloadOverview_Candidates"), cellConstraints.xywh(1, 9, 11, 1));
        jLabel = new JLabel(Localizer.getString("DownloadOverview_DownloadingCandidates"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(1, 11));
        this.downloadingCandidatesLabel = new JLabel();
        panelBuilder.add((Component)this.downloadingCandidatesLabel, cellConstraints.xy(3, 11));
        jLabel = new JLabel(Localizer.getString("DownloadOverview_QueuedCandidates"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(5, 11));
        this.queuedCandidatesLabel = new JLabel();
        panelBuilder.add((Component)this.queuedCandidatesLabel, cellConstraints.xy(7, 11));
        jLabel = new JLabel(Localizer.getString("DownloadOverview_ConnectingCandidates"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(9, 11));
        this.connectingCandidatesLabel = new JLabel();
        panelBuilder.add((Component)this.connectingCandidatesLabel, cellConstraints.xy(11, 11));
        jLabel = new JLabel(Localizer.getString("DownloadOverview_GoodCandidates"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(1, 13));
        this.goodCandidatesLabel = new JLabel();
        panelBuilder.add((Component)this.goodCandidatesLabel, cellConstraints.xy(3, 13));
        jLabel = new JLabel(Localizer.getString("DownloadOverview_BadCandidates"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(5, 13));
        this.badCandidatesLabel = new JLabel();
        panelBuilder.add((Component)this.badCandidatesLabel, cellConstraints.xy(7, 13));
        jLabel = new JLabel(Localizer.getString("DownloadOverview_TotalCandidates"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(9, 13));
        this.totalCandidatesLabel = new JLabel();
        panelBuilder.add((Component)this.totalCandidatesLabel, cellConstraints.xy(11, 13));
        return jPanel;
    }

    private JPanel buildInfo2Panel() {
        JPanel jPanel = new JPanel();
        CellConstraints cellConstraints = new CellConstraints();
        String string = "";
        if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC_OSX) {
            string = ", 4dlu, d";
        }
        FormLayout formLayout = new FormLayout("d, 4dlu, 1dlu:grow" + string, "p, 2dlu, p, 2dlu, p, 2dlu, p, 2dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        panelBuilder.addSeparator(Localizer.getString("DownloadOverview_Information"), cellConstraints.xywh(1, 1, formLayout.getColumnCount(), 1));
        JLabel jLabel = new JLabel(Localizer.getString("DownloadOverview_FileName"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(1, 3));
        this.fileNameTxt = new JTextField();
        this.fileNameTxt.setEditable(false);
        this.fileNameTxt.setFont(UIManager.getFont("Label.font"));
        this.fileNameTxt.setForeground(UIManager.getColor("Label.foreground"));
        this.fileNameTxt.setBackground(UIManager.getColor("Label.background"));
        this.fileNameTxt.setMinimumSize(new Dimension(0, 0));
        panelBuilder.add((Component)this.fileNameTxt, cellConstraints.xy(3, 3));
        jLabel = new JLabel(Localizer.getString("DownloadOverview_IncompleteFile"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(1, 5));
        this.incompleteFileTxt = new JTextField();
        this.incompleteFileTxt.setEditable(false);
        this.incompleteFileTxt.setFont(UIManager.getFont("Label.font"));
        this.incompleteFileTxt.setForeground(UIManager.getColor("Label.foreground"));
        this.incompleteFileTxt.setBackground(UIManager.getColor("Label.background"));
        panelBuilder.add((Component)this.incompleteFileTxt, cellConstraints.xy(3, 5));
        if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC_OSX) {
            JButton jButton = new JButton(GUIRegistry.getInstance().getIconFactory().getIcon("Explore"));
            jButton.setToolTipText(Localizer.getString("DownloadOverview_Explore"));
            jButton.setMargin(GUIUtils.EMPTY_INSETS);
            jButton.addActionListener(new ExploreActionListener());
            panelBuilder.add((Component)jButton, cellConstraints.xy(5, 5));
        }
        return jPanel;
    }

    public void updateDownloadFileInfo(SWDownloadFile sWDownloadFile) {
        this.lastDownloadFile = sWDownloadFile;
        this.lastFinishedScopeLength = this.lastDownloadFile != null ? this.lastDownloadFile.getFinishedScopeList().getAggregatedLength() : -1L;
        this.updateInterface();
    }

    private void updateInterface() {
        long l;
        if (this.lastDownloadFile == null) {
            this.progressBar.setDownloadFile(null);
            this.progressLabel.setText("");
            this.downloadedLabel.setText("");
            this.downloadedLabel.setToolTipText("");
            this.remainingLabel.setText("");
            this.remainingLabel.setToolTipText("");
            this.totalSizeLabel.setText("");
            this.totalSizeLabel.setToolTipText("");
            this.createdLabel.setText("");
            this.lastDownloadedLabel.setText("");
            this.downloadRateLabel.setText("");
            this.downloadRateLabel.setToolTipText("");
            this.maxRateLabel.setText("");
            this.downloadingCandidatesLabel.setText("");
            this.queuedCandidatesLabel.setText("");
            this.connectingCandidatesLabel.setText("");
            this.goodCandidatesLabel.setText("");
            this.badCandidatesLabel.setText("");
            this.totalCandidatesLabel.setText("");
            this.fileNameTxt.setText("");
            this.incompleteFileTxt.setText("");
            return;
        }
        this.progressBar.setDownloadFile(this.lastDownloadFile);
        this.progressLabel.setText(this.lastDownloadFile.getProgress().toString() + " %");
        this.downloadedLabel.setText(NumberFormatUtils.formatSignificantByteSize(this.lastDownloadFile.getTransferredDataSize()));
        this.downloadedLabel.setToolTipText(NumberFormatUtils.formatFullByteSize(this.lastDownloadFile.getTransferredDataSize()));
        long l2 = this.lastDownloadFile.getTotalDataSize() - this.lastDownloadFile.getTransferredDataSize();
        this.remainingLabel.setText(NumberFormatUtils.formatSignificantByteSize(l2));
        this.remainingLabel.setToolTipText(NumberFormatUtils.formatFullByteSize(l2));
        this.totalSizeLabel.setText(NumberFormatUtils.formatSignificantByteSize(this.lastDownloadFile.getTotalDataSize()));
        this.totalSizeLabel.setToolTipText(NumberFormatUtils.formatFullByteSize(this.lastDownloadFile.getTotalDataSize()));
        this.createdLabel.setText(this.dateFormat.format(this.lastDownloadFile.getCreatedDate()));
        this.lastDownloadedLabel.setText(this.dateFormat.format(this.lastDownloadFile.getDownloadedDate()));
        this.downloadRateLabel.setText(NumberFormatUtils.formatSignificantByteSize(this.lastDownloadFile.getTransferSpeed()) + Localizer.getString("PerSec"));
        this.downloadRateLabel.setToolTipText(NumberFormatUtils.formatFullByteSize(this.lastDownloadFile.getTransferSpeed()) + Localizer.getString("PerSec"));
        long l3 = this.lastDownloadFile.getDownloadThrottlingRate();
        String string = l3 >= Integer.MAX_VALUE ? Localizer.getDecimalFormatSymbols().getInfinity() : NumberFormatUtils.formatSignificantByteSize(l3) + Localizer.getString("PerSec");
        this.maxRateLabel.setText(string);
        this.downloadingCandidatesLabel.setText(String.valueOf(this.lastDownloadFile.getDownloadingCandidatesCount()));
        this.queuedCandidatesLabel.setText(String.valueOf(this.lastDownloadFile.getQueuedCandidatesCount()));
        this.connectingCandidatesLabel.setText(String.valueOf(this.lastDownloadFile.getConnectingCandidatesCount()));
        this.goodCandidatesLabel.setText(String.valueOf(this.lastDownloadFile.getGoodCandidateCount()));
        this.badCandidatesLabel.setText(String.valueOf(this.lastDownloadFile.getBadCandidateCount()));
        this.totalCandidatesLabel.setText(String.valueOf(this.lastDownloadFile.getCandidatesCount()));
        String string2 = this.lastDownloadFile.getDestinationFileName();
        if (!this.fileNameTxt.getText().equals(string2)) {
            this.fileNameTxt.setText(string2);
            this.fileNameTxt.setCaretPosition(0);
        }
        String string3 = this.lastDownloadFile.getIncompleteFile().getAbsolutePath();
        if (!this.incompleteFileTxt.getText().equals(string3)) {
            this.incompleteFileTxt.setText(string3);
            this.incompleteFileTxt.setCaretPosition(0);
        }
        if (this.lastFinishedScopeLength != (l = this.lastDownloadFile.getFinishedScopeList().getAggregatedLength())) {
            this.lastFinishedScopeLength = l;
            this.progressIconLabel.setIcon(this.twinkleProgressIcon);
            this.resetProgressTwinkleTimer.restart();
        }
    }

    public class ExploreActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (DownloadOverviewPanel.this.lastDownloadFile == null) {
                return;
            }
            File file = DownloadOverviewPanel.this.lastDownloadFile.getIncompleteFile();
            if (file == null) {
                return;
            }
            File file2 = file.getParentFile();
            try {
                SystemShellExecute.exploreFolder(file2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

