/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.download;

import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import org.apache.commons.collections.comparators.ComparableComparator;
import phex.common.ShortObj;
import phex.common.format.NumberFormatUtils;
import phex.download.DownloadScopeList;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadInfo;
import phex.download.swarming.SWDownloadSegment;
import phex.event.DownloadCandidatesChangeListener;
import phex.gui.common.GUIRegistry;
import phex.gui.common.LazyEventQueue;
import phex.gui.common.table.FWSortableTableModel;
import phex.gui.comparator.ETAComparator;
import phex.gui.comparator.HostAddressComparator;
import phex.gui.renderer.ETACellRenderer;
import phex.gui.renderer.HostAddressCellRenderer;
import phex.gui.renderer.ProgressCellRenderer;
import phex.utils.Localizer;
import phex.utils.NLogger;

public class DownloadTransferTableModel
extends FWSortableTableModel {
    public static final int HOST_COLUMN_ID = 1001;
    public static final int VENDOR_COLUMN_ID = 1002;
    public static final int FROM_COLUMN_ID = 1003;
    public static final int TO_COLUMN_ID = 1004;
    public static final int COMPLETED_COLUMN_ID = 1005;
    public static final int SIZE_COLUMN_ID = 1006;
    public static final int PROGRESS_COLUMN_ID = 1007;
    public static final int RATE_COLUMN_ID = 1008;
    public static final int ETA_COLUMN_ID = 1009;
    public static final int STATUS_COLUMN_ID = 1010;
    public static final int HOST_MODEL_INDEX = 0;
    public static final int VENDOR_MODEL_INDEX = 1;
    public static final int FROM_MODEL_INDEX = 2;
    public static final int TO_MODEL_INDEX = 3;
    public static final int COMPLETED_MODEL_INDEX = 4;
    public static final int SIZE_MODEL_INDEX = 5;
    public static final int PROGRESS_MODEL_INDEX = 6;
    public static final int RATE_MODEL_INDEX = 7;
    public static final int ETA_MODEL_INDEX = 8;
    public static final int STATUS_MODEL_INDEX = 9;
    private static String[] tableColumns = new String[]{Localizer.getString("DownloadTransfer_Host"), Localizer.getString("DownloadTransfer_Vendor"), Localizer.getString("DownloadTransfer_From"), Localizer.getString("DownloadTransfer_To"), Localizer.getString("DownloadTransfer_Completed"), Localizer.getString("DownloadTransfer_Size"), Localizer.getString("DownloadTransfer_Progress"), Localizer.getString("DownloadTransfer_Rate"), Localizer.getString("DownloadTransfer_ETA"), Localizer.getString("DownloadTransfer_Status")};
    private static Class[] tableClasses = new Class[]{HostAddressCellRenderer.class, String.class, String.class, String.class, String.class, String.class, ProgressCellRenderer.class, String.class, ETACellRenderer.class, String.class};
    private SWDownloadFile downloadFile;
    private DownloadCandidatesListener changeListener = new DownloadCandidatesListener();

    public DownloadTransferTableModel() {
        super(tableColumns, tableClasses);
    }

    public void updateDownloadFile(SWDownloadFile sWDownloadFile) {
        if (this.downloadFile == sWDownloadFile) {
            return;
        }
        if (this.downloadFile != null) {
            this.downloadFile.removeDownloadCandidatesChangeListener(this.changeListener);
        }
        this.downloadFile = sWDownloadFile;
        if (this.downloadFile != null) {
            this.downloadFile.addDownloadCandidatesChangeListener(this.changeListener);
        }
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        if (this.downloadFile == null) {
            return 0;
        }
        return this.downloadFile.getTransferCandidateCount();
    }

    public Object getValueAt(int n, int n2) {
        SWDownloadCandidate sWDownloadCandidate = this.downloadFile.getTransferCandidate(n);
        if (sWDownloadCandidate == null) {
            return "";
        }
        switch (n2) {
            case 0: {
                return sWDownloadCandidate.getHostAddress();
            }
            case 1: {
                return sWDownloadCandidate.getVendor();
            }
            case 2: {
                SWDownloadSegment sWDownloadSegment = sWDownloadCandidate.getDownloadSegment();
                if (sWDownloadSegment == null) {
                    return "";
                }
                return NumberFormatUtils.formatSize(sWDownloadSegment.getStart());
            }
            case 3: {
                SWDownloadSegment sWDownloadSegment = sWDownloadCandidate.getDownloadSegment();
                if (sWDownloadSegment == null) {
                    return "";
                }
                return NumberFormatUtils.formatSize(sWDownloadSegment.getEnd());
            }
            case 4: {
                SWDownloadSegment sWDownloadSegment = sWDownloadCandidate.getDownloadSegment();
                if (sWDownloadSegment == null) {
                    return "";
                }
                return NumberFormatUtils.formatFullByteSize(sWDownloadSegment.getTransferredDataSize());
            }
            case 5: {
                SWDownloadSegment sWDownloadSegment = sWDownloadCandidate.getDownloadSegment();
                if (sWDownloadSegment == null) {
                    return "";
                }
                return NumberFormatUtils.formatFullByteSize(sWDownloadSegment.getTotalDataSize());
            }
            case 6: {
                SWDownloadSegment sWDownloadSegment = sWDownloadCandidate.getDownloadSegment();
                if (sWDownloadSegment == null) {
                    return "";
                }
                return sWDownloadSegment.getProgress();
            }
            case 7: {
                SWDownloadSegment sWDownloadSegment = sWDownloadCandidate.getDownloadSegment();
                if (sWDownloadSegment == null) {
                    return "";
                }
                return NumberFormatUtils.formatSignificantByteSize(sWDownloadSegment.getTransferSpeed()) + Localizer.getString("PerSec");
            }
            case 8: {
                SWDownloadSegment sWDownloadSegment = sWDownloadCandidate.getDownloadSegment();
                if (sWDownloadSegment == null) {
                    return "";
                }
                return sWDownloadSegment;
            }
            case 9: {
                return SWDownloadInfo.getDownloadCandidateStatusString(sWDownloadCandidate);
            }
        }
        return "";
    }

    public Comparator getColumnComparator(int n) {
        switch (n) {
            case 0: {
                return new HostAddressComparator();
            }
            case 6: {
                return ComparableComparator.getInstance();
            }
            case 8: {
                return new ETAComparator();
            }
        }
        return null;
    }

    public Object getComparableValueAt(int n, int n2) {
        SWDownloadCandidate sWDownloadCandidate = this.downloadFile.getTransferCandidate(n);
        if (sWDownloadCandidate == null) {
            return "";
        }
        switch (n2) {
            case 2: {
                SWDownloadSegment sWDownloadSegment = sWDownloadCandidate.getDownloadSegment();
                if (sWDownloadSegment == null) {
                    return null;
                }
                return new Long(sWDownloadSegment.getStart());
            }
            case 3: {
                SWDownloadSegment sWDownloadSegment = sWDownloadCandidate.getDownloadSegment();
                if (sWDownloadSegment == null) {
                    return null;
                }
                return new Long(sWDownloadSegment.getEnd());
            }
            case 5: {
                SWDownloadSegment sWDownloadSegment = sWDownloadCandidate.getDownloadSegment();
                if (sWDownloadSegment == null) {
                    return null;
                }
                return new Long(sWDownloadSegment.getTotalDataSize());
            }
            case 6: {
                DownloadScopeList downloadScopeList = sWDownloadCandidate.getAvailableScopeList();
                if (downloadScopeList == null) {
                    return null;
                }
                return new Long(downloadScopeList.getAggregatedLength());
            }
            case 9: {
                ShortObj shortObj = sWDownloadCandidate.getStatusObj();
                if (shortObj.value == 18) {
                    int n3 = sWDownloadCandidate.getXQueueParameters().getPosition();
                    Double d = new Double(shortObj.doubleValue() + 1.0 - Math.min((double)n3, 10000.0) / 10000.0);
                    return d;
                }
                long l = sWDownloadCandidate.getStatusTimeLeft();
                return new Double(shortObj.doubleValue() + (double)l / 1000000.0);
            }
            case 7: {
                SWDownloadSegment sWDownloadSegment = sWDownloadCandidate.getDownloadSegment();
                if (sWDownloadSegment == null) {
                    return null;
                }
                return new Long(sWDownloadSegment.getTransferSpeed());
            }
            case 8: {
                SWDownloadSegment sWDownloadSegment = sWDownloadCandidate.getDownloadSegment();
                return sWDownloadSegment;
            }
        }
        return this.getValueAt(n, n2);
    }

    public int mapColumnIDToModelIndex(int n) {
        switch (n) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1004: {
                return 3;
            }
            case 1006: {
                return 5;
            }
            case 1005: {
                return 4;
            }
            case 1007: {
                return 6;
            }
            case 1008: {
                return 7;
            }
            case 1009: {
                return 8;
            }
            case 1010: {
                return 9;
            }
        }
        NLogger.error("USER_INTERFACE", "Invalid column id: " + n);
        return -1;
    }

    public boolean isColumnHideable(int n) {
        return n != 1001;
    }

    public static int[] getColumnIdArray() {
        int[] nArray = new int[]{1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010};
        return nArray;
    }

    private class DownloadCandidatesListener
    implements DownloadCandidatesChangeListener {
        private LazyEventQueue lazyEventQueue = GUIRegistry.getInstance().getLazyEventQueue();

        public void downloadCandidateChanged(int n) {
            DownloadTransferTableModel.this.fireTableCellUpdated(n, n);
        }

        public void downloadCandidateAdded(int n) {
            DownloadTransferTableModel.this.fireTableChanged(new TableModelEvent(DownloadTransferTableModel.this, n, n, -1, 1));
        }

        public void downloadCandidateRemoved(int n) {
            DownloadTransferTableModel.this.fireTableChanged(new TableModelEvent(DownloadTransferTableModel.this, n, n, -1, -1));
        }
    }
}

