/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.download;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import phex.chat.ChatManager;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.common.format.NumberFormatUtils;
import phex.common.log.LogBuffer;
import phex.download.strategy.AvailBeginRandSelectionStrategy;
import phex.download.strategy.BeginAvailRandSelectionStrategy;
import phex.download.strategy.BeginEndAvailRandSelectionStrategy;
import phex.download.strategy.RandomScopeSelectionStrategy;
import phex.download.strategy.ScopeSelectionStrategy;
import phex.download.strategy.ScopeSelectionStrategyProvider;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.event.DownloadFilesChangeListener;
import phex.gui.actions.BanHostActionUtils;
import phex.gui.actions.FWAction;
import phex.gui.actions.FWToggleAction;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.BrowserLauncher;
import phex.gui.common.FWElegantPanel;
import phex.gui.common.FWMenu;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.MainFrame;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.dialogs.DownloadConfigDialog;
import phex.gui.dialogs.LogBufferDialog;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.download.DownloadOverviewPanel;
import phex.gui.tabs.download.DownloadTransfersPanel;
import phex.gui.tabs.download.SWCandidateTableModel;
import phex.gui.tabs.download.SWDownloadTableModel;
import phex.query.ResearchSetting;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.utils.SystemShellExecute;
import phex.utils.URLUtil;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;
import phex.xml.sax.gui.DTableColumnList;

public class SWDownloadTab
extends FWTab {
    private static final String DOWNLOAD_TABLE_IDENTIFIER = "DownloadTable";
    private static final String CANDIDATE_TABLE_IDENTIFIER = "CandidateTable";
    private static final SWDownloadFile[] EMPTY_DOWNLOADFILE_ARRAY = new SWDownloadFile[0];
    private static final SWDownloadCandidate[] EMPTY_DOWNLOADCANDIDATE_ARRAY = new SWDownloadCandidate[0];
    private SwarmingManager swarmingMgr = SwarmingManager.getInstance();
    private FWTable downloadTable;
    private JScrollPane downloadTableScrollPane;
    private FWTableColumnModel downloadColumnModel;
    private SWDownloadTableModel downloadModel;
    private JTabbedPane downloadDetails;
    private JPopupMenu downloadPopup;
    private JMenu downloadPopupSpeedMenu;
    private FWElegantPanel overviewElegantPanel;
    private DownloadOverviewPanel downloadOverviewPanel;
    private FWElegantPanel transfersElegantPanel;
    private DownloadTransfersPanel transfersPanel;
    private PanelBuilder candidatePanelBuilder;
    private FWElegantPanel candidateElegantPanel;
    private FWTable candidateTable;
    private JScrollPane candidateTableScrollPane;
    private FWTableColumnModel candidateColumnModel;
    private SWCandidateTableModel candidateModel;
    private JPopupMenu candidatePopup;
    private MainFrame mainFrame;

    public SWDownloadTab(MainFrame mainFrame) {
        super(1003, Localizer.getString("Download"), GUIRegistry.getInstance().getIconFactory().getIcon("Download"), Localizer.getString("TTTDownloadTab"), Localizer.getChar("DownloadMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("DownloadAccelerator")), 2);
        this.swarmingMgr.addDownloadFilesChangeListener(new DownloadFilesChangeHandler());
        this.mainFrame = mainFrame;
    }

    public void initComponent(DGuiSettings dGuiSettings) {
        MouseHandler mouseHandler = new MouseHandler();
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, fill:d:grow, 2dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        JPanel jPanel = this.initDownloadTablePanel(dGuiSettings, mouseHandler);
        this.initDownloadOverviewPanel();
        JPanel jPanel2 = this.initDownloadCandidatePanel(dGuiSettings, mouseHandler);
        this.initDownloadTransferPanel(dGuiSettings);
        this.downloadDetails = new JTabbedPane(3);
        this.downloadDetails.putClientProperty("jgoodies.embeddedTabs", Boolean.TRUE);
        this.downloadDetails.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.downloadDetails.addTab(Localizer.getString("DownloadTab_Overview"), this.overviewElegantPanel);
        this.downloadDetails.addTab(Localizer.getString("DownloadTab_Transfers"), this.transfersElegantPanel);
        this.downloadDetails.addTab(Localizer.getString("Candidates"), jPanel2);
        Dimension dimension = new Dimension(400, 300);
        jPanel.setPreferredSize(dimension);
        this.downloadDetails.setPreferredSize(dimension);
        dimension = new Dimension(0, 0);
        jPanel.setMinimumSize(dimension);
        this.downloadDetails.setMinimumSize(dimension);
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, this.downloadDetails);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jSplitPane.setDividerSize(4);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setDividerLocation(0.5);
        jSplitPane.setResizeWeight(0.5);
        panelBuilder.add((Component)jSplitPane, cellConstraints.xy(2, 2));
        GUIUtils.adjustTableProgresssBarHeight(this.downloadTable);
        GUIUtils.adjustTableProgresssBarHeight(this.candidateTable);
    }

    private void initDownloadOverviewPanel() {
        this.downloadOverviewPanel = new DownloadOverviewPanel();
        this.downloadOverviewPanel.initializeComponent(null);
        this.overviewElegantPanel = new FWElegantPanel(Localizer.getString("DownloadTab_DownloadOverview"), this.downloadOverviewPanel);
    }

    private void initDownloadTransferPanel(DGuiSettings dGuiSettings) {
        this.transfersPanel = new DownloadTransfersPanel();
        this.transfersPanel.initializeComponent(dGuiSettings);
        this.transfersElegantPanel = new FWElegantPanel(Localizer.getString("DownloadTab_DownloadTransfers"), this.transfersPanel);
    }

    private JPanel initDownloadCandidatePanel(DGuiSettings dGuiSettings, MouseHandler mouseHandler) {
        JPanel jPanel = new JPanel();
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("fill:d:grow", "fill:d:grow, 1dlu, p");
        this.candidatePanelBuilder = new PanelBuilder(formLayout, jPanel);
        this.candidateModel = new SWCandidateTableModel(this.downloadTable);
        DTable dTable = GUIUtils.getDGuiTableByIdentifier(dGuiSettings, CANDIDATE_TABLE_IDENTIFIER);
        this.buildCandidateTableColumnModel(dTable);
        this.candidateTable = new FWTable((TableModel)new FWSortedTableModel(this.candidateModel), this.candidateColumnModel);
        this.candidateTable.activateAllHeaderActions();
        this.candidateTable.getSelectionModel().addListSelectionListener(new CandidateSelectionHandler());
        this.candidateTable.setAutoResizeMode(0);
        this.candidateTable.addMouseListener(mouseHandler);
        GUIRegistry.getInstance().getTableUpdateService().registerTable(this.candidateTable);
        this.candidateTableScrollPane = FWTable.createFWTableScrollPane(this.candidateTable);
        this.candidateTableScrollPane.addMouseListener(mouseHandler);
        this.candidatePanelBuilder.add((Component)this.candidateTableScrollPane, cellConstraints.xy(1, 1));
        FWToolBar fWToolBar = new FWToolBar(0);
        fWToolBar.setBorderPainted(false);
        fWToolBar.setFloatable(false);
        this.candidatePanelBuilder.add((Component)fWToolBar, cellConstraints.xy(1, 3));
        this.candidatePopup = new JPopupMenu();
        FWAction fWAction = new RetryCandidateAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.candidatePopup.add(fWAction);
        fWAction = new RemoveCandidateAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.candidatePopup.add(fWAction);
        this.candidateTable.getActionMap().put(fWAction, fWAction);
        this.candidateTable.getInputMap(1).put((KeyStroke)fWAction.getValue("AcceleratorKey"), fWAction);
        this.candidatePopup.addSeparator();
        fWToolBar.addSeparator();
        fWAction = new AddToFavoritesAction();
        this.addTabAction(fWAction);
        this.candidatePopup.add(fWAction);
        fWAction = new BrowseHostAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.candidatePopup.add(fWAction);
        fWAction = new ChatToHostAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.candidatePopup.add(fWAction);
        BanHostActionProvider banHostActionProvider = new BanHostActionProvider();
        BanHostActionUtils.BanHostActionMenu banHostActionMenu = BanHostActionUtils.createActionMenu(banHostActionProvider);
        this.candidatePopup.add(banHostActionMenu.menu);
        this.addTabActions(banHostActionMenu.actions);
        fWAction = BanHostActionUtils.createToolBarAction(banHostActionProvider);
        fWToolBar.addAction(fWAction);
        this.addTabAction(fWAction);
        if (ServiceManager.sCfg.downloadCandidateLogBufferSize > 0L) {
            fWAction = new CandidateLogAction();
            this.addTabAction(fWAction);
            fWToolBar.addAction(fWAction);
            this.candidatePopup.add(fWAction);
        }
        this.candidateElegantPanel = new FWElegantPanel(Localizer.getString("DownloadCandidates"), jPanel);
        return this.candidateElegantPanel;
    }

    private JPanel initDownloadTablePanel(DGuiSettings dGuiSettings, MouseHandler mouseHandler) {
        JPanel jPanel = new JPanel();
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("fill:d:grow", "fill:d:grow, 1dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        this.downloadModel = new SWDownloadTableModel();
        DTable dTable = GUIUtils.getDGuiTableByIdentifier(dGuiSettings, DOWNLOAD_TABLE_IDENTIFIER);
        this.buildDownloadTableColumnModel(dTable);
        this.downloadTable = new FWTable((TableModel)new FWSortedTableModel(this.downloadModel), this.downloadColumnModel);
        this.downloadTable.activateAllHeaderActions();
        this.downloadTable.setAutoResizeMode(0);
        this.downloadTable.getSelectionModel().addListSelectionListener(new DownloadSelectionHandler());
        this.downloadTable.addMouseListener(mouseHandler);
        GUIRegistry.getInstance().getTableUpdateService().registerTable(this.downloadTable);
        this.downloadTableScrollPane = FWTable.createFWTableScrollPane(this.downloadTable);
        this.downloadTableScrollPane.addMouseListener(mouseHandler);
        panelBuilder.add((Component)this.downloadTableScrollPane, cellConstraints.xy(1, 1));
        FWToolBar fWToolBar = new FWToolBar(0);
        fWToolBar.setBorderPainted(false);
        fWToolBar.setFloatable(false);
        panelBuilder.add((Component)fWToolBar, cellConstraints.xy(1, 3));
        this.downloadPopup = new JPopupMenu();
        FWAction fWAction = new StartDownloadAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.downloadPopup.add(fWAction);
        fWAction = new StopDownloadAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.downloadPopup.add(fWAction);
        fWAction = new RemoveDownloadAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.downloadPopup.add(fWAction);
        this.downloadTable.getActionMap().put(fWAction, fWAction);
        this.downloadTable.getInputMap(1).put((KeyStroke)fWAction.getValue("AcceleratorKey"), fWAction);
        fWToolBar.addSeparator();
        this.downloadPopup.addSeparator();
        fWAction = new ConfigureDownloadAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.downloadPopup.add(fWAction);
        fWAction = new SearchCandidatesAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.downloadPopup.add(fWAction);
        this.downloadPopupSpeedMenu = new JMenu(Localizer.getString("DownloadTab_DownloadSpeed"));
        this.downloadPopup.add(this.downloadPopupSpeedMenu);
        JMenu jMenu = new JMenu(Localizer.getString("Priority"));
        fWAction = new MoveDownloadPriorityAction(0);
        jMenu.add(fWAction);
        this.addTabAction(fWAction);
        fWAction = new MoveDownloadPriorityAction(1);
        jMenu.add(fWAction);
        this.addTabAction(fWAction);
        fWAction = new MoveDownloadPriorityAction(100);
        jMenu.add(fWAction);
        this.addTabAction(fWAction);
        fWAction = new MoveDownloadPriorityAction(2);
        jMenu.add(fWAction);
        this.addTabAction(fWAction);
        fWAction = new MoveDownloadPriorityAction(3);
        jMenu.add(fWAction);
        this.addTabAction(fWAction);
        this.downloadPopup.add(jMenu);
        FWMenu fWMenu = new FWMenu(Localizer.getString("DownloadTab_Strategy"));
        fWAction = new SelectStrategyAction(0);
        fWMenu.addAction(fWAction);
        this.addTabAction(fWAction);
        fWAction = new SelectStrategyAction(1);
        fWMenu.addAction(fWAction);
        this.addTabAction(fWAction);
        fWAction = new SelectStrategyAction(2);
        fWMenu.addAction(fWAction);
        this.addTabAction(fWAction);
        fWAction = new SelectStrategyAction(3);
        fWMenu.addAction(fWAction);
        this.addTabAction(fWAction);
        this.downloadPopup.add(fWMenu);
        fWAction = new GeneratePreviewAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.downloadPopup.add(fWAction);
        fWAction = new ViewBitziTicketAction();
        this.addTabAction(fWAction);
        this.downloadPopup.add(fWAction);
        FWElegantPanel fWElegantPanel = new FWElegantPanel(Localizer.getString("DownloadFiles"), jPanel);
        return fWElegantPanel;
    }

    public void updateUI() {
        super.updateUI();
        if (this.downloadTable != null) {
            GUIUtils.adjustTableProgresssBarHeight(this.downloadTable);
        }
        if (this.downloadTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.downloadTableScrollPane);
        }
        if (this.candidateTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.candidateTableScrollPane);
        }
    }

    private void updateDownloadFileInfo(int n) {
        int n2 = this.downloadTable.getSelectedRow();
        int n3 = this.downloadTable.convertRowIndexToModel(n2);
        this.refreshTabActions();
        SWDownloadFile sWDownloadFile = this.swarmingMgr.getDownloadFile(n3);
        this.downloadOverviewPanel.updateDownloadFileInfo(sWDownloadFile);
        this.transfersPanel.updateDownloadFile(sWDownloadFile);
        if (n3 == n && sWDownloadFile != null) {
            ResearchSetting researchSetting = sWDownloadFile.getResearchSetting();
            if (researchSetting.isSearchRunning()) {
                Object[] objectArray = new Object[]{new Integer(researchSetting.getSearchHitCount()), new Integer(researchSetting.getSearchProgress())};
                StringBuffer stringBuffer = new StringBuffer(Localizer.getString("DownloadCandidates"));
                stringBuffer.append(' ');
                stringBuffer.append(Localizer.getFormatedString("CandidatesSearchingExt", objectArray));
                this.candidateElegantPanel.setTitle(stringBuffer.toString());
            } else {
                this.candidateElegantPanel.setTitle(Localizer.getString("DownloadCandidates"));
            }
        }
    }

    private SWDownloadFile[] getSelectedDownloadFiles() {
        if (this.downloadTable.getSelectedRowCount() == 0) {
            return EMPTY_DOWNLOADFILE_ARRAY;
        }
        int[] nArray = this.downloadTable.getSelectedRows();
        int[] nArray2 = this.downloadTable.convertRowIndicesToModel(nArray);
        SWDownloadFile[] sWDownloadFileArray = this.swarmingMgr.getDownloadFilesAt(nArray2);
        return sWDownloadFileArray;
    }

    private SWDownloadFile getSelectedDownloadFile() {
        int n = this.downloadTable.getSelectedRow();
        if (n < 0) {
            return null;
        }
        int n2 = this.downloadTable.convertRowIndexToModel(n);
        SWDownloadFile sWDownloadFile = this.swarmingMgr.getDownloadFile(n2);
        return sWDownloadFile;
    }

    private SWDownloadCandidate[] getSelectedDownloadCandidates() {
        if (this.candidateTable.getSelectedRowCount() == 0) {
            return EMPTY_DOWNLOADCANDIDATE_ARRAY;
        }
        int[] nArray = this.candidateTable.getSelectedRows();
        int[] nArray2 = this.candidateTable.convertRowIndicesToModel(nArray);
        SWDownloadCandidate[] sWDownloadCandidateArray = new SWDownloadCandidate[nArray2.length];
        SWDownloadFile sWDownloadFile = this.candidateModel.getDownloadFile();
        for (int i = 0; i < sWDownloadCandidateArray.length; ++i) {
            sWDownloadCandidateArray[i] = sWDownloadFile.getCandidate(nArray2[i]);
        }
        return sWDownloadCandidateArray;
    }

    private SWDownloadCandidate getSelectedDownloadCandidate() {
        int n = this.candidateTable.getSelectedRow();
        int n2 = this.candidateTable.convertRowIndexToModel(n);
        if (n2 < 0) {
            return null;
        }
        SWDownloadFile sWDownloadFile = this.candidateModel.getDownloadFile();
        SWDownloadCandidate sWDownloadCandidate = sWDownloadFile.getCandidate(n2);
        return sWDownloadCandidate;
    }

    private void buildDownloadTableColumnModel(DTable dTable) {
        int[] nArray = SWDownloadTableModel.getColumnIdArray();
        DTableColumnList dTableColumnList = null;
        if (dTable != null) {
            dTableColumnList = dTable.getTableColumnList();
        }
        this.downloadColumnModel = new FWTableColumnModel(this.downloadModel, nArray, dTableColumnList);
    }

    private void buildCandidateTableColumnModel(DTable dTable) {
        int[] nArray = SWCandidateTableModel.getColumnIdArray();
        DTableColumnList dTableColumnList = null;
        if (dTable != null) {
            dTableColumnList = dTable.getTableColumnList();
        }
        this.candidateColumnModel = new FWTableColumnModel(this.candidateModel, nArray, dTableColumnList);
    }

    public void appendDGuiSettings(DGuiSettings dGuiSettings) {
        super.appendDGuiSettings(dGuiSettings);
        DTableColumnList dTableColumnList = this.downloadColumnModel.createDGuiTableColumnList();
        DTable dTable = new DTable();
        dTable.setTableColumnList(dTableColumnList);
        dTable.setTableIdentifier(DOWNLOAD_TABLE_IDENTIFIER);
        dGuiSettings.getTableList().getTableList().add(dTable);
        dTableColumnList = this.candidateColumnModel.createDGuiTableColumnList();
        dTable = new DTable();
        dTable.setTableColumnList(dTableColumnList);
        dTable.setTableIdentifier(CANDIDATE_TABLE_IDENTIFIER);
        dGuiSettings.getTableList().getTableList().add(dTable);
        this.transfersPanel.appendDGuiSettings(dGuiSettings);
    }

    private class CandidateLogAction
    extends FWAction {
        public CandidateLogAction() {
            super(Localizer.getString("DownloadTab_ViewLog"), null, Localizer.getString("DownloadTab_TTTViewLog"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                SWDownloadCandidate sWDownloadCandidate = SWDownloadTab.this.getSelectedDownloadCandidate();
                LogBuffer logBuffer = SwarmingManager.getInstance().getCandidateLogBuffer();
                Collection collection = logBuffer.getLogRecords(sWDownloadCandidate);
                if (collection != null) {
                    LogBufferDialog logBufferDialog = new LogBufferDialog(collection);
                    logBufferDialog.setVisible(true);
                }
            }
            catch (Throwable throwable) {
                NLogger.error("Download", (Object)throwable, throwable);
            }
        }

        public void refreshActionState() {
            SWDownloadCandidate sWDownloadCandidate;
            if (SWDownloadTab.this.candidateTable.getSelectedRowCount() == 1 && (sWDownloadCandidate = SWDownloadTab.this.getSelectedDownloadCandidate()) != null) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class SearchCandidatesAction
    extends FWAction {
        public SearchCandidatesAction() {
            super(Localizer.getString("Search"), GUIRegistry.getInstance().getIconFactory().getIcon("Search"), Localizer.getString("TTTSearchCandidates"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                int n = SWDownloadTab.this.downloadTable.getSelectedRow();
                int n2 = SWDownloadTab.this.downloadTable.convertRowIndexToModel(n);
                SWDownloadFile sWDownloadFile = SWDownloadTab.this.swarmingMgr.getDownloadFile(n2);
                sWDownloadFile.startSearchForCandidates();
            }
            catch (Throwable throwable) {
                NLogger.error("Download", (Object)throwable, throwable);
            }
        }

        public void refreshActionState() {
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() != 1) {
                this.setEnabled(false);
                return;
            }
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.downloadTable.convertRowIndexToModel(n);
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.swarmingMgr.getDownloadFile(n2);
            if (sWDownloadFile == null) {
                this.setEnabled(false);
            } else if (sWDownloadFile.getResearchSetting().isSearchRunning() || sWDownloadFile.isFileCompletedOrMoved()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class AddToFavoritesAction
    extends FWAction {
        public AddToFavoritesAction() {
            super(Localizer.getString("AddToFavorites"), GUIRegistry.getInstance().getIconFactory().getIcon("FavoriteHost"), Localizer.getString("TTTAddToFavorites"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadCandidate[] sWDownloadCandidateArray = SWDownloadTab.this.getSelectedDownloadCandidates();
            DestAddress[] destAddressArray = new DestAddress[sWDownloadCandidateArray.length];
            for (int i = 0; i < sWDownloadCandidateArray.length; ++i) {
                destAddressArray[i] = sWDownloadCandidateArray[i].getHostAddress();
            }
            GUIActionPerformer.addHostsToFavorites(destAddressArray);
        }

        public void refreshActionState() {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.candidateTable.getSelectedRow();
            if (n < 0 || n2 < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private final class BanHostActionProvider
    implements BanHostActionUtils.BanHostActionProvider {
        private BanHostActionProvider() {
        }

        public DestAddress[] getBanHostAddresses() {
            SWDownloadCandidate[] sWDownloadCandidateArray = SWDownloadTab.this.getSelectedDownloadCandidates();
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.candidateModel.getDownloadFile();
            DestAddress[] destAddressArray = new DestAddress[sWDownloadCandidateArray.length];
            for (int i = 0; i < sWDownloadCandidateArray.length; ++i) {
                sWDownloadFile.stopDownload(sWDownloadCandidateArray[i]);
                sWDownloadFile.markCandidateIgnored(sWDownloadCandidateArray[i], "CandidateStatusReason_ByUser");
                destAddressArray[i] = sWDownloadCandidateArray[i].getHostAddress();
            }
            return destAddressArray;
        }

        public boolean isBanHostActionEnabled(boolean bl) {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.candidateTable.getSelectedRow();
            return n >= 0 && n2 >= 0 && (bl || SWDownloadTab.this.candidateTable.getSelectedRowCount() <= 1);
        }
    }

    private class BrowseHostAction
    extends FWAction {
        public BrowseHostAction() {
            super(Localizer.getString("BrowseHost"), GUIRegistry.getInstance().getIconFactory().getIcon("BrowseHost"), Localizer.getString("TTTBrowseHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadCandidate sWDownloadCandidate = SWDownloadTab.this.getSelectedDownloadCandidate();
            if (sWDownloadCandidate == null) {
                return;
            }
            GUIActionPerformer.browseHost(sWDownloadCandidate.getHostAddress());
        }

        public void refreshActionState() {
            SWDownloadCandidate sWDownloadCandidate;
            if (SWDownloadTab.this.candidateTable.getSelectedRowCount() == 1 && (sWDownloadCandidate = SWDownloadTab.this.getSelectedDownloadCandidate()) != null) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class ChatToHostAction
    extends FWAction {
        public ChatToHostAction() {
            super(Localizer.getString("ChatToHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Chat"), Localizer.getString("TTTChatToHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadCandidate sWDownloadCandidate = SWDownloadTab.this.getSelectedDownloadCandidate();
            if (sWDownloadCandidate == null) {
                return;
            }
            if (!sWDownloadCandidate.isChatSupported()) {
                return;
            }
            ChatManager.getInstance().openChat(sWDownloadCandidate.getHostAddress());
        }

        public void refreshActionState() {
            SWDownloadCandidate sWDownloadCandidate;
            if (SWDownloadTab.this.candidateTable.getSelectedRowCount() == 1 && (sWDownloadCandidate = SWDownloadTab.this.getSelectedDownloadCandidate()) != null && sWDownloadCandidate.isChatSupported()) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    class RetryCandidateAction
    extends FWAction {
        RetryCandidateAction() {
            super(Localizer.getString("RetryCandidate"), GUIRegistry.getInstance().getIconFactory().getIcon("ReconnectHost"), Localizer.getString("TTTRetryCandidate"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadCandidate[] sWDownloadCandidateArray = SWDownloadTab.this.getSelectedDownloadCandidates();
            for (int i = 0; i < sWDownloadCandidateArray.length; ++i) {
                sWDownloadCandidateArray[i].manualConnectionRetry();
            }
        }

        public void refreshActionState() {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.candidateTable.getSelectedRow();
            if (n < 0 || n2 < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    class RemoveCandidateAction
    extends FWAction {
        RemoveCandidateAction() {
            super(Localizer.getString("RemoveCandidate"), GUIRegistry.getInstance().getIconFactory().getIcon("Remove"), Localizer.getString("TTTRemoveCandidate"), null, KeyStroke.getKeyStroke(127, 0));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadCandidate[] sWDownloadCandidateArray = SWDownloadTab.this.getSelectedDownloadCandidates();
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.candidateModel.getDownloadFile();
            Runnable runnable = new Runnable(this, sWDownloadCandidateArray, sWDownloadFile){
                private final /* synthetic */ SWDownloadCandidate[] val$candidates;
                private final /* synthetic */ SWDownloadFile val$file;
                private final /* synthetic */ RemoveCandidateAction this$1;
                {
                    this.this$1 = removeCandidateAction;
                    this.val$candidates = sWDownloadCandidateArray;
                    this.val$file = sWDownloadFile;
                }

                public void run() {
                    try {
                        for (int i = 0; i < this.val$candidates.length; ++i) {
                            this.val$file.stopDownload(this.val$candidates[i]);
                            this.val$file.markCandidateIgnored(this.val$candidates[i], "CandidateStatusReason_ByUser");
                        }
                        this.this$1.refreshActionState();
                    }
                    catch (Throwable throwable) {
                        NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
                    }
                }
            };
            ThreadPool.getInstance().addJob(runnable, "RemoveDownloadCandidate");
        }

        public void refreshActionState() {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.candidateTable.getSelectedRow();
            if (n < 0 || n2 < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class ViewBitziTicketAction
    extends FWAction {
        public ViewBitziTicketAction() {
            super(Localizer.getString("ViewBitziTicket"), GUIRegistry.getInstance().getIconFactory().getIcon("Bitzi"), Localizer.getString("TTTViewBitziTicket"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block4: {
                SWDownloadFile sWDownloadFile = SWDownloadTab.this.getSelectedDownloadFile();
                if (sWDownloadFile == null) {
                    return;
                }
                URN uRN = sWDownloadFile.getFileURN();
                if (uRN == null) {
                    return;
                }
                String string = URLUtil.buildBitziLookupURL(uRN);
                try {
                    BrowserLauncher.openURL(string);
                }
                catch (IOException iOException) {
                    NLogger.warn("USER_INTERFACE", (Object)iOException, (Throwable)iOException);
                    Object[] objectArray = new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                    int n = JOptionPane.showOptionDialog(SWDownloadTab.this, Localizer.getString("FailedToLaunchBrowserURLInClipboard"), Localizer.getString("FailedToLaunchBrowser"), 0, 2, null, objectArray, Localizer.getString("Yes"));
                    if (n != 0) break block4;
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
                }
            }
        }

        public void refreshActionState() {
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class GeneratePreviewAction
    extends FWAction {
        GeneratePreviewAction() {
            super(Localizer.getString("DownloadTab_PreviewDownload"), GUIRegistry.getInstance().getIconFactory().getIcon("Open"), Localizer.getString("DownloadTab_TTTPreviewDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                SWDownloadFile sWDownloadFile = SWDownloadTab.this.getSelectedDownloadFile();
                if (sWDownloadFile == null) {
                    return;
                }
                Runnable runnable = new Runnable(this, sWDownloadFile){
                    private final /* synthetic */ SWDownloadFile val$file;
                    private final /* synthetic */ GeneratePreviewAction this$1;
                    {
                        this.this$1 = generatePreviewAction;
                        this.val$file = sWDownloadFile;
                    }

                    public void run() {
                        try {
                            File file = this.val$file.getPreviewFile();
                            SystemShellExecute.launchFile(file);
                        }
                        catch (Throwable throwable) {
                            NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
                        }
                    }
                };
                ThreadPool.getInstance().addJob(runnable, "GenerateDownloadPreview");
            }
            catch (Throwable throwable) {
                NLogger.error("Download", (Object)throwable, throwable);
            }
        }

        public void refreshActionState() {
            try {
                SWDownloadFile sWDownloadFile = SWDownloadTab.this.getSelectedDownloadFile();
                if (sWDownloadFile == null) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(sWDownloadFile.isPreviewPossible());
                }
            }
            catch (Throwable throwable) {
                NLogger.error("Download", (Object)throwable, throwable);
            }
        }
    }

    class SelectStrategyAction
    extends FWToggleAction {
        private static final short AVAILABILITY = 0;
        private static final short PRIORITIZE_BEGINNING = 1;
        private static final short PRIORITIZE_BEGINNING_END = 2;
        private static final short RANDOM = 3;
        private short strategy;

        SelectStrategyAction(short s) {
            this.strategy = s;
            switch (s) {
                case 0: {
                    this.setName(Localizer.getString("DownloadTab_StrategyAvailability"));
                    break;
                }
                case 1: {
                    this.setName(Localizer.getString("DownloadTab_StrategyBeginning"));
                    break;
                }
                case 2: {
                    this.setName(Localizer.getString("DownloadTab_StrategyBeginningEnd"));
                    break;
                }
                case 3: {
                    this.setName(Localizer.getString("DownloadTab_StrategyRandom"));
                }
            }
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ScopeSelectionStrategy scopeSelectionStrategy;
            switch (this.strategy) {
                case 0: {
                    scopeSelectionStrategy = ScopeSelectionStrategyProvider.getAvailBeginRandSelectionStrategy();
                    break;
                }
                case 1: {
                    scopeSelectionStrategy = ScopeSelectionStrategyProvider.getBeginAvailRandSelectionStrategy();
                    break;
                }
                case 2: {
                    scopeSelectionStrategy = ScopeSelectionStrategyProvider.getBeginEndAvailRandSelectionStrategy();
                    break;
                }
                default: {
                    scopeSelectionStrategy = ScopeSelectionStrategyProvider.getRandomSelectionStrategy();
                }
            }
            SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.this.getSelectedDownloadFiles();
            for (int i = 0; i < sWDownloadFileArray.length; ++i) {
                if (sWDownloadFileArray[i] == null) continue;
                sWDownloadFileArray[i].setScopeSelectionStrategy(scopeSelectionStrategy);
            }
        }

        public void refreshActionState() {
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
                SWDownloadFile sWDownloadFile = SWDownloadTab.this.getSelectedDownloadFile();
                if (sWDownloadFile == null) {
                    this.setSelected(false);
                }
                ScopeSelectionStrategy scopeSelectionStrategy = sWDownloadFile.getScopeSelectionStrategy();
                switch (this.strategy) {
                    case 0: {
                        this.setSelected(scopeSelectionStrategy instanceof AvailBeginRandSelectionStrategy);
                        break;
                    }
                    case 1: {
                        this.setSelected(scopeSelectionStrategy instanceof BeginAvailRandSelectionStrategy);
                        break;
                    }
                    case 2: {
                        this.setSelected(scopeSelectionStrategy instanceof BeginEndAvailRandSelectionStrategy);
                        break;
                    }
                    default: {
                        this.setSelected(scopeSelectionStrategy instanceof RandomScopeSelectionStrategy);
                        break;
                    }
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    class MoveDownloadPriorityAction
    extends FWAction {
        private static final short PRIORITY_MOVE_TO_TOP = 0;
        private static final short PRIORITY_MOVE_UP = 1;
        private static final short PRIORITY_MOVE_DOWN = 2;
        private static final short PRIORITY_MOVE_TO_BOTTOM = 3;
        private static final short PRIORITY_RESORT = 100;
        private short moveDirection;

        MoveDownloadPriorityAction(short s) {
            this.moveDirection = s;
            switch (s) {
                case 0: {
                    this.setName(Localizer.getString("MoveToTop"));
                    this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("MoveToTop"));
                    this.setToolTipText(Localizer.getString("TTTMoveToTop"));
                    break;
                }
                case 1: {
                    this.setName(Localizer.getString("MoveUp"));
                    this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("MoveUp"));
                    this.setToolTipText(Localizer.getString("TTTMoveUp"));
                    break;
                }
                case 2: {
                    this.setName(Localizer.getString("MoveDown"));
                    this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("MoveDown"));
                    this.setToolTipText(Localizer.getString("TTTMoveDown"));
                    break;
                }
                case 3: {
                    this.setName(Localizer.getString("MoveToBottom"));
                    this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("MoveToBottom"));
                    this.setToolTipText(Localizer.getString("TTTMoveToBottom"));
                    break;
                }
                case 100: {
                    this.setName(Localizer.getString("Resort"));
                    this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("Resort"));
                    this.setToolTipText(Localizer.getString("TTTResort"));
                }
            }
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (this.moveDirection == 100) {
                    this.performPriorityResort();
                } else {
                    this.performPriorityUpdate();
                }
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }

        private void performPriorityResort() {
            int[] nArray = new int[SWDownloadTab.this.downloadTable.getRowCount()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
            int[] nArray2 = SWDownloadTab.this.downloadTable.convertRowIndicesToModel(nArray);
            Runnable runnable = new Runnable(this, nArray2){
                private final /* synthetic */ int[] val$modelIndices;
                private final /* synthetic */ MoveDownloadPriorityAction this$1;
                {
                    this.this$1 = moveDownloadPriorityAction;
                    this.val$modelIndices = nArray;
                }

                public void run() {
                    try {
                        SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.access$1200(MoveDownloadPriorityAction.access$1500(this.this$1)).getDownloadFilesAt(this.val$modelIndices);
                        SWDownloadTab.access$1200(MoveDownloadPriorityAction.access$1500(this.this$1)).updateDownloadFilePriorities(sWDownloadFileArray);
                    }
                    catch (Throwable throwable) {
                        NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
                    }
                }
            };
            ThreadPool.getInstance().addJob(runnable, "ResortPriority");
        }

        private void performPriorityUpdate() {
            SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.this.getSelectedDownloadFiles();
            Runnable runnable = new Runnable(this, sWDownloadFileArray){
                private final /* synthetic */ SWDownloadFile[] val$files;
                private final /* synthetic */ MoveDownloadPriorityAction this$1;
                {
                    this.this$1 = moveDownloadPriorityAction;
                    this.val$files = sWDownloadFileArray;
                }

                public void run() {
                    try {
                        for (int i = 0; i < this.val$files.length; ++i) {
                            if (this.val$files[i] == null) continue;
                            SWDownloadTab.access$1200(MoveDownloadPriorityAction.access$1500(this.this$1)).moveDownloadFilePriority(this.val$files[i], MoveDownloadPriorityAction.access$1600(this.this$1));
                        }
                    }
                    catch (Throwable throwable) {
                        NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
                    }
                }
            };
            ThreadPool.getInstance().addJob(runnable, "UpdatePriority");
        }

        public void refreshActionState() {
            if (this.moveDirection == 100) {
                this.setEnabled(true);
            } else if (SWDownloadTab.this.downloadTable.getSelectedRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        static /* synthetic */ SWDownloadTab access$1500(MoveDownloadPriorityAction moveDownloadPriorityAction) {
            return moveDownloadPriorityAction.SWDownloadTab.this;
        }

        static /* synthetic */ short access$1600(MoveDownloadPriorityAction moveDownloadPriorityAction) {
            return moveDownloadPriorityAction.moveDirection;
        }
    }

    class SetDownloadSpeedAction
    extends FWAction {
        private int speedInBytes;

        SetDownloadSpeedAction(int n) {
            this.speedInBytes = n;
            String string = n >= Integer.MAX_VALUE ? Localizer.getString("DownloadTab_NoLimit") + " (" + Localizer.getDecimalFormatSymbols().getInfinity() + ")" : NumberFormatUtils.formatSignificantByteSize(n) + Localizer.getString("PerSec");
            this.setName(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.this.getSelectedDownloadFiles();
            for (int i = 0; i < sWDownloadFileArray.length; ++i) {
                if (sWDownloadFileArray[i] == null) continue;
                sWDownloadFileArray[i].setDownloadThrottlingRate(this.speedInBytes);
            }
        }

        public void refreshActionState() {
        }
    }

    class RemoveDownloadAction
    extends FWAction {
        RemoveDownloadAction() {
            super(Localizer.getString("RemoveDownload"), GUIRegistry.getInstance().getIconFactory().getIcon("Remove"), Localizer.getString("TTTRemoveDownload"), null, KeyStroke.getKeyStroke(127, 0));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.this.getSelectedDownloadFiles();
            ArrayList<SWDownloadFile> arrayList = new ArrayList<SWDownloadFile>(sWDownloadFileArray.length);
            ArrayList<Object> arrayList2 = new ArrayList<Object>(sWDownloadFileArray.length);
            for (int i = 0; i < sWDownloadFileArray.length; ++i) {
                if (sWDownloadFileArray[i] == null) continue;
                if (sWDownloadFileArray[i].isFileCompletedMoved()) {
                    arrayList2.add(sWDownloadFileArray[i]);
                    continue;
                }
                if (sWDownloadFileArray[i].isFileCompleted()) continue;
                if (sWDownloadFileArray[i].getTransferredDataSize() == 0L) {
                    arrayList2.add(sWDownloadFileArray[i]);
                    continue;
                }
                arrayList.add(sWDownloadFileArray[i]);
            }
            Integer n = new Integer(arrayList.size());
            for (int i = 0; i < n; ++i) {
                object = (SWDownloadFile)arrayList.get(i);
                ((SWDownloadFile)object).forceCollectionOfTransferData();
                Object[] objectArray = new Object[]{((SWDownloadFile)object).getDestinationFile().getName(), NumberFormatUtils.formatSignificantByteSize(((SWDownloadFile)object).getTransferredDataSize()), NumberFormatUtils.formatSignificantByteSize(((SWDownloadFile)object).getTransferDataSize())};
                Object[] objectArray2 = new Object[]{new Integer(i + 1), n};
                Object[] objectArray3 = n - i > 1 ? new Object[]{Localizer.getString("Yes"), Localizer.getString("No"), Localizer.getString("YesToAll"), Localizer.getString("NoToAll")} : new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                int n2 = JOptionPane.showOptionDialog(SWDownloadTab.this.mainFrame, Localizer.getFormatedString("RemoveDownloadWarning", objectArray), Localizer.getFormatedString("RemoveDownloadTitle", objectArray2), 0, 2, null, objectArray3, Localizer.getString("Yes"));
                if (n2 == 0) {
                    arrayList2.add(object);
                    continue;
                }
                if (n2 == 2) {
                    arrayList2.addAll(arrayList.subList(i, arrayList.size()));
                    break;
                }
                if (n2 == 3) break;
            }
            if (arrayList2.size() > 0) {
                SWDownloadFile[] sWDownloadFileArray2 = new SWDownloadFile[arrayList2.size()];
                arrayList2.toArray(sWDownloadFileArray2);
                object = new Runnable(this, sWDownloadFileArray2){
                    private final /* synthetic */ SWDownloadFile[] val$filesToRemove;
                    private final /* synthetic */ RemoveDownloadAction this$1;
                    {
                        this.this$1 = removeDownloadAction;
                        this.val$filesToRemove = sWDownloadFileArray;
                    }

                    public void run() {
                        try {
                            SWDownloadTab.access$1200(RemoveDownloadAction.access$1400(this.this$1)).removeDownloadFiles(this.val$filesToRemove);
                        }
                        catch (Throwable throwable) {
                            NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
                        }
                    }
                };
                ThreadPool.getInstance().addJob((Runnable)object, "RemoveDownloadFiles");
                SWDownloadTab.this.downloadTable.getSelectionModel().clearSelection();
            }
        }

        public void refreshActionState() {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            if (n < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }

        static /* synthetic */ SWDownloadTab access$1400(RemoveDownloadAction removeDownloadAction) {
            return removeDownloadAction.SWDownloadTab.this;
        }
    }

    class ConfigureDownloadAction
    extends FWAction {
        ConfigureDownloadAction() {
            super(Localizer.getString("ConfigureDownload"), GUIRegistry.getInstance().getIconFactory().getIcon("ConfigDownload"), Localizer.getString("TTTConfigureDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() != 1) {
                this.setEnabled(false);
                return;
            }
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.downloadTable.convertRowIndexToModel(n);
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.swarmingMgr.getDownloadFile(n2);
            if (sWDownloadFile != null) {
                if (sWDownloadFile.isDownloadInProgress()) {
                    JOptionPane.showMessageDialog(SWDownloadTab.this, Localizer.getString("NoConfigDownloadInProgress"), Localizer.getString("DownloadInProgress"), 2);
                    return;
                }
                short s = sWDownloadFile.getStatus();
                sWDownloadFile.stopDownload();
                DownloadConfigDialog downloadConfigDialog = new DownloadConfigDialog(sWDownloadFile);
                downloadConfigDialog.setVisible(true);
                sWDownloadFile.setStatus(s);
            }
        }

        public void refreshActionState() {
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class StopDownloadAction
    extends FWAction {
        StopDownloadAction() {
            super(Localizer.getString("StopDownload"), GUIRegistry.getInstance().getIconFactory().getIcon("Stop"), Localizer.getString("TTTStopDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.this.getSelectedDownloadFiles();
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        for (int i = 0; i < sWDownloadFileArray.length; ++i) {
                            if (sWDownloadFileArray[i] == null || sWDownloadFileArray[i].isFileCompletedOrMoved() || sWDownloadFileArray[i].isDownloadStopped()) continue;
                            sWDownloadFileArray[i].stopDownload();
                        }
                        this.refreshActionState();
                    }
                    catch (Throwable throwable) {
                        NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
                    }
                }
            };
            ThreadPool.getInstance().addJob(runnable, "StopDownloadFiles");
        }

        public void refreshActionState() {
            SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.this.getSelectedDownloadFiles();
            boolean bl = false;
            for (int i = 0; i < sWDownloadFileArray.length; ++i) {
                if (sWDownloadFileArray[i] == null || sWDownloadFileArray[i].isFileCompletedOrMoved() || sWDownloadFileArray[i].isDownloadStopped()) continue;
                bl = true;
                break;
            }
            this.setEnabled(bl);
        }
    }

    class StartDownloadAction
    extends FWAction {
        StartDownloadAction() {
            super(Localizer.getString("StartDownload"), GUIRegistry.getInstance().getIconFactory().getIcon("Start"), Localizer.getString("TTTStartDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.this.getSelectedDownloadFiles();
            for (int i = 0; i < sWDownloadFileArray.length; ++i) {
                if (sWDownloadFileArray[i] == null || !sWDownloadFileArray[i].isDownloadStopped()) continue;
                sWDownloadFileArray[i].startDownload();
            }
            this.refreshActionState();
        }

        public void refreshActionState() {
            SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.this.getSelectedDownloadFiles();
            boolean bl = false;
            for (int i = 0; i < sWDownloadFileArray.length; ++i) {
                if (sWDownloadFileArray[i] == null || !sWDownloadFileArray[i].isDownloadStopped()) continue;
                bl = true;
                break;
            }
            this.setEnabled(bl);
        }
    }

    private class DownloadFilesChangeHandler
    implements DownloadFilesChangeListener {
        private DownloadFilesChangeHandler() {
        }

        public void downloadFileChanged(int n) {
            SWDownloadTab.this.updateDownloadFileInfo(n);
        }

        public void downloadFileAdded(int n) {
        }

        public void downloadFileRemoved(int n) {
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == SWDownloadTab.this.downloadTable || component == SWDownloadTab.this.downloadTableScrollPane) {
                SWDownloadTab.this.refreshTabActions();
                this.prepareDownloadPopup();
                SWDownloadTab.this.downloadPopup.show(component, n, n2);
            } else if (component == SWDownloadTab.this.candidateTable || component == SWDownloadTab.this.candidateTableScrollPane) {
                SWDownloadTab.this.candidatePopup.show(component, n, n2);
            }
        }

        public void prepareDownloadPopup() {
            SWDownloadTab.this.downloadPopupSpeedMenu.removeAll();
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() <= 0) {
                SWDownloadTab.this.downloadPopupSpeedMenu.setEnabled(false);
                return;
            }
            SWDownloadTab.this.downloadPopupSpeedMenu.setEnabled(true);
            int n = ServiceManager.sCfg.mDownloadMaxBandwidth;
            if (n > ServiceManager.sCfg.maxTotalBandwidth) {
                n = ServiceManager.sCfg.maxTotalBandwidth;
            }
            if (n >= Integer.MAX_VALUE) {
                n = 512000;
            }
            double d = (double)n / 10.0;
            SetDownloadSpeedAction setDownloadSpeedAction = new SetDownloadSpeedAction(Integer.MAX_VALUE);
            SWDownloadTab.this.downloadPopupSpeedMenu.add(setDownloadSpeedAction);
            for (int i = 10; i > 0; --i) {
                setDownloadSpeedAction = new SetDownloadSpeedAction((int)(d * (double)i));
                SWDownloadTab.this.downloadPopupSpeedMenu.add(setDownloadSpeedAction);
            }
        }
    }

    class CandidateSelectionHandler
    implements ListSelectionListener {
        CandidateSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                SWDownloadTab.this.refreshTabActions();
            }
        }
    }

    class DownloadSelectionHandler
    implements ListSelectionListener {
        DownloadSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            try {
                SWDownloadTab.this.updateDownloadFileInfo(-1);
            }
            catch (Exception exception) {
                NLogger.error("USER_INTERFACE", (Object)exception, (Throwable)exception);
            }
        }
    }
}

