/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.library;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import phex.event.ShareChangeListener;
import phex.gui.common.GUIRegistry;
import phex.gui.tabs.library.LibraryNode;
import phex.share.ShareManager;
import phex.share.SharedDirectory;
import phex.share.SharedFilesService;
import phex.utils.DirectoryOnlyFileFilter;
import phex.utils.Localizer;

public class SharingTreeModel
implements TreeModel {
    private SharedFilesService fileService = ShareManager.getInstance().getSharedFilesService();
    private FileFilter dirFilter = new DirectoryOnlyFileFilter();
    protected EventListenerList listenerList = new EventListenerList();
    private RootTreeNode root = new RootTreeNode();
    private Object[] rootChilds;
    private FileSystemView fsv = FileSystemView.getFileSystemView();

    public SharingTreeModel() {
        this.updateFileSystem();
        FileSystemChangeListener fileSystemChangeListener = new FileSystemChangeListener();
        ShareManager.getInstance().getSharedFilesService().addSharedFilesChangeListener(fileSystemChangeListener);
    }

    public void updateFileSystem() {
        this.root.updateChilds();
        this.fireTreeStructureChanged();
    }

    public Object getRoot() {
        return this.root;
    }

    public int getChildCount(Object object) {
        return ((TreeNode)object).getChildCount();
    }

    public Object getChild(Object object, int n) {
        return ((TreeNode)object).getChildAt(n);
    }

    public boolean isLeaf(Object object) {
        return ((TreeNode)object).isLeaf();
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        throw new UnsupportedOperationException();
    }

    public int getIndexOfChild(Object object, Object object2) {
        return ((TreeNode)object).getIndex((TreeNode)object2);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    private void fireTreeStructureChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$TreeModelListener == null ? SharingTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent((Object)this, new TreePath(new Object[]{this.root, this.root.childs[0]}));
            }
            ((TreeModelListener)objectArray[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    private class SharedDirectoryTreeNode
    implements TreeNode,
    LibraryNode {
        private SharedDirectory sharedDirectory;
        private TreeNode[] childs;
        private TreeNode parent;

        public SharedDirectoryTreeNode(SharedDirectory sharedDirectory, TreeNode treeNode) {
            this.sharedDirectory = sharedDirectory;
            this.parent = treeNode;
        }

        public String getDisplayName() {
            return SharingTreeModel.this.fsv.getSystemDisplayName(this.sharedDirectory.getSystemFile());
        }

        public String getTooltipText() {
            return this.sharedDirectory.getSystemFile().getAbsolutePath();
        }

        public Icon getDisplayIcon() {
            return SharingTreeModel.this.fsv.getSystemIcon(this.sharedDirectory.getSystemFile());
        }

        public File getSystemFile() {
            return this.sharedDirectory.getSystemFile();
        }

        public TreeNode getChildAt(int n) {
            this.initChilds();
            return this.childs[n];
        }

        public int getChildCount() {
            this.initChilds();
            return this.childs.length;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public boolean isLeaf() {
            this.initChilds();
            return this.childs.length == 0;
        }

        public int getIndex(TreeNode treeNode) {
            for (int i = 0; i < this.childs.length; ++i) {
                if (this.childs[i] != treeNode) continue;
                return i;
            }
            return -1;
        }

        public boolean getAllowsChildren() {
            throw new UnsupportedOperationException();
        }

        public Enumeration children() {
            throw new UnsupportedOperationException();
        }

        private void initChilds() {
            if (this.childs != null) {
                return;
            }
            ArrayList<SharedDirectoryTreeNode> arrayList = new ArrayList<SharedDirectoryTreeNode>();
            File file = this.sharedDirectory.getSystemFile();
            File[] fileArray = file.listFiles(SharingTreeModel.this.dirFilter);
            for (int i = 0; i < fileArray.length; ++i) {
                SharedDirectory sharedDirectory = SharingTreeModel.this.fileService.getSharedDirectory(fileArray[i]);
                if (sharedDirectory == null || sharedDirectory.getType() != 1) continue;
                arrayList.add(new SharedDirectoryTreeNode(sharedDirectory, this));
            }
            this.childs = arrayList.toArray(new TreeNode[arrayList.size()]);
        }
    }

    private class SharedFilesTreeNode
    implements TreeNode,
    LibraryNode {
        private TreeNode[] childs;

        public SharedFilesTreeNode() {
            this.updateChilds();
        }

        public String getDisplayName() {
            return Localizer.getString("LibraryTab_SharedFiles");
        }

        public String getTooltipText() {
            return Localizer.getString("LibraryTab_SharedFiles");
        }

        public Icon getDisplayIcon() {
            return GUIRegistry.getInstance().getIconFactory().getIcon("ShareFolder");
        }

        public File getSystemFile() {
            return null;
        }

        public void updateChilds() {
            ArrayList<SharedDirectoryTreeNode> arrayList = new ArrayList<SharedDirectoryTreeNode>();
            SharedDirectory[] sharedDirectoryArray = SharingTreeModel.this.fileService.getSharedDirectories();
            for (int i = 0; i < sharedDirectoryArray.length; ++i) {
                if (sharedDirectoryArray[i].getType() == 2) continue;
                File file = sharedDirectoryArray[i].getSystemFile().getParentFile();
                SharedDirectory sharedDirectory = null;
                if (file != null) {
                    sharedDirectory = SharingTreeModel.this.fileService.getSharedDirectory(file);
                }
                if (file != null && sharedDirectory != null && sharedDirectory.getType() != 2) continue;
                arrayList.add(new SharedDirectoryTreeNode(sharedDirectoryArray[i], this));
            }
            this.childs = arrayList.toArray(new TreeNode[arrayList.size()]);
        }

        public TreeNode getChildAt(int n) {
            return this.childs[n];
        }

        public int getChildCount() {
            return this.childs.length;
        }

        public TreeNode getParent() {
            return SharingTreeModel.this.root;
        }

        public boolean isLeaf() {
            return false;
        }

        public int getIndex(TreeNode treeNode) {
            for (int i = 0; i < this.childs.length; ++i) {
                if (this.childs[i] != treeNode) continue;
                return i;
            }
            return -1;
        }

        public boolean getAllowsChildren() {
            throw new UnsupportedOperationException();
        }

        public Enumeration children() {
            throw new UnsupportedOperationException();
        }
    }

    private class RootTreeNode
    implements TreeNode {
        private TreeNode[] childs;

        public RootTreeNode() {
            this.childs = new TreeNode[]{new SharedFilesTreeNode()};
            this.updateChilds();
        }

        public void updateChilds() {
            ((SharedFilesTreeNode)this.childs[0]).updateChilds();
        }

        public TreeNode getChildAt(int n) {
            return this.childs[n];
        }

        public int getChildCount() {
            return this.childs.length;
        }

        public TreeNode getParent() {
            return null;
        }

        public boolean isLeaf() {
            return false;
        }

        public int getIndex(TreeNode treeNode) {
            for (int i = 0; i < this.childs.length; ++i) {
                if (this.childs[i] != treeNode) continue;
                return i;
            }
            return -1;
        }

        public boolean getAllowsChildren() {
            throw new UnsupportedOperationException();
        }

        public Enumeration children() {
            throw new UnsupportedOperationException();
        }
    }

    public class FileSystemChangeListener
    implements ShareChangeListener {
        public void sharedDirectoriesChanged() {
            SharingTreeModel.this.updateFileSystem();
        }
    }
}

