/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.network;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.gui.models.FavoritesListModel;
import phex.gui.tabs.network.FavoritesListRenderer;
import phex.host.FavoriteHost;
import phex.host.HostManager;
import phex.net.presentation.PresentationManager;
import phex.utils.Localizer;
import phex.utils.NLogger;

public class NetFavoritesPanel
extends JPanel {
    private JTextField newFavoriteHostTF;
    private JButton addToFavoritesHostBtn;
    private JList favoritesList;
    private JButton removeFromFavoritesHostBtn;
    private JButton connectToFavoritesHostBtn;

    public NetFavoritesPanel() {
        this.init();
    }

    private void init() {
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("8dlu, d, 2dlu, d, 8dlu", "p, 3dlu, p, 4dlu, p, 2dlu, p, 2dlu, p:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        panelBuilder.addSeparator(Localizer.getString("NetworkTab_Favorites"), cellConstraints.xywh(1, 1, 5, 1));
        this.newFavoriteHostTF = new JTextField(20);
        panelBuilder.add((Component)this.newFavoriteHostTF, cellConstraints.xy(2, 3));
        this.addToFavoritesHostBtn = new JButton(Localizer.getString("Add"));
        this.addToFavoritesHostBtn.addActionListener(new AddToFavoritesHostAction());
        panelBuilder.add((Component)this.addToFavoritesHostBtn, cellConstraints.xy(4, 3));
        this.favoritesList = new JList(new FavoritesListModel());
        this.favoritesList.setPrototypeCellValue("123.123.123.123:12345");
        this.favoritesList.setVisibleRowCount(5);
        this.favoritesList.setCellRenderer(new FavoritesListRenderer());
        panelBuilder.add((Component)new JScrollPane(this.favoritesList), cellConstraints.xywh(2, 5, 1, 5));
        this.connectToFavoritesHostBtn = new JButton(Localizer.getString("Connect"));
        this.connectToFavoritesHostBtn.addActionListener(new ConnectToFavoritesHostAction());
        panelBuilder.add((Component)this.connectToFavoritesHostBtn, cellConstraints.xy(4, 5));
        this.removeFromFavoritesHostBtn = new JButton(Localizer.getString("Remove"));
        this.removeFromFavoritesHostBtn.addActionListener(new RemoveFromFavoritesHostAction());
        panelBuilder.add((Component)this.removeFromFavoritesHostBtn, cellConstraints.xy(4, 7));
    }

    private final class AddToFavoritesHostAction
    implements ActionListener {
        private AddToFavoritesHostAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = NetFavoritesPanel.this.newFavoriteHostTF.getText();
                string = string.trim();
                if (string.length() > 0) {
                    try {
                        DestAddress destAddress = PresentationManager.getInstance().createHostAddress(string, 6346);
                        HostManager hostManager = HostManager.getInstance();
                        hostManager.getFavoritesContainer().addFavorite(destAddress);
                        NetFavoritesPanel.this.newFavoriteHostTF.setText("");
                    }
                    catch (MalformedDestAddressException malformedDestAddressException) {}
                }
            }
            catch (Exception exception) {
                NLogger.error("USER_INTERFACE", (Object)exception, (Throwable)exception);
            }
        }
    }

    private final class ConnectToFavoritesHostAction
    implements ActionListener {
        private ConnectToFavoritesHostAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FavoriteHost favoriteHost = (FavoriteHost)NetFavoritesPanel.this.favoritesList.getSelectedValue();
                if (favoriteHost == null) {
                    return;
                }
                HostManager hostManager = HostManager.getInstance();
                hostManager.getNetworkHostsContainer().createOutgoingConnectionToHost(favoriteHost.getHostAddress());
            }
            catch (Exception exception) {
                NLogger.error("USER_INTERFACE", (Object)exception, (Throwable)exception);
            }
        }
    }

    private final class RemoveFromFavoritesHostAction
    implements ActionListener {
        private RemoveFromFavoritesHostAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FavoriteHost favoriteHost = (FavoriteHost)NetFavoritesPanel.this.favoritesList.getSelectedValue();
                HostManager hostManager = HostManager.getInstance();
                hostManager.getFavoritesContainer().removeBookmarkedHost(favoriteHost);
            }
            catch (Exception exception) {
                NLogger.error("USER_INTERFACE", (Object)exception, (Throwable)exception);
            }
        }
    }
}

