/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.network;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.Keymap;
import phex.chat.ChatManager;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.connection.NetworkManager;
import phex.event.NetworkListener;
import phex.gui.actions.BanHostActionUtils;
import phex.gui.actions.FWAction;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.FWElegantPanel;
import phex.gui.common.FWPopupMenu;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.IconFactory;
import phex.gui.common.MainFrame;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.models.NetworkTableModel;
import phex.gui.renderer.NetworkRowRenderer;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.network.NetFavoritesPanel;
import phex.gwebcache.GWebCacheContainer;
import phex.gwebcache.GWebCacheManager;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.msg.MsgManager;
import phex.net.presentation.PresentationManager;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;
import phex.xml.sax.gui.DTableColumnList;

public class NetworkTab
extends FWTab {
    private static final String NETWORK_TABLE_IDENTIFIER = "NetworkTable";
    private static final Host[] EMPTY_HOST_ARRAY = new Host[0];
    private MainFrame mainFrame;
    private HostManager hostMgr;
    private NetworkHostsContainer hostsContainer;
    private GWebCacheContainer gWebCacheCont;
    private MsgManager msgManager;
    private FWTable networkTable;
    private JScrollPane networkTableScrollPane;
    private FWTableColumnModel networkColumnModel;
    private NetworkTableModel networkModel;
    private FWPopupMenu networkPopup;
    private JLabel myIPLabel;
    private DefaultComboBoxModel connectToComboModel;
    private JComboBox connectToComboBox;
    private JLabel catcherStatLabel;
    private JLabel gWebCacheStatLabel;
    private static final String DISCONNECT_HOST_ACTION_KEY = "DisconnectHostAction";
    private static final String CHAT_TO_HOST_ACTION_KEY = "ChatToHostAction";
    private static final String BROWSE_HOST_ACTION_KEY = "BrowseHostAction";
    private static final String ADD_TO_FAVORITES_ACTION_KEY = "AddToFavoritesAction";

    public NetworkTab(MainFrame mainFrame) {
        super(1000, Localizer.getString("GnutellaNet"), GUIRegistry.getInstance().getIconFactory().getIcon("Network"), Localizer.getString("TTTGnutellaNet"), Localizer.getChar("GnutellaNetMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("GnutellaNetAccelerator")), 0);
        this.mainFrame = mainFrame;
        this.hostMgr = HostManager.getInstance();
        this.hostsContainer = this.hostMgr.getNetworkHostsContainer();
        this.gWebCacheCont = GWebCacheManager.getInstance().getGWebCacheContainer();
        this.msgManager = MsgManager.getInstance();
    }

    public void initComponent(DGuiSettings dGuiSettings) {
        Serializable serializable;
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, fill:d:grow, 4dlu, d, 2dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        JPanel jPanel = new JPanel();
        FWElegantPanel fWElegantPanel = new FWElegantPanel(Localizer.getString("Connections"), jPanel);
        formLayout = new FormLayout("0dlu, d, 2dlu, d, 10dlu:grow, d, 2dlu, d, 2dlu, d, 0dlu", "fill:d:grow, 3dlu, p");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout, jPanel);
        this.networkModel = new NetworkTableModel();
        DTable dTable = GUIUtils.getDGuiTableByIdentifier(dGuiSettings, NETWORK_TABLE_IDENTIFIER);
        this.buildNetworkTableColumnModel(dTable);
        this.networkTable = new FWTable((TableModel)new FWSortedTableModel(this.networkModel), this.networkColumnModel);
        this.networkTable.activateAllHeaderActions();
        this.networkTable.setAutoResizeMode(0);
        this.networkTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        MouseHandler mouseHandler = new MouseHandler();
        this.networkTable.addMouseListener(mouseHandler);
        this.networkTableScrollPane = FWTable.createFWTableScrollPane(this.networkTable);
        this.networkTableScrollPane.addMouseListener(mouseHandler);
        panelBuilder2.add((Component)this.networkTableScrollPane, cellConstraints.xywh(2, 1, 9, 1));
        JLabel jLabel = new JLabel(Localizer.getString("NetworkTab_MyAddress"));
        panelBuilder2.add((Component)jLabel, cellConstraints.xy(2, 3));
        this.myIPLabel = new JLabel("");
        this.myIPLabel.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            private void popupMenu(Component component, int n, int n2) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(new CopyMyIpAction());
                jPopupMenu.show(component, n, n2);
            }
        });
        panelBuilder2.add((Component)this.myIPLabel, cellConstraints.xy(4, 3));
        jLabel = new JLabel(Localizer.getString("ConnectTo") + Localizer.getChar("ColonSign"));
        panelBuilder2.add((Component)jLabel, cellConstraints.xy(6, 3));
        ConnectToHostHandler connectToHostHandler = new ConnectToHostHandler();
        this.connectToComboModel = new DefaultComboBoxModel<Object>(ServiceManager.sCfg.connectToHistory.toArray());
        this.connectToComboBox = new JComboBox(this.connectToComboModel);
        this.connectToComboBox.setEditable(true);
        JTextField jTextField = (JTextField)this.connectToComboBox.getEditor().getEditorComponent();
        Keymap keymap = JTextField.addKeymap("ConnectToEditor", jTextField.getKeymap());
        jTextField.setKeymap(keymap);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), connectToHostHandler);
        GUIUtils.assignKeymapToComboBoxEditor(keymap, this.connectToComboBox);
        this.connectToComboBox.setSelectedItem("");
        this.connectToComboBox.setPrototypeDisplayValue("123.123.123.123:12345");
        panelBuilder2.add((Component)this.connectToComboBox, cellConstraints.xy(8, 3));
        JButton jButton = new JButton(Localizer.getString("Connect"));
        jButton.addActionListener(connectToHostHandler);
        panelBuilder2.add((Component)jButton, cellConstraints.xy(10, 3));
        JPanel jPanel2 = new JPanel();
        formLayout = new FormLayout("d, fill:10dlu:grow, d", "top:p");
        formLayout.setColumnGroups(new int[][]{{1, 3}});
        PanelBuilder panelBuilder3 = new PanelBuilder(formLayout, jPanel2);
        NetFavoritesPanel netFavoritesPanel = new NetFavoritesPanel();
        panelBuilder3.add((Component)netFavoritesPanel, cellConstraints.xy(1, 1));
        JPanel jPanel3 = new JPanel();
        formLayout = new FormLayout("8dlu, right:d, 2dlu, right:d, 2dlu, d, 2dlu:grow, 8dlu", "p, 3dlu, p, 3dlu, p, 3dlu, bottom:p:grow");
        PanelBuilder panelBuilder4 = new PanelBuilder(formLayout, jPanel3);
        panelBuilder3.add((Component)jPanel3, cellConstraints.xy(3, 1));
        panelBuilder4.addSeparator(Localizer.getString("NetworkTab_ConnectionInfo"), cellConstraints.xywh(1, 1, 8, 1));
        panelBuilder4.addLabel(Localizer.getString("NetworkTab_HostCacheContains"), cellConstraints.xy(2, 3));
        this.catcherStatLabel = new JLabel();
        panelBuilder4.add((Component)this.catcherStatLabel, cellConstraints.xy(4, 3));
        panelBuilder4.addLabel(Localizer.getString("NetworkTab_Hosts"), cellConstraints.xy(6, 3));
        panelBuilder4.addLabel(Localizer.getString("NetworkTab_GWebCacheContains"), cellConstraints.xy(2, 5));
        this.gWebCacheStatLabel = new JLabel();
        panelBuilder4.add((Component)this.gWebCacheStatLabel, cellConstraints.xy(4, 5));
        panelBuilder4.addLabel(Localizer.getString("NetworkTab_Caches"), cellConstraints.xy(6, 5));
        final JButton jButton2 = new JButton(Localizer.getString("QueryGWebCache"));
        jButton2.setToolTipText(Localizer.getString("TTTQueryGWebCache"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jButton2.setEnabled(false);
                Runnable runnable = new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            NetworkTab.access$400(2.access$300(this.this$1)).queryMoreHosts(false);
                            NetworkTab.access$400(2.access$300(this.this$1)).queryMoreGWebCaches(false);
                        }
                        catch (Throwable throwable) {
                            NLogger.error("GLOBAL", (Object)throwable, throwable);
                        }
                        finally {
                            2.access$500(this.this$1).setEnabled(true);
                        }
                    }
                };
                ThreadPool.getInstance().addJob(runnable, "UserGWebCacheQuery-" + Integer.toHexString(runnable.hashCode()));
            }

            static /* synthetic */ NetworkTab access$300(2 var0) {
                return var0.NetworkTab.this;
            }

            static /* synthetic */ JButton access$500(2 var0) {
                return var0.jButton2;
            }
        });
        panelBuilder4.add((Component)jButton2, cellConstraints.xywh(2, 7, 5, 1));
        panelBuilder.add((Component)fWElegantPanel, cellConstraints.xy(2, 2));
        panelBuilder.add((Component)jPanel2, cellConstraints.xy(2, 4));
        NetworkRowRenderer networkRowRenderer = new NetworkRowRenderer();
        Enumeration<TableColumn> enumeration = this.networkColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            ((TableColumn)serializable).setCellRenderer(networkRowRenderer);
        }
        this.networkPopup = new FWPopupMenu();
        serializable = new DisconnectHostAction();
        this.addTabAction(DISCONNECT_HOST_ACTION_KEY, (FWAction)serializable);
        this.networkTable.getActionMap().put(DISCONNECT_HOST_ACTION_KEY, (Action)((Object)serializable));
        this.networkTable.getInputMap(1).put((KeyStroke)((AbstractAction)serializable).getValue("AcceleratorKey"), DISCONNECT_HOST_ACTION_KEY);
        this.networkPopup.addAction((FWAction)serializable);
        this.networkPopup.addSeparator();
        serializable = new AddToFavoritesAction();
        this.addTabAction(ADD_TO_FAVORITES_ACTION_KEY, (FWAction)serializable);
        this.networkPopup.addAction((FWAction)serializable);
        serializable = new BrowseHostAction();
        this.addTabAction(BROWSE_HOST_ACTION_KEY, (FWAction)serializable);
        this.networkPopup.addAction((FWAction)serializable);
        serializable = new ChatToHostAction();
        this.addTabAction(CHAT_TO_HOST_ACTION_KEY, (FWAction)serializable);
        this.networkPopup.addAction((FWAction)serializable);
        BanHostActionProvider banHostActionProvider = new BanHostActionProvider();
        BanHostActionUtils.BanHostActionMenu banHostActionMenu = BanHostActionUtils.createActionMenu(banHostActionProvider);
        this.networkPopup.add(banHostActionMenu.menu);
        this.addTabActions(banHostActionMenu.actions);
        this.networkPopup.addSeparator();
        JMenu jMenu = new JMenu(Localizer.getString("Network"));
        jMenu.add(GUIRegistry.getInstance().getGlobalAction("ConnectNetworkAction"));
        jMenu.add(GUIRegistry.getInstance().getGlobalAction("DisconnectNetworkAction"));
        this.networkPopup.add(jMenu);
        NetworkManager networkManager = NetworkManager.getInstance();
        IPChangedListener iPChangedListener = new IPChangedListener();
        iPChangedListener.networkIPChanged(networkManager.getLocalAddress());
        networkManager.addNetworkListener(iPChangedListener);
    }

    public void updateUI() {
        super.updateUI();
        if (this.connectToComboBox != null) {
            GUIUtils.adjustComboBoxHeight(this.connectToComboBox);
            ListCellRenderer listCellRenderer = this.connectToComboBox.getRenderer();
            if (listCellRenderer != null) {
                FontMetrics fontMetrics = this.connectToComboBox.getFontMetrics(this.connectToComboBox.getFont());
                int n = fontMetrics.getMaxAdvance() * 15;
                Dimension dimension = this.connectToComboBox.getMaximumSize();
                dimension.width = Math.min(n, dimension.width);
                dimension = this.connectToComboBox.getPreferredSize();
                dimension.width = Math.min(n, dimension.width);
            }
        }
        if (this.networkTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.networkTableScrollPane);
        }
    }

    public void appendDGuiSettings(DGuiSettings dGuiSettings) {
        super.appendDGuiSettings(dGuiSettings);
        DTableColumnList dTableColumnList = this.networkColumnModel.createDGuiTableColumnList();
        DTable dTable = new DTable();
        dTable.setTableColumnList(dTableColumnList);
        dTable.setTableIdentifier(NETWORK_TABLE_IDENTIFIER);
        dGuiSettings.getTableList().getTableList().add(dTable);
    }

    public void tabSelectedNotify() {
        this.refresh();
    }

    public void refresh() {
        this.catcherStatLabel.setText(String.valueOf(this.hostMgr.getCaughtHostsContainer().getCaughtHostsCount()));
        this.gWebCacheStatLabel.setText(String.valueOf(this.gWebCacheCont.getGWebCacheCount()));
        this.networkModel.fireTableDataChanged();
    }

    private void buildNetworkTableColumnModel(DTable dTable) {
        int[] nArray = NetworkTableModel.getColumnIdArray();
        DTableColumnList dTableColumnList = null;
        if (dTable != null) {
            dTableColumnList = dTable.getTableColumnList();
        }
        this.networkColumnModel = new FWTableColumnModel(this.networkModel, nArray, dTableColumnList);
    }

    private Host[] getSelectedHosts() {
        int[] nArray = this.networkTable.getSelectedRows();
        if (nArray.length == 0) {
            return EMPTY_HOST_ARRAY;
        }
        int[] nArray2 = this.networkTable.convertRowIndicesToModel(nArray);
        Host[] hostArray = this.hostsContainer.getNetworkHostsAt(nArray2);
        return hostArray;
    }

    private Host getSelectedHost() {
        int n = this.networkTable.getSelectedRow();
        int n2 = this.networkTable.convertRowIndexToModel(n);
        if (n2 < 0) {
            return null;
        }
        Host host = this.hostsContainer.getNetworkHostAt(n2);
        return host;
    }

    static /* synthetic */ GWebCacheContainer access$400(NetworkTab networkTab) {
        return networkTab.gWebCacheCont;
    }

    class CopyMyIpAction
    extends FWAction {
        CopyMyIpAction() {
            super(Localizer.getString("Copy"), (Icon)IconFactory.EMPTY_IMAGE_16, Localizer.getString("TTTCopyMyIP"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DestAddress destAddress = NetworkManager.getInstance().getLocalAddress();
            StringSelection stringSelection = new StringSelection(destAddress.getFullHostName());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, stringSelection);
        }

        public void refreshActionState() {
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == NetworkTab.this.networkTable || component == NetworkTab.this.networkTableScrollPane) {
                NetworkTab.this.networkPopup.show(component, n, n2);
            }
        }
    }

    private class ConnectToHostHandler
    extends AbstractAction
    implements ActionListener {
        private ConnectToHostHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)NetworkTab.this.connectToComboBox.getEditor().getItem();
            NetworkTab.this.connectToComboModel.setSelectedItem(string);
            string = string.trim();
            if (string.length() == 0) {
                return;
            }
            int n = NetworkTab.this.connectToComboModel.getIndexOf(string);
            if (n < 0) {
                NetworkTab.this.connectToComboModel.insertElementAt(string, 0);
                if (NetworkTab.this.connectToComboModel.getSize() > ServiceManager.sCfg.maxConnectToHistorySize) {
                    NetworkTab.this.connectToComboModel.removeElementAt(NetworkTab.this.connectToComboModel.getSize() - 1);
                }
                this.saveConnectToHostList();
            } else if (n > 0) {
                NetworkTab.this.connectToComboModel.removeElementAt(n);
                NetworkTab.this.connectToComboModel.insertElementAt(string, 0);
                this.saveConnectToHostList();
            }
            this.connectToHost(string);
            NetworkTab.this.connectToComboBox.setSelectedItem("");
        }

        private void connectToHost(String string) {
            Object object;
            if (string.length() == 0) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            String string2 = stringTokenizer.nextToken();
            try {
                object = PresentationManager.getInstance().createHostAddress(string2, 6346);
                NetworkTab.this.hostMgr.getNetworkHostsContainer().createOutgoingConnectionToHost((DestAddress)object);
            }
            catch (MalformedDestAddressException malformedDestAddressException) {
                // empty catch block
            }
            NetworkTab.this.networkModel.fireTableDataChanged();
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                try {
                    DestAddress destAddress = PresentationManager.getInstance().createHostAddress((String)object, 6346);
                    NetworkTab.this.hostMgr.getCaughtHostsContainer().addCaughtHost(destAddress, (short)2);
                }
                catch (MalformedDestAddressException malformedDestAddressException) {}
            }
        }

        private void saveConnectToHostList() {
            int n = NetworkTab.this.connectToComboModel.getSize();
            ArrayList arrayList = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(NetworkTab.this.connectToComboModel.getElementAt(i));
            }
            ServiceManager.sCfg.connectToHistory.clear();
            ServiceManager.sCfg.connectToHistory.addAll(arrayList);
            ServiceManager.sCfg.save();
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                NetworkTab.this.refreshTabActions();
            }
        }
    }

    private class IPChangedListener
    implements NetworkListener {
        private IPChangedListener() {
        }

        public void networkIPChanged(DestAddress destAddress) {
            String string = destAddress.getFullHostName();
            if (string.equals(NetworkTab.this.myIPLabel.getText())) {
                return;
            }
            NetworkTab.this.myIPLabel.setText(string);
            String string2 = destAddress.getCountryCode();
            Icon icon = null;
            if (string2 != null && string2.length() > 0) {
                icon = GUIRegistry.getInstance().getIconFactory().getIcon("Flag_" + string2);
            }
            NetworkTab.this.myIPLabel.setIcon(icon);
        }

        public void connectedToNetwork() {
        }

        public void disconnectedFromNetwork() {
        }
    }

    private class BrowseHostAction
    extends FWAction {
        public BrowseHostAction() {
            super(Localizer.getString("BrowseHost"), GUIRegistry.getInstance().getIconFactory().getIcon("BrowseHost"), Localizer.getString("TTTBrowseHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Host host = NetworkTab.this.getSelectedHost();
            if (host == null) {
                return;
            }
            GUIActionPerformer.browseHost(host.getHostAddress());
        }

        public void refreshActionState() {
            Host host;
            if (NetworkTab.this.networkTable.getSelectedRowCount() == 1 && (host = NetworkTab.this.getSelectedHost()) != null) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class ChatToHostAction
    extends FWAction {
        public ChatToHostAction() {
            super(Localizer.getString("ChatToHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Chat"), Localizer.getString("TTTChatToHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Host host = NetworkTab.this.getSelectedHost();
            if (host == null) {
                return;
            }
            ChatManager.getInstance().openChat(host.getHostAddress());
        }

        public void refreshActionState() {
            Host host;
            if (NetworkTab.this.networkTable.getSelectedRowCount() == 1 && (host = NetworkTab.this.getSelectedHost()) != null) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class AddToFavoritesAction
    extends FWAction {
        public AddToFavoritesAction() {
            super(Localizer.getString("AddToFavorites"), GUIRegistry.getInstance().getIconFactory().getIcon("FavoriteHost"), Localizer.getString("TTTAddToFavorites"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Host[] hostArray = NetworkTab.this.getSelectedHosts();
            DestAddress[] destAddressArray = new DestAddress[hostArray.length];
            for (int i = 0; i < hostArray.length; ++i) {
                destAddressArray[i] = hostArray[i].getHostAddress();
            }
            GUIActionPerformer.addHostsToFavorites(destAddressArray);
        }

        public void refreshActionState() {
            if (NetworkTab.this.networkTable.getSelectedRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private final class BanHostActionProvider
    implements BanHostActionUtils.BanHostActionProvider {
        private BanHostActionProvider() {
        }

        public DestAddress[] getBanHostAddresses() {
            Host[] hostArray = NetworkTab.this.getSelectedHosts();
            NetworkTab.this.hostMgr.removeNetworkHosts(hostArray);
            DestAddress[] destAddressArray = new DestAddress[hostArray.length];
            for (int i = 0; i < hostArray.length; ++i) {
                destAddressArray[i] = hostArray[i].getHostAddress();
            }
            return destAddressArray;
        }

        public boolean isBanHostActionEnabled(boolean bl) {
            return NetworkTab.this.networkTable.getSelectedRow() >= 0 && (bl || NetworkTab.this.networkTable.getSelectedRowCount() <= 1);
        }
    }

    private class DisconnectHostAction
    extends FWAction {
        public DisconnectHostAction() {
            super(Localizer.getString("DisconnectHost"), GUIRegistry.getInstance().getIconFactory().getIcon("DisconnectHost"), Localizer.getString("TTTDisconnectHost"), null, KeyStroke.getKeyStroke(127, 0));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Host[] hostArray = NetworkTab.this.getSelectedHosts();
            NetworkTab.this.hostMgr.removeNetworkHosts(hostArray);
        }

        public void refreshActionState() {
            if (NetworkTab.this.networkTable.getSelectedRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }
}

