/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.View;
import phex.event.SearchDataEvent;
import phex.event.SearchDataListener;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.IconFactory;
import phex.gui.common.PhexColors;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.query.BrowseHostResults;
import phex.query.KeywordSearch;
import phex.query.QueryManager;
import phex.query.Search;
import phex.query.SearchContainer;
import phex.query.WhatsNewSearch;
import phex.utils.Localizer;

public class SearchButton
extends JToggleButton
implements SearchDataListener {
    private Search search;

    public SearchButton(Search search) {
        this.search = search;
        search.addSearchChangeListener(this);
        this.updateButtonDisplay();
        this.setUI(new SearchButtonUI());
        this.setBorder(GUIUtils.ROLLOVER_BUTTON_BORDER);
        this.setRolloverEnabled(true);
        this.setHorizontalAlignment(2);
        this.setMargin(GUIUtils.EMPTY_INSETS);
    }

    public Search getSearch() {
        return this.search;
    }

    public void updateButtonDisplay() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.search instanceof KeywordSearch) {
            stringBuffer.append(((KeywordSearch)this.search).getSearchString());
            this.setIcon(GUIRegistry.getInstance().getIconFactory().getIcon("Search"));
        } else if (this.search instanceof BrowseHostResults) {
            object = ((BrowseHostResults)this.search).getDestAddress();
            stringBuffer.append(object.getFullHostName());
            this.setIcon(GUIRegistry.getInstance().getIconFactory().getIcon("BrowseHost"));
        } else if (this.search instanceof WhatsNewSearch) {
            stringBuffer.append(Localizer.getString("SearchTab_WhatsNewSearch"));
            this.setIcon(IconFactory.EMPTY_IMAGE_16);
        } else {
            stringBuffer.append(this.search.toString());
            this.setIcon(IconFactory.EMPTY_IMAGE_16);
        }
        object = SearchResultsDataModel.lookupResultDataModel(this.search);
        int n = 0;
        int n2 = 0;
        if (object != null) {
            n = ((SearchResultsDataModel)object).getSearchElementCount();
            n2 = ((SearchResultsDataModel)object).getFilteredElementCount();
        }
        stringBuffer.append(" (");
        if (n2 < n) {
            stringBuffer.append(n).append("/");
        }
        stringBuffer.append(n2).append(")");
        this.setText(stringBuffer.toString());
    }

    public void searchDataChanged(SearchDataEvent searchDataEvent) {
        this.updateButtonDisplay();
    }

    private static class SearchButtonUI
    extends BasicButtonUI {
        private static final Icon closeIcon = GUIRegistry.getInstance().getIconFactory().getIcon("Close");
        private Color fromColor = PhexColors.getBoxPanelBackground().darker();
        private Color toColor = PhexColors.getBoxPanelBackground().brighter();
        private static Rectangle viewRect = new Rectangle();
        private static Rectangle displayRect = new Rectangle();
        private static Rectangle textRect = new Rectangle();
        private static Rectangle iconRect = new Rectangle();

        private SearchButtonUI() {
        }

        public Dimension getMinimumSize(JComponent jComponent) {
            Dimension dimension = super.getMinimumSize(jComponent);
            dimension.width = 0;
            return dimension;
        }

        public Dimension getPreferredSize(JComponent jComponent) {
            Dimension dimension = super.getPreferredSize(jComponent);
            dimension.width = Math.max(150, dimension.width + closeIcon.getIconWidth());
            return dimension;
        }

        public void update(Graphics graphics, JComponent jComponent) {
            if (jComponent.isOpaque()) {
                graphics.setColor(jComponent.getBackground());
                int n = jComponent.getWidth();
                int n2 = jComponent.getHeight();
                graphics.fillRect(0, 0, n, n2);
                AbstractButton abstractButton = (AbstractButton)jComponent;
                if (abstractButton.isSelected()) {
                    GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.fromColor, n / 2, n2 / 2, this.toColor, true);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setPaint(gradientPaint);
                    graphics2D.fillRect(0, 0, n, n2);
                }
            }
            this.paint(graphics, jComponent);
        }

        public void paint(Graphics graphics, JComponent jComponent) {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            ButtonModel buttonModel = abstractButton.getModel();
            FontMetrics fontMetrics = abstractButton.getFontMetrics(graphics.getFont());
            Insets insets = jComponent.getInsets();
            SearchButtonUI.displayRect.x = SearchButtonUI.viewRect.x = insets.left;
            SearchButtonUI.displayRect.y = SearchButtonUI.viewRect.y = insets.top;
            SearchButtonUI.viewRect.width = abstractButton.getWidth() - (insets.right + SearchButtonUI.viewRect.x);
            SearchButtonUI.displayRect.width = abstractButton.isSelected() ? SearchButtonUI.viewRect.width - closeIcon.getIconWidth() : SearchButtonUI.viewRect.width;
            SearchButtonUI.displayRect.height = SearchButtonUI.viewRect.height = abstractButton.getHeight() - (insets.bottom + SearchButtonUI.viewRect.y);
            SearchButtonUI.textRect.height = 0;
            SearchButtonUI.textRect.width = 0;
            SearchButtonUI.textRect.y = 0;
            SearchButtonUI.textRect.x = 0;
            SearchButtonUI.iconRect.height = 0;
            SearchButtonUI.iconRect.width = 0;
            SearchButtonUI.iconRect.y = 0;
            SearchButtonUI.iconRect.x = 0;
            Font font = jComponent.getFont();
            graphics.setFont(font);
            String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), displayRect, iconRect, textRect, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
            this.clearTextShiftOffset();
            if (buttonModel.isArmed() && buttonModel.isPressed()) {
                this.paintButtonPressed(graphics, abstractButton);
            }
            if (abstractButton.isSelected()) {
                this.paintCloseIcon(graphics, abstractButton);
            }
            if (abstractButton.getIcon() != null) {
                this.paintIcon(graphics, jComponent, iconRect);
            }
            if (string != null && !string.equals("")) {
                View view = (View)jComponent.getClientProperty("html");
                if (view != null) {
                    view.paint(graphics, textRect);
                } else {
                    this.paintText(graphics, abstractButton, textRect, string);
                }
            }
            if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
                this.paintFocus(graphics, abstractButton, viewRect, textRect, iconRect);
            }
        }

        private void paintCloseIcon(Graphics graphics, AbstractButton abstractButton) {
            ButtonModel buttonModel = abstractButton.getModel();
            int n = abstractButton.getWidth() - abstractButton.getInsets().right - closeIcon.getIconWidth();
            int n2 = abstractButton.getHeight() / 2 - closeIcon.getIconHeight() / 2;
            if (buttonModel.isPressed() && buttonModel.isArmed()) {
                closeIcon.paintIcon(abstractButton, graphics, n + this.getTextShiftOffset(), n2 + this.getTextShiftOffset());
            } else {
                closeIcon.paintIcon(abstractButton, graphics, n, n2);
            }
        }

        protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
            return new CloseButtonListener(abstractButton);
        }

        public static class CloseButtonListener
        extends BasicButtonListener {
            private SearchButton btn;

            public CloseButtonListener(AbstractButton abstractButton) {
                super(abstractButton);
                this.btn = (SearchButton)abstractButton;
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                AbstractButton abstractButton;
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && (abstractButton = (AbstractButton)mouseEvent.getSource()).isSelected()) {
                    int n;
                    int n2 = closeIcon.getIconWidth();
                    int n3 = closeIcon.getIconHeight();
                    int n4 = abstractButton.getWidth() - abstractButton.getInsets().right - n2;
                    Rectangle rectangle = new Rectangle(n4, n = abstractButton.getHeight() / 2 - n3 / 2, n2, n3);
                    if (rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
                        SearchContainer searchContainer = QueryManager.getInstance().getSearchContainer();
                        searchContainer.removeSearch(this.btn.search);
                    }
                }
                super.mouseReleased(mouseEvent);
            }
        }
    }
}

