/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import phex.gui.actions.FWAction;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.tabs.search.SearchListTableModel;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.SearchTab;
import phex.query.QueryManager;
import phex.query.Search;
import phex.query.SearchContainer;
import phex.utils.NLogger;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;
import phex.xml.sax.gui.DTableColumnList;

public class SearchListPanel
extends JPanel {
    private static final String SEARCHLIST_TABLE_IDENTIFIER = "SearchListTable";
    private SearchContainer searchContainer = QueryManager.getInstance().getSearchContainer();
    private SearchTab searchTab;
    private FWTable searchListTable;
    private JScrollPane searchListTableScrollPane;
    private FWTableColumnModel searchListColumnModel;
    private SearchListTableModel searchListModel;
    private JPopupMenu searchListPopup;

    public SearchListPanel(SearchTab searchTab) {
        this.searchTab = searchTab;
    }

    public void initializeComponent(DGuiSettings dGuiSettings) {
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("fill:d:grow", "fill:d:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        this.searchListModel = new SearchListTableModel();
        this.searchListModel.addTableModelListener(new SearchListTableListener());
        DTable dTable = GUIUtils.getDGuiTableByIdentifier(dGuiSettings, SEARCHLIST_TABLE_IDENTIFIER);
        this.buildSearchListTableColumnModel(dTable);
        MouseHandler mouseHandler = new MouseHandler();
        this.searchListTable = new FWTable((TableModel)new FWSortedTableModel(this.searchListModel), this.searchListColumnModel);
        this.searchListTable.setSelectionMode(0);
        this.searchListTable.activateAllHeaderActions();
        this.searchListTable.setAutoResizeMode(0);
        this.searchListTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.searchListTable.addMouseListener(mouseHandler);
        GUIRegistry.getInstance().getTableUpdateService().registerTable(this.searchListTable);
        this.searchListTableScrollPane = FWTable.createFWTableScrollPane(this.searchListTable);
        this.searchListTableScrollPane.addMouseListener(mouseHandler);
        panelBuilder.add((Component)this.searchListTableScrollPane, cellConstraints.xy(1, 1));
        this.searchListPopup = new JPopupMenu();
        this.searchListPopup.add(this.searchTab.getTabAction("CreateNewSearchAction"));
        this.searchListPopup.add(this.searchTab.getTabAction("ClearSearchResultsAction"));
        FWAction fWAction = this.searchTab.getTabAction("CloseSearchAction");
        this.searchListPopup.add(fWAction);
        this.searchListTable.getActionMap().put("CloseSearchAction", fWAction);
        this.searchListTable.getInputMap(1).put((KeyStroke)fWAction.getValue("AcceleratorKey"), "CloseSearchAction");
    }

    public void setDisplayedSearch(SearchResultsDataModel searchResultsDataModel) {
        if (searchResultsDataModel == null) {
            this.searchListTable.getSelectionModel().clearSelection();
            return;
        }
        int n = this.searchContainer.getIndexOfSearch(searchResultsDataModel.getSearch());
        if (n != -1) {
            int n2 = this.searchListTable.convertRowIndexToView(n);
            if (n2 != -1) {
                this.searchListTable.getSelectionModel().setSelectionInterval(n2, n2);
            } else {
                this.searchListTable.getSelectionModel().clearSelection();
            }
        } else {
            this.searchListTable.getSelectionModel().clearSelection();
        }
    }

    private Search getSelectedSearch() {
        int n = this.searchListTable.getSelectedRow();
        if (n < 0) {
            return null;
        }
        int n2 = this.searchListTable.convertRowIndexToModel(n);
        Search search = this.searchContainer.getSearchAt(n2);
        return search;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = (int)((double)this.searchListTable.getRowHeight() * 4.7);
        return dimension;
    }

    private void buildSearchListTableColumnModel(DTable dTable) {
        int[] nArray = SearchListTableModel.getColumnIdArray();
        DTableColumnList dTableColumnList = null;
        if (dTable != null) {
            dTableColumnList = dTable.getTableColumnList();
        }
        this.searchListColumnModel = new FWTableColumnModel(this.searchListModel, nArray, dTableColumnList);
    }

    public void updateUI() {
        super.updateUI();
        if (this.searchListTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.searchListTableScrollPane);
        }
    }

    public void appendDGuiSettings(DGuiSettings dGuiSettings) {
        DTableColumnList dTableColumnList = this.searchListColumnModel.createDGuiTableColumnList();
        DTable dTable = new DTable();
        dTable.setTableColumnList(dTableColumnList);
        dTable.setTableIdentifier(SEARCHLIST_TABLE_IDENTIFIER);
        dGuiSettings.getTableList().getTableList().add(dTable);
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getSource() == SearchListPanel.this.searchListTableScrollPane) {
                    SearchListPanel.this.searchTab.setDisplayedSearch(null);
                }
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == SearchListPanel.this.searchListTable || component == SearchListPanel.this.searchListTableScrollPane) {
                SearchListPanel.this.searchTab.refreshTabActions();
                SearchListPanel.this.searchListPopup.show(component, n, n2);
            }
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            try {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                SearchListPanel.this.searchTab.refreshTabActions();
                Search search = SearchListPanel.this.getSelectedSearch();
                if (search == null) {
                    return;
                }
                SearchResultsDataModel searchResultsDataModel = SearchResultsDataModel.lookupResultDataModel(search);
                SearchListPanel.this.searchTab.setDisplayedSearch(searchResultsDataModel);
            }
            catch (Exception exception) {
                NLogger.error("USER_INTERFACE", (Object)exception, (Throwable)exception);
            }
        }
    }

    private class SearchListTableListener
    implements TableModelListener {
        private SearchListTableListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() == 1) {
                Search search = SearchListPanel.this.searchContainer.getSearchAt(tableModelEvent.getFirstRow());
                SearchResultsDataModel searchResultsDataModel = SearchResultsDataModel.lookupResultDataModel(search);
                SearchListPanel.this.searchTab.setDisplayedSearch(searchResultsDataModel);
            }
        }
    }
}

