/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.cp;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;
import phex.gui.common.BoxPanel;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.IconFactory;
import phex.gui.common.PhexColors;
import phex.gui.tabs.search.SearchTab;
import phex.gui.tabs.search.cp.SearchControlPanel;
import phex.utils.Localizer;

public class SearchActivityBox
extends BoxPanel {
    private static Border ROLLOVER_BUTTON_BORDER = new CompoundBorder(GUIUtils.ROLLOVER_BUTTON_BORDER, new EmptyBorder(2, 2, 2, 2));
    private static ButtonUI ACTIVITY_BUTTON_UI = new ActivityButtonUI();
    private JPanel newSearchActivityP;
    private JToggleButton keywordSearchBtn;
    private JToggleButton whatsNewBtn;
    private JToggleButton browseHostBtn;
    private JPanel runningSearchActivityP;
    private JButton newSearchBtn;
    private JButton closeSearchBtn;

    public SearchActivityBox(SearchTab searchTab, final SearchControlPanel searchControlPanel) {
        super(Localizer.getString("SearchTab_SearchActivity"));
        CellConstraints cellConstraints = new CellConstraints();
        this.getContentPanel().setLayout(new BorderLayout());
        this.newSearchActivityP = new JPanel();
        this.newSearchActivityP.setOpaque(false);
        this.getContentPanel().add((Component)this.newSearchActivityP, "Center");
        FormLayout formLayout = new FormLayout("6dlu, fill:p:grow, 6dlu", "2dlu, p, 1dlu, p, 1dlu, p, 2dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this.newSearchActivityP);
        this.keywordSearchBtn = new JToggleButton(Localizer.getString("SearchTab_KeywordSearch"), GUIRegistry.getInstance().getIconFactory().getIcon("Search"));
        this.keywordSearchBtn.setToolTipText(Localizer.getString("SearchTab_TTTKeywordSearch"));
        this.updateActivityBtnProps(this.keywordSearchBtn);
        this.keywordSearchBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                searchControlPanel.activateKeywordSearchBox();
            }
        });
        this.whatsNewBtn = new JToggleButton(Localizer.getString("SearchTab_WhatsNew"), IconFactory.EMPTY_IMAGE_16);
        this.whatsNewBtn.setToolTipText(Localizer.getString("SearchTab_TTTWhatsNew"));
        this.updateActivityBtnProps(this.whatsNewBtn);
        this.whatsNewBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                searchControlPanel.activateWhatsNewBox();
            }
        });
        this.browseHostBtn = new JToggleButton(Localizer.getString("SearchTab_BrowseHost"), GUIRegistry.getInstance().getIconFactory().getIcon("BrowseHost"));
        this.browseHostBtn.setToolTipText(Localizer.getString("SearchTab_TTTBrowseHost"));
        this.updateActivityBtnProps(this.browseHostBtn);
        this.browseHostBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                searchControlPanel.activateBrowseHostBox();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.keywordSearchBtn);
        buttonGroup.add(this.whatsNewBtn);
        buttonGroup.add(this.browseHostBtn);
        panelBuilder.add((Component)this.keywordSearchBtn, cellConstraints.xy(2, 2));
        panelBuilder.add((Component)this.whatsNewBtn, cellConstraints.xy(2, 4));
        panelBuilder.add((Component)this.browseHostBtn, cellConstraints.xy(2, 6));
        this.runningSearchActivityP = new JPanel();
        this.runningSearchActivityP.setOpaque(false);
        FormLayout formLayout2 = new FormLayout("6dlu, fill:p:grow, 6dlu", "2dlu, p, 1dlu, p, 2dlu");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout2, this.runningSearchActivityP);
        this.newSearchBtn = new JButton(Localizer.getString("SearchTab_NewSearch"), GUIRegistry.getInstance().getIconFactory().getIcon("Search"));
        this.newSearchBtn.setToolTipText(Localizer.getString("SearchTab_TTTNewSearch"));
        this.newSearchBtn.addActionListener(searchTab.getTabAction("CreateNewSearchAction"));
        this.updateActivityBtnProps(this.newSearchBtn);
        this.closeSearchBtn = new JButton(Localizer.getString("SearchTab_CloseSearch"), GUIRegistry.getInstance().getIconFactory().getIcon("Close"));
        this.closeSearchBtn.setToolTipText(Localizer.getString("SearchTab_TTTCloseSearch"));
        this.closeSearchBtn.addActionListener(searchTab.getTabAction("CloseSearchAction"));
        this.updateActivityBtnProps(this.closeSearchBtn);
        panelBuilder2.add((Component)this.newSearchBtn, cellConstraints.xy(2, 2));
        panelBuilder2.add((Component)this.closeSearchBtn, cellConstraints.xy(2, 4));
    }

    public void postInit() {
        this.keywordSearchBtn.doClick();
    }

    public void displayRunningSearchPanel() {
        JPanel jPanel = this.getContentPanel();
        jPanel.removeAll();
        jPanel.add((Component)this.runningSearchActivityP, "Center");
        jPanel.doLayout();
        jPanel.revalidate();
        jPanel.repaint();
        this.newSearchBtn.getModel().setRollover(false);
        this.closeSearchBtn.getModel().setRollover(false);
    }

    public void displayNewSearchPanel() {
        JPanel jPanel = this.getContentPanel();
        jPanel.removeAll();
        jPanel.add((Component)this.newSearchActivityP, "Center");
        jPanel.doLayout();
        jPanel.revalidate();
        jPanel.repaint();
        this.keywordSearchBtn.doClick();
    }

    private void updateActivityBtnProps(AbstractButton abstractButton) {
        abstractButton.setUI(ACTIVITY_BUTTON_UI);
        abstractButton.setIconTextGap(8);
        abstractButton.setHorizontalAlignment(2);
        abstractButton.setCursor(Cursor.getPredefinedCursor(12));
        abstractButton.setBorder(ROLLOVER_BUTTON_BORDER);
        abstractButton.setRolloverEnabled(true);
    }

    public void updateUI() {
        super.updateUI();
        if (this.keywordSearchBtn != null) {
            this.keywordSearchBtn.setUI(ACTIVITY_BUTTON_UI);
        }
        if (this.whatsNewBtn != null) {
            this.whatsNewBtn.setUI(ACTIVITY_BUTTON_UI);
        }
        if (this.browseHostBtn != null) {
            this.browseHostBtn.setUI(ACTIVITY_BUTTON_UI);
        }
    }

    private static class ActivityButtonUI
    extends BasicButtonUI {
        private Color fromColor = PhexColors.getBoxPanelBackground().darker();
        private Color toColor = PhexColors.getBoxPanelBackground().brighter();

        private ActivityButtonUI() {
        }

        public void update(Graphics graphics, JComponent jComponent) {
            if (jComponent.isOpaque()) {
                graphics.setColor(PhexColors.getBoxPanelBackground());
                int n = jComponent.getWidth();
                int n2 = jComponent.getHeight();
                graphics.fillRect(0, 0, n, n2);
                AbstractButton abstractButton = (AbstractButton)jComponent;
                if (abstractButton.isSelected()) {
                    GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.fromColor, n / 2, n2 / 2, this.toColor, true);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setPaint(gradientPaint);
                    graphics2D.fillRect(0, 0, n, n2);
                }
            }
            this.paint(graphics, jComponent);
        }
    }
}

