/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.cp;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.event.SearchDataEvent;
import phex.event.SearchDataListener;
import phex.gui.common.BoxPanel;
import phex.gui.common.table.FWTable;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.SearchTab;
import phex.gui.tabs.search.cp.BrowseHostSearchBox;
import phex.gui.tabs.search.cp.KeywordSearchBox;
import phex.gui.tabs.search.cp.SearchActivityBox;
import phex.gui.tabs.search.cp.SearchInfoBox;
import phex.gui.tabs.search.cp.WhatsNewSearchBox;
import phex.net.presentation.PresentationManager;
import phex.query.BrowseHostResults;
import phex.query.KeywordSearch;
import phex.query.QueryManager;
import phex.query.Search;
import phex.query.SearchContainer;
import phex.query.WhatsNewSearch;

public class SearchControlPanel
extends JPanel
implements SearchDataListener {
    private SearchContainer searchContainer;
    private SearchResultsDataModel displayedDataModel;
    private SearchTab searchTab;
    private int prefWidth;
    private SearchActivityBox activityBox;
    private JPanel searchBoxContentPanel;
    private KeywordSearchBox keywordSearchBox;
    private WhatsNewSearchBox whatsNewBox;
    private BrowseHostSearchBox browseHostBox;
    private SearchInfoBox infoBox;
    private JButton filterButton;
    private JScrollPane scrollPane;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SearchControlPanel(SearchTab searchTab) {
        super(new GridBagLayout());
        this.searchTab = searchTab;
        this.searchContainer = QueryManager.getInstance().getSearchContainer();
        this.initializeComponent();
        this.updateUI();
    }

    public void clearSearchHistory() {
        this.keywordSearchBox.clearSearchHistory();
    }

    public void initializeComponent() {
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("fill:d:grow", "p, p, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        this.keywordSearchBox = new KeywordSearchBox(this);
        this.whatsNewBox = new WhatsNewSearchBox(this);
        this.browseHostBox = new BrowseHostSearchBox(this);
        this.activityBox = new SearchActivityBox(this.searchTab, this);
        this.infoBox = new SearchInfoBox(this);
        this.prefWidth = 0;
        int n = 0;
        Dimension dimension = this.activityBox.getPreferredSize();
        this.prefWidth = Math.max(this.prefWidth, dimension.width);
        Dimension dimension2 = this.infoBox.getPreferredSize();
        this.prefWidth = Math.max(this.prefWidth, dimension2.width);
        Dimension dimension3 = this.keywordSearchBox.getPreferredSize();
        this.prefWidth = Math.max(this.prefWidth, dimension3.width);
        n = Math.max(n, dimension3.height);
        Dimension dimension4 = this.whatsNewBox.getPreferredSize();
        this.prefWidth = Math.max(this.prefWidth, dimension4.width);
        n = Math.max(n, dimension4.height);
        Dimension dimension5 = this.browseHostBox.getPreferredSize();
        this.prefWidth = Math.max(this.prefWidth, dimension5.width);
        n = Math.max(n, dimension5.height);
        dimension.width = this.prefWidth;
        this.keywordSearchBox.setPreferredSize(dimension);
        dimension2.width = this.prefWidth;
        this.keywordSearchBox.setPreferredSize(dimension2);
        dimension3.width = this.prefWidth;
        dimension3.height = n;
        this.keywordSearchBox.setPreferredSize(dimension3);
        dimension4.width = this.prefWidth;
        dimension4.height = n;
        this.whatsNewBox.setPreferredSize(dimension4);
        dimension5.width = this.prefWidth;
        dimension5.height = n;
        this.browseHostBox.setPreferredSize(dimension5);
        this.searchBoxContentPanel = new JPanel(new BorderLayout());
        panelBuilder.add((Component)this.searchBoxContentPanel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.activityBox, cellConstraints.xy(1, 2));
        panelBuilder.add((Component)this.infoBox, cellConstraints.xy(1, 3));
        this.activityBox.postInit();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = this.prefWidth;
        return dimension;
    }

    private void activateSearchBox(BoxPanel boxPanel) {
        this.searchBoxContentPanel.removeAll();
        this.searchBoxContentPanel.add((Component)boxPanel, "Center");
        this.searchBoxContentPanel.doLayout();
        this.searchBoxContentPanel.revalidate();
        this.searchBoxContentPanel.repaint();
    }

    public void setDisplayedSearch(SearchResultsDataModel searchResultsDataModel) {
        if (this.displayedDataModel != searchResultsDataModel) {
            if (this.displayedDataModel != null) {
                this.displayedDataModel.getSearch().removeSearchChangeListener(this);
            }
            this.displayedDataModel = searchResultsDataModel;
            if (this.displayedDataModel != null) {
                this.displayedDataModel.getSearch().addSearchChangeListener(this);
            }
            this.infoBox.setDisplayedSearch(this.displayedDataModel);
            this.updateControlPanel();
        }
    }

    public void activateKeywordSearchBox() {
        this.activateSearchBox(this.keywordSearchBox);
        this.keywordSearchBox.focusInputField();
    }

    public void activateBrowseHostBox() {
        this.activateSearchBox(this.browseHostBox);
        this.browseHostBox.focusInputField();
    }

    public void activateWhatsNewBox() {
        this.activateSearchBox(this.whatsNewBox);
        this.whatsNewBox.focusInputField();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateControlPanel() {
        if (this.displayedDataModel != null) {
            this.activityBox.displayRunningSearchPanel();
            Search search = this.displayedDataModel.getSearch();
            if (search instanceof WhatsNewSearch) {
                this.activateSearchBox(this.whatsNewBox);
                this.whatsNewBox.updateControlPanel((WhatsNewSearch)search);
                return;
            } else if (search instanceof KeywordSearch) {
                this.activateSearchBox(this.keywordSearchBox);
                this.keywordSearchBox.updateControlPanel((KeywordSearch)search);
                return;
            } else {
                if (!(search instanceof BrowseHostResults)) throw new RuntimeException("Unknwon search type");
                this.activateSearchBox(this.browseHostBox);
                this.browseHostBox.updateControlPanel((BrowseHostResults)search);
            }
            return;
        } else {
            this.activityBox.displayNewSearchPanel();
            this.whatsNewBox.updateControlPanel(null);
            this.keywordSearchBox.updateControlPanel(null);
            this.browseHostBox.updateControlPanel(null);
        }
    }

    public void updateUI() {
        super.updateUI();
        Color color = UIManager.getColor("controlDkShadow");
        Color color2 = UIManager.getColor("window");
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, color2), BorderFactory.createMatteBorder(1, 1, 1, 1, color)));
        this.setBackground(color2);
        if (this.scrollPane != null) {
            FWTable.updateFWTableScrollPane(this.scrollPane);
        }
    }

    public boolean startKeywordSearch(String string) {
        if (this.displayedDataModel != null && this.displayedDataModel.getSearch().isSearching()) {
            return false;
        }
        Search search = this.searchContainer.getRunningKeywordSearch(string);
        if (search != null) {
            SearchResultsDataModel searchResultsDataModel = SearchResultsDataModel.lookupResultDataModel(search);
            this.searchTab.setDisplayedSearch(searchResultsDataModel);
            return false;
        }
        if (this.displayedDataModel == null) {
            Search search2 = this.searchContainer.createSearch(string);
            SearchResultsDataModel searchResultsDataModel = SearchResultsDataModel.registerNewSearch(search2);
            this.searchTab.setDisplayedSearch(searchResultsDataModel);
        } else {
            Search search3 = this.displayedDataModel.getSearch();
            if (search3 instanceof KeywordSearch) {
                KeywordSearch keywordSearch = (KeywordSearch)search3;
                keywordSearch.setSearchString(string);
                keywordSearch.startSearching();
            } else {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Edited none keyword search");
                }
                return false;
            }
        }
        return true;
    }

    public boolean startBrowseHost(String string) {
        DestAddress destAddress;
        if (this.displayedDataModel != null && this.displayedDataModel.getSearch().isSearching()) {
            return false;
        }
        PresentationManager presentationManager = PresentationManager.getInstance();
        try {
            destAddress = presentationManager.createHostAddress(string, 6346);
        }
        catch (MalformedDestAddressException malformedDestAddressException) {
            return false;
        }
        Search search = this.searchContainer.getRunningBrowseHost(destAddress, null);
        if (search != null) {
            SearchResultsDataModel searchResultsDataModel = SearchResultsDataModel.lookupResultDataModel(search);
            this.searchTab.setDisplayedSearch(searchResultsDataModel);
            return false;
        }
        BrowseHostResults browseHostResults = this.searchContainer.createBrowseHostSearch(destAddress, null);
        SearchResultsDataModel searchResultsDataModel = SearchResultsDataModel.registerNewSearch(browseHostResults);
        this.searchTab.setDisplayedSearch(searchResultsDataModel);
        return true;
    }

    public void startWhatsNewSearch() {
        if (this.displayedDataModel != null && this.displayedDataModel.getSearch().isSearching()) {
            return;
        }
        Search search = QueryManager.getInstance().getSearchContainer().createWhatsNewSearch();
        SearchResultsDataModel searchResultsDataModel = SearchResultsDataModel.registerNewSearch(search);
        this.searchTab.setDisplayedSearch(searchResultsDataModel);
    }

    public void stopSearching() {
        if (this.displayedDataModel != null && this.displayedDataModel.getSearch().isSearching()) {
            this.displayedDataModel.getSearch().stopSearching();
        }
    }

    public void searchDataChanged(SearchDataEvent searchDataEvent) {
        short s = searchDataEvent.getType();
        switch (s) {
            case 0: 
            case 3: 
            case 4: {
                this.updateControlPanel();
            }
        }
    }

    static {
        $assertionsDisabled = !SearchControlPanel.class.desiredAssertionStatus();
    }

    private class WhatsNewSearchHandler
    extends AbstractAction
    implements ActionListener {
        private WhatsNewSearchHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SearchControlPanel.this.displayedDataModel != null && SearchControlPanel.this.displayedDataModel.getSearch().isSearching()) {
                return;
            }
            Search search = QueryManager.getInstance().getSearchContainer().createWhatsNewSearch();
            SearchResultsDataModel searchResultsDataModel = SearchResultsDataModel.registerNewSearch(search);
            SearchControlPanel.this.searchTab.setDisplayedSearch(searchResultsDataModel);
        }
    }
}

