/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.cp;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import phex.gui.common.BoxPanel;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.tabs.search.cp.SearchControlPanel;
import phex.query.WhatsNewSearch;
import phex.utils.Localizer;

public class WhatsNewSearchBox
extends BoxPanel {
    private SearchControlPanel controlPanel;
    private JButton whatsNewButton;
    private JButton whatsNewStopButton;

    public WhatsNewSearchBox(SearchControlPanel searchControlPanel) {
        super(Localizer.getString("SearchTab_WhatsNew"));
        this.controlPanel = searchControlPanel;
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("6dlu, p, 6dlu", "4dlu, p:grow, 4dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this.getContentPanel());
        this.whatsNewButton = new JButton(Localizer.getString("SearchTab_WhatsNew"), GUIRegistry.getInstance().getIconFactory().getIcon("Search"));
        this.whatsNewButton.setCursor(Cursor.getPredefinedCursor(12));
        this.whatsNewButton.setToolTipText(Localizer.getString("SearchTab_TTTWhatsNew"));
        this.whatsNewButton.setMargin(GUIUtils.NARROW_BUTTON_INSETS);
        this.whatsNewButton.addActionListener(new WhatsNewSearchHandler());
        StopSearchHandler stopSearchHandler = new StopSearchHandler();
        this.whatsNewStopButton = new JButton(Localizer.getString("SearchTab_StopSearch"), GUIRegistry.getInstance().getIconFactory().getIcon("Stop"));
        this.whatsNewStopButton.setCursor(Cursor.getPredefinedCursor(12));
        this.whatsNewStopButton.setToolTipText(Localizer.getString("SearchTab_TTTStopSearch"));
        this.whatsNewStopButton.setMargin(GUIUtils.NARROW_BUTTON_INSETS);
        this.whatsNewStopButton.addActionListener(stopSearchHandler);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.setLeftToRightButtonOrder(true);
        buttonBarBuilder.addFixedNarrow(this.whatsNewButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixedNarrow(this.whatsNewStopButton);
        buttonBarBuilder.addGlue();
        JPanel jPanel = buttonBarBuilder.getPanel();
        jPanel.setOpaque(false);
        panelBuilder.add((Component)jPanel, cellConstraints.xy(2, 2));
        this.adjustComponents();
    }

    private void adjustComponents() {
        if (this.whatsNewButton != null) {
            String string = this.whatsNewButton.getText();
            this.whatsNewButton.setText(Localizer.getString("SearchTab_WhatsNew"));
            Dimension dimension = this.whatsNewButton.getPreferredSize();
            this.whatsNewButton.setText(Localizer.getString("SearchTab_Searching"));
            Dimension dimension2 = this.whatsNewButton.getPreferredSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            this.whatsNewButton.setPreferredSize(dimension);
            this.whatsNewButton.setText(string);
        }
    }

    public void focusInputField() {
        this.whatsNewButton.requestFocus();
    }

    public void updateUI() {
        super.updateUI();
        this.adjustComponents();
    }

    public void updateControlPanel(WhatsNewSearch whatsNewSearch) {
        if (whatsNewSearch != null) {
            if (whatsNewSearch.isSearching()) {
                this.whatsNewButton.setText(Localizer.getString("SearchTab_Searching"));
                this.whatsNewButton.setToolTipText(Localizer.getString("SearchTab_TTTSearching"));
                this.whatsNewButton.setEnabled(false);
            } else {
                this.whatsNewButton.setText(Localizer.getString("SearchTab_WhatsNew"));
                this.whatsNewButton.setToolTipText(Localizer.getString("SearchTab_TTTWhatsNew"));
                this.whatsNewButton.setEnabled(true);
            }
        } else {
            this.whatsNewButton.setText(Localizer.getString("SearchTab_WhatsNew"));
            this.whatsNewButton.setToolTipText(Localizer.getString("SearchTab_TTTWhatsNew"));
            this.whatsNewButton.setEnabled(true);
        }
    }

    private class StopSearchHandler
    extends AbstractAction
    implements ActionListener {
        private StopSearchHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WhatsNewSearchBox.this.controlPanel.stopSearching();
        }
    }

    private class WhatsNewSearchHandler
    extends AbstractAction
    implements ActionListener {
        private WhatsNewSearchHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WhatsNewSearchBox.this.controlPanel.startWhatsNewSearch();
        }
    }
}

