/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.filterpanel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import phex.gui.actions.FWAction;
import phex.gui.common.table.FWTable;
import phex.gui.dialogs.filter.AdvSearchRulesDialog;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.filterpanel.FilterListTableModel;
import phex.rules.Rule;
import phex.utils.Localizer;

public class FilterListPanel
extends JPanel {
    private FilterListTableModel searchRuleTableModel;

    public FilterListPanel() {
        this.initializeComponent();
        this.updateUI();
    }

    private void initializeComponent() {
        this.setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("18dlu, fill:d:grow, 2dlu, d, 6dlu", "6dlu, p, 6dlu,");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        this.searchRuleTableModel = new FilterListTableModel(this);
        FWTable fWTable = new FWTable(this.searchRuleTableModel);
        fWTable.setVisibleRowCount(3);
        fWTable.setShowVerticalLines(false);
        JTableHeader jTableHeader = fWTable.getTableHeader();
        jTableHeader.setResizingAllowed(false);
        jTableHeader.setReorderingAllowed(false);
        JCheckBox jCheckBox = (JCheckBox)((Object)fWTable.getDefaultRenderer(Boolean.class));
        TableColumn tableColumn = fWTable.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(jCheckBox.getPreferredSize().width + 2);
        tableColumn.setMinWidth(jCheckBox.getPreferredSize().width + 2);
        TableCellRenderer tableCellRenderer = fWTable.getTableHeader().getDefaultRenderer();
        if (tableCellRenderer instanceof JLabel) {
            ((JLabel)((Object)tableCellRenderer)).setHorizontalAlignment(2);
        }
        tableColumn = fWTable.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new RuleCellRenderer());
        JScrollPane jScrollPane = FWTable.createFWTableScrollPane(fWTable);
        panelBuilder.add((Component)jScrollPane, cellConstraints.xy(2, 2));
        JButton jButton = new JButton(new AdvancedFilterAction());
        panelBuilder.add((Component)jButton, cellConstraints.xy(4, 2));
    }

    public void setDisplayedSearch(SearchResultsDataModel searchResultsDataModel) {
        this.searchRuleTableModel.setDisplayedSearch(searchResultsDataModel);
    }

    private class AdvancedFilterAction
    extends FWAction {
        public AdvancedFilterAction() {
            super(Localizer.getString("SearchTab_EditFilterRules"), null, Localizer.getString("SearchTab_TTTEditFilterRules"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new AdvSearchRulesDialog().show();
        }

        public void refreshActionState() {
            this.setEnabled(true);
        }
    }

    public class RuleCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Rule) {
                this.setText(((Rule)object).getName());
            }
            return this;
        }
    }
}

