/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.monitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import phex.common.IntObj;
import phex.download.RemoteFile;
import phex.event.SearchDataEvent;
import phex.event.SearchDataListener;
import phex.gui.models.ISearchDataModel;
import phex.gui.models.SearchTreeTableModel;
import phex.gui.tabs.search.SearchResultElement;
import phex.gui.tabs.search.SearchResultElementComparator;
import phex.msg.MsgManager;
import phex.query.QueryResultMonitor;
import phex.query.SearchFilter;

public class ResultMonitorDataModel
implements ISearchDataModel,
SearchDataListener {
    private ArrayList allRemoteFiles;
    private HashSet allSearchResultSHA1Set;
    private int allSearchResultCount;
    private ArrayList displayedSearchResults;
    private HashMap displayedSearchResultSHA1Map;
    private SearchTreeTableModel visualizationModel;
    private SearchResultElementComparator comparator;
    protected SearchFilter searchFilter;
    private IntObj searchElementCountObj;
    private IntObj filteredElementCountObj;

    public ResultMonitorDataModel() {
        QueryResultMonitor queryResultMonitor = MsgManager.getInstance().getQueryResultMonitor();
        queryResultMonitor.addSearchDataListener(this);
        this.allRemoteFiles = new ArrayList();
        this.allSearchResultSHA1Set = new HashSet();
        this.allSearchResultCount = 0;
        this.displayedSearchResults = new ArrayList();
        this.displayedSearchResultSHA1Map = new HashMap();
        this.searchElementCountObj = new IntObj();
        this.filteredElementCountObj = new IntObj();
        this.comparator = new SearchResultElementComparator();
        this.searchFilter = null;
    }

    public int getSearchElementCount() {
        return this.displayedSearchResults.size();
    }

    public IntObj getSearchElementCountObj() {
        if (this.searchElementCountObj.intValue() != this.displayedSearchResults.size()) {
            this.searchElementCountObj.setValue(this.displayedSearchResults.size());
        }
        return this.searchElementCountObj;
    }

    public IntObj getFilteredElementCountObj() {
        int n = this.getFilteredElementCount();
        if (this.filteredElementCountObj.intValue() != n) {
            this.filteredElementCountObj.setValue(n);
        }
        return this.filteredElementCountObj;
    }

    public int getFilteredElementCount() {
        return this.allSearchResultCount - this.displayedSearchResults.size();
    }

    public SearchResultElement getSearchElementAt(int n) {
        if (n < 0 || n >= this.displayedSearchResults.size()) {
            return null;
        }
        return (SearchResultElement)this.displayedSearchResults.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSearchResults(Object[] objectArray) {
        ArrayList arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                for (int i = 0; i < objectArray.length; ++i) {
                    RemoteFile remoteFile = (RemoteFile)objectArray[i];
                    this.addSearchResultForDisplay(remoteFile);
                    this.addSearchResultToAll(remoteFile);
                }
            }
        }
    }

    private void addSearchResultToAll(RemoteFile remoteFile) {
        this.allRemoteFiles.add(remoteFile);
        String string = remoteFile.getSHA1();
        boolean bl = false;
        if (string != null) {
            bl = this.allSearchResultSHA1Set.contains(string);
        }
        if (!bl) {
            ++this.allSearchResultCount;
            if (string != null && string.length() > 0) {
                this.allSearchResultSHA1Set.add(string);
            }
        }
    }

    private void addSearchResultForDisplay(RemoteFile remoteFile) {
        boolean bl = this.isFiltered(remoteFile);
        if (bl) {
            return;
        }
        SearchResultElement searchResultElement = null;
        String string = remoteFile.getSHA1();
        if (string != null) {
            searchResultElement = (SearchResultElement)this.displayedSearchResultSHA1Map.get(string);
        }
        if (searchResultElement != null) {
            searchResultElement.addRemoteFile(remoteFile);
            this.fireSearchResultAdded(remoteFile, searchResultElement);
        } else {
            searchResultElement = new SearchResultElement(remoteFile);
            int n = Collections.binarySearch(this.displayedSearchResults, searchResultElement, this.comparator);
            if (n <= 0) {
                if (string != null && string.length() > 0) {
                    this.displayedSearchResultSHA1Map.put(string, searchResultElement);
                }
                this.displayedSearchResults.add(-n - 1, searchResultElement);
                this.fireNewSearchResultAdded(searchResultElement, -n - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSortBy(int n, boolean bl) {
        ArrayList arrayList = this.displayedSearchResults;
        synchronized (arrayList) {
            this.comparator.setSortField(n, bl);
            Collections.sort(this.displayedSearchResults, this.comparator);
            this.fireAllSearchResultsChanged();
        }
    }

    public void setVisualizationModel(SearchTreeTableModel searchTreeTableModel) {
        this.visualizationModel = searchTreeTableModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSearchFilter(SearchFilter searchFilter) {
        ArrayList arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                this.searchFilter = searchFilter;
                this.searchFilter.setLastTimeUsed(System.currentTimeMillis());
                this.updateFilteredQueryList();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSearchFilter() {
        ArrayList arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                this.searchFilter = null;
                this.updateFilteredQueryList();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSearchResults() {
        ArrayList arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                this.allRemoteFiles.clear();
                this.allSearchResultSHA1Set.clear();
                this.allSearchResultCount = 0;
                this.displayedSearchResults.clear();
                this.displayedSearchResultSHA1Map.clear();
                this.fireAllSearchResultsChanged();
            }
        }
    }

    public SearchFilter getSearchFilter() {
        return this.searchFilter;
    }

    private boolean isFiltered(RemoteFile remoteFile) {
        boolean bl = false;
        if (this.searchFilter != null) {
            bl = this.searchFilter.isFiltered(remoteFile);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFilteredQueryList() {
        ArrayList arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                this.displayedSearchResultSHA1Map.clear();
                this.displayedSearchResults.clear();
                this.fireAllSearchResultsChanged();
                Iterator iterator = this.allRemoteFiles.iterator();
                while (iterator.hasNext()) {
                    RemoteFile remoteFile = (RemoteFile)iterator.next();
                    this.addSearchResultForDisplay(remoteFile);
                }
            }
        }
    }

    public void searchDataChanged(SearchDataEvent searchDataEvent) {
        if (searchDataEvent.getType() == 1) {
            Object[] objectArray = searchDataEvent.getSearchData();
            this.addSearchResults(objectArray);
        }
    }

    private void fireAllSearchResultsChanged() {
        if (this.visualizationModel == null) {
            return;
        }
        Object[] objectArray = new Object[]{this.visualizationModel.getRoot()};
        this.visualizationModel.fireTreeStructureChanged(this, objectArray, null, null);
    }

    private void fireNewSearchResultAdded(SearchResultElement searchResultElement, int n) {
        if (this.visualizationModel == null) {
            return;
        }
        Object[] objectArray = new Object[]{this.visualizationModel.getRoot()};
        int[] nArray = new int[]{n};
        Object[] objectArray2 = new Object[]{searchResultElement};
        if (this.displayedSearchResults.size() == 1) {
            this.visualizationModel.fireTreeStructureChanged(this, objectArray, nArray, objectArray2);
        } else {
            this.visualizationModel.fireTreeNodesInserted(this, objectArray, nArray, objectArray2);
        }
    }

    private void fireSearchResultAdded(RemoteFile remoteFile, SearchResultElement searchResultElement) {
        if (this.visualizationModel == null) {
            return;
        }
        Object[] objectArray = new Object[]{this.visualizationModel.getRoot(), searchResultElement};
        Object[] objectArray2 = new Object[]{remoteFile};
        this.visualizationModel.fireTreeNodesInserted(this, objectArray, null, objectArray2);
    }
}

