/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.monitor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import phex.event.QueryHistoryChangeListener;
import phex.gui.common.FWElegantPanel;
import phex.gui.common.GUIRegistry;
import phex.gui.common.IntegerTextField;
import phex.gui.common.table.FWTable;
import phex.gui.models.QueryHistoryMonitorTableModel;
import phex.gui.tabs.FWTab;
import phex.query.QueryHistoryMonitor;
import phex.query.QueryManager;
import phex.utils.Localizer;
import phex.xml.sax.gui.DGuiSettings;

public class SearchMonitorTab
extends FWTab {
    private QueryHistoryMonitor queryHistory = QueryManager.getInstance().getQueryHistoryMonitor();
    private JCheckBox enableMonitorCheckbox;
    private JTextField numberOfMonitorRows;
    private QueryHistoryMonitorTableModel queryHistoryModel;
    private JTable mMonitorTable;
    private JScrollPane monitorTableScrollPane;

    public SearchMonitorTab() {
        super(1008, Localizer.getString("SearchMonitorTab_SearchMonitor"), GUIRegistry.getInstance().getIconFactory().getIcon("Monitor"), Localizer.getString("SearchMonitorTab_TTTSearchMonitor"), Localizer.getChar("SearchMonitorTab_Mnemonic"), KeyStroke.getKeyStroke(Localizer.getString("SearchMonitorTab_Accelerator")), 7);
    }

    public void initComponent(DGuiSettings dGuiSettings) {
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, fill:p:grow, 2dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        JPanel jPanel = new JPanel();
        FWElegantPanel fWElegantPanel = new FWElegantPanel(Localizer.getString("SearchMonitorTab_SearchMonitor"), jPanel);
        panelBuilder.add((Component)fWElegantPanel, cellConstraints.xy(2, 2));
        FormLayout formLayout2 = new FormLayout("fill:d:grow", "p, 1dlu, fill:d:grow");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout2, jPanel);
        JPanel jPanel2 = new JPanel();
        panelBuilder2.add((Component)jPanel2, cellConstraints.xy(1, 1));
        FormLayout formLayout3 = new FormLayout("d, fill:d:grow, d, 1dlu, d, 1dlu, d", "p");
        PanelBuilder panelBuilder3 = new PanelBuilder(formLayout3, jPanel2);
        this.enableMonitorCheckbox = new JCheckBox(Localizer.getString("SearchMonitorTab_enable"));
        this.enableMonitorCheckbox.setSelected(this.queryHistory.isHistoryMonitored());
        this.enableMonitorCheckbox.addActionListener(new EnableMonitorActionListener());
        panelBuilder3.add((Component)this.enableMonitorCheckbox, cellConstraints.xy(1, 1));
        panelBuilder3.addLabel(Localizer.getString("SearchMonitorTab_Show"), cellConstraints.xy(3, 1));
        this.numberOfMonitorRows = new IntegerTextField(String.valueOf(this.queryHistory.getMaxHistorySize()), 3, 3);
        this.numberOfMonitorRows.getDocument().addDocumentListener(new MonitorRowsDocumentListener());
        panelBuilder3.add((Component)this.numberOfMonitorRows, cellConstraints.xy(5, 1));
        panelBuilder3.addLabel(Localizer.getString("SearchMonitorTab_Rows"), cellConstraints.xy(7, 1));
        this.queryHistoryModel = new QueryHistoryMonitorTableModel();
        this.mMonitorTable = new JTable(this.queryHistoryModel);
        this.monitorTableScrollPane = FWTable.createFWTableScrollPane(this.mMonitorTable);
        panelBuilder2.add((Component)this.monitorTableScrollPane, cellConstraints.xy(1, 3));
        this.queryHistory.setQueryHistoryChangeListener(new QueryHistoryChangeListener(){

            public void queryHistoryChanged() {
                SearchMonitorTab.this.queryHistoryModel.fireTableDataChanged();
            }
        });
    }

    public boolean isVisibleByDefault() {
        return false;
    }

    public void updateUI() {
        super.updateUI();
        if (this.monitorTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.monitorTableScrollPane);
        }
    }

    private class MonitorRowsDocumentListener
    implements DocumentListener {
        private MonitorRowsDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateMonitorRows();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateMonitorRows();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void updateMonitorRows() {
            String string = SearchMonitorTab.this.numberOfMonitorRows.getText();
            try {
                int n = Integer.parseInt(string);
                n = Math.max(1, n);
                SearchMonitorTab.this.queryHistory.setMaxHistroySize(n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private class EnableMonitorActionListener
    implements ActionListener {
        private EnableMonitorActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SearchMonitorTab.this.queryHistory.setHistoryMonitored(SearchMonitorTab.this.enableMonitorCheckbox.isSelected());
        }
    }
}

