/*
 * Decompiled with CFR 0.152.
 */
package phex.gwebcache;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import phex.common.address.AddressUtils;
import phex.connection.ProtocolNotSupportedException;
import phex.gwebcache.GWebCacheContainer;
import phex.gwebcache.GWebCacheManager;
import phex.utils.NLogger;

public class GWebCache {
    private static final int MIN_RECONNECT_WAIT = 1800000;
    private URL url;
    private boolean isPhexCache;
    private long lastRequestTime;
    private int failedInRowCount;
    private int hash = 0;

    public GWebCache(URL uRL) throws IOException {
        this(uRL, false);
    }

    public GWebCache(URL uRL, boolean bl) throws IOException {
        if (uRL == null) {
            throw new NullPointerException("Null url given.");
        }
        if (!uRL.getProtocol().equals("http")) {
            throw new ProtocolNotSupportedException("Only http URLs are supported for a GWebCacheConnection");
        }
        if (uRL.getPort() == 80) {
            uRL = new URL(uRL.getProtocol(), uRL.getHost(), -1, uRL.getFile());
        }
        GWebCacheContainer gWebCacheContainer = GWebCacheManager.getInstance().getGWebCacheContainer();
        if (!bl && gWebCacheContainer.isPhexGWebCache(uRL.toExternalForm())) {
            NLogger.error("GWEBCACHE", "Trying to add Phex cache without Phex flag!");
            bl = true;
        }
        this.url = uRL;
        this.isPhexCache = bl;
    }

    public boolean isPhexCache() {
        return this.isPhexCache;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getHostDomain() {
        String string = this.url.getHost();
        if (AddressUtils.isIPHostName(string)) {
            return string;
        }
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(46, n - 1);
        if (n2 != -1) {
            return string.substring(n2 + 1);
        }
        return string;
    }

    public int getFailedInRowCount() {
        return this.failedInRowCount;
    }

    public long getLastRequestTime() {
        return this.lastRequestTime;
    }

    public void countConnectionAttempt(boolean bl) {
        this.lastRequestTime = System.currentTimeMillis();
        this.failedInRowCount = bl ? ++this.failedInRowCount : 0;
    }

    public long getEarliestReConnectTime() {
        return (long)(1800000 * (this.failedInRowCount + 1)) + this.lastRequestTime;
    }

    public void setFailedInRowCount(int n) {
        this.failedInRowCount = n;
    }

    public void setLastRequestTime(long l) {
        this.lastRequestTime = l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GWebCache)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        GWebCache gWebCache = (GWebCache)object;
        return new EqualsBuilder().append(this.url.getHost(), gWebCache.getUrl().getHost()).isEquals();
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = new HashCodeBuilder(17, 37).append(this.url.getHost()).toHashCode();
        }
        return this.hash;
    }
}

