/*
 * Decompiled with CFR 0.152.
 */
package phex.gwebcache;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.connection.ProtocolNotSupportedException;
import phex.gwebcache.GWebCache;
import phex.net.presentation.PresentationManager;
import phex.security.PhexSecurityManager;
import phex.utils.IOUtil;
import phex.utils.NLogger;
import phex.utils.NormalizableURL;
import phex.utils.StringUtils;
import phex.utils.URLCodecUtils;
import phex.utils.VersionUtils;

public class GWebCacheConnection {
    private static final String PING_QUERY = "ping=1";
    private static final String HOST_FILE_QUERY = "hostfile=1";
    private static final String URL_FILE_QUERY = "urlfile=1";
    private static final String IP_QUERY = "ip=";
    private static final String URL_QUERY = "url=";
    private static final String QUERY_POSTFIX = "&client=PHEX&version=" + VersionUtils.getFullProgramVersion();
    private GWebCache gWebCache;
    private HttpMethod method;
    private BufferedReader reader;
    boolean isCacheBad;

    public GWebCacheConnection(GWebCache gWebCache) throws ProtocolNotSupportedException {
        if (!gWebCache.getUrl().getProtocol().equals("http")) {
            throw new ProtocolNotSupportedException("Only http URLs are supported for a GWebCacheConnection");
        }
        this.gWebCache = gWebCache;
        this.isCacheBad = false;
    }

    public GWebCache getGWebCache() {
        return this.gWebCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendPingRequest() {
        try {
            URL uRL = new URL(this.gWebCache.getUrl(), this.gWebCache.getUrl().getPath() + '?' + PING_QUERY + QUERY_POSTFIX);
            if (uRL.getHost() == null) {
                NLogger.warn("GWEBCACHE", (Object)"Host is null");
                this.isCacheBad = true;
                boolean bl = false;
                return bl;
            }
            this.openConnection(uRL);
            String string = this.reader.readLine();
            if (string != null && string.startsWith("PONG")) {
                boolean bl = true;
                return bl;
            }
            this.isCacheBad = true;
            boolean bl = false;
            return bl;
        }
        catch (UnknownHostException unknownHostException) {
            NLogger.debug(GWebCacheConnection.class, (Object)unknownHostException, (Throwable)unknownHostException);
            this.isCacheBad = true;
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            NLogger.debug(GWebCacheConnection.class, (Object)iOException, (Throwable)iOException);
            this.isCacheBad = true;
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DestAddress[] sendHostFileRequest() {
        String string;
        try {
            URL uRL = new URL(this.gWebCache.getUrl(), this.gWebCache.getUrl().getPath() + '?' + HOST_FILE_QUERY + QUERY_POSTFIX);
            if (uRL.getHost() == null) {
                NLogger.warn("GWEBCACHE", (Object)"Host is null");
                this.isCacheBad = true;
                DestAddress[] destAddressArray = null;
                return destAddressArray;
            }
            this.openConnection(uRL);
            string = this.reader.readLine();
            if (string != null && string.startsWith("ERROR")) {
                this.isCacheBad = true;
                DestAddress[] destAddressArray = null;
                return destAddressArray;
            }
            boolean bl = false;
            ArrayList<DestAddress> arrayList = new ArrayList<DestAddress>(20);
            PhexSecurityManager phexSecurityManager = PhexSecurityManager.getInstance();
            PresentationManager presentationManager = PresentationManager.getInstance();
            block13: while (string != null) {
                try {
                    DestAddress destAddress = presentationManager.createHostAddress(string, -1);
                    if (!destAddress.isValidAddress()) {
                        throw new MalformedDestAddressException("Invalid address.");
                    }
                    byte by = phexSecurityManager.controlHostAddressAccess(destAddress);
                    switch (by) {
                        case 2: 
                        case 3: {
                            string = this.reader.readLine();
                            continue block13;
                        }
                    }
                    arrayList.add(destAddress);
                }
                catch (MalformedDestAddressException malformedDestAddressException) {
                    NLogger.debug("GWEBCACHE", (Object)("Invalid host found: " + string));
                    bl = true;
                    string = this.reader.readLine();
                    continue;
                }
                string = this.reader.readLine();
            }
            if (arrayList.size() == 0 && bl) {
                this.isCacheBad = true;
                DestAddress[] destAddressArray = null;
                return destAddressArray;
            }
            DestAddress[] destAddressArray = new DestAddress[arrayList.size()];
            arrayList.toArray(destAddressArray);
            NLogger.debug("GWEBCACHE", (Object)("Hosts found: " + destAddressArray.length));
            DestAddress[] destAddressArray2 = destAddressArray;
            return destAddressArray2;
        }
        catch (IOException iOException) {
            NLogger.debug(GWebCacheConnection.class, (Object)iOException, (Throwable)iOException);
            this.isCacheBad = true;
            string = null;
            return string;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] sendURLFileRequest() {
        String string;
        try {
            Object object;
            Object object2;
            URL uRL = new URL(this.gWebCache.getUrl(), this.gWebCache.getUrl().getPath() + '?' + URL_FILE_QUERY + QUERY_POSTFIX);
            if (uRL.getHost() == null) {
                NLogger.warn("GWEBCACHE", (Object)"Host is null");
                this.isCacheBad = true;
                URL[] uRLArray = null;
                return uRLArray;
            }
            this.openConnection(uRL);
            string = this.reader.readLine();
            if (string != null && string.startsWith("ERROR")) {
                this.isCacheBad = true;
                URL[] uRLArray = null;
                return uRLArray;
            }
            boolean bl = false;
            ArrayList<URL> arrayList = new ArrayList<URL>(20);
            for (int i = 0; string != null && i < 20; ++i) {
                try {
                    object2 = new NormalizableURL(string);
                    ((NormalizableURL)object2).normalize();
                    object = new URL(((NormalizableURL)object2).toExternalForm());
                    if (!((URL)object).getProtocol().equals("http")) {
                        throw new ProtocolNotSupportedException("Only http URLs are supported for a GWebCacheConnection");
                    }
                    arrayList.add((URL)object);
                }
                catch (MalformedURLException malformedURLException) {
                    bl = true;
                }
                string = this.reader.readLine();
            }
            if (arrayList.size() == 0 && bl) {
                this.isCacheBad = true;
                object2 = null;
                return object2;
            }
            object2 = new URL[arrayList.size()];
            arrayList.toArray((T[])object2);
            NLogger.debug("GWEBCACHE", (Object)("URLs found: " + ((Object)object2).length));
            object = object2;
            return object;
        }
        catch (IOException iOException) {
            NLogger.debug(GWebCacheConnection.class, (Object)iOException, (Throwable)iOException);
            this.isCacheBad = true;
            string = null;
            return string;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRequest(String string, String string2) {
        if (string == null && string2 == null) {
            throw new IllegalArgumentException("Must provide at least one of hostIP or cacheURL.");
        }
        try {
            URL uRL;
            StringBuffer stringBuffer = new StringBuffer();
            if (string != null) {
                stringBuffer.append(IP_QUERY);
                stringBuffer.append(URLCodecUtils.encodeURL(string));
            }
            if (string2 != null) {
                if (string != null) {
                    stringBuffer.append('&');
                }
                stringBuffer.append(URL_QUERY);
                stringBuffer.append(URLCodecUtils.encodeURL(string2));
            }
            if ((uRL = new URL(this.gWebCache.getUrl(), this.gWebCache.getUrl().getPath() + '?' + stringBuffer.toString() + QUERY_POSTFIX)).getHost() == null) {
                NLogger.warn("GWEBCACHE", (Object)"Host is null");
                this.isCacheBad = true;
                boolean bl = false;
                return bl;
            }
            this.openConnection(uRL);
            String string3 = this.reader.readLine();
            if (string3 != null && string3.startsWith("OK")) {
                boolean bl = true;
                return bl;
            }
            this.isCacheBad = true;
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            NLogger.debug(GWebCacheConnection.class, (Object)iOException, (Throwable)iOException);
            this.isCacheBad = true;
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeConnection();
        }
    }

    public boolean isCacheBad() {
        return this.isCacheBad;
    }

    private void openConnection(URL uRL) throws IOException {
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
        if (ServiceManager.sCfg.isHttpProxyUsed && !StringUtils.isEmpty(ServiceManager.sCfg.httpProxyHost)) {
            httpClient.getHostConfiguration().setProxy(ServiceManager.sCfg.httpProxyHost, ServiceManager.sCfg.httpProxyPort);
        }
        this.method = new GetMethod(uRL.toExternalForm());
        this.method.setFollowRedirects(false);
        this.method.addRequestHeader("Cache-Control", "no-cache");
        this.method.addRequestHeader("User-Agent", Environment.getPhexVendor());
        this.method.addRequestHeader("Connection", "close");
        NLogger.debug("GWEBCACHE", (Object)("Open GWebCache connection to " + uRL + "."));
        int n = httpClient.executeMethod(this.method);
        NLogger.debug("GWEBCACHE", (Object)("GWebCache " + uRL + " returned response code: " + n));
        if (n < 200 || n > 299) {
            throw new ConnectException("GWebCache service not available, response code: " + n);
        }
        InputStream inputStream = this.method.getResponseBodyAsStream();
        if (inputStream == null) {
            throw new ConnectException("Empty response.");
        }
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
    }

    private void closeConnection() {
        IOUtil.closeQuietly(this.reader);
        this.reader = null;
        if (this.method != null) {
            this.method.releaseConnection();
            this.method = null;
        }
        NLogger.debug("GWEBCACHE", (Object)"Releasing HTTP method.");
    }
}

