/*
 * Decompiled with CFR 0.152.
 */
package phex.gwebcache;

import java.util.TimerTask;
import phex.common.AbstractManager;
import phex.common.Environment;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.connection.NetworkManager;
import phex.gwebcache.GWebCacheContainer;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.utils.NLogger;

public class GWebCacheManager
extends AbstractManager {
    private GWebCacheContainer gWebCacheContainer;
    private boolean isThreadRequestRunning = false;

    public GWebCacheContainer getGWebCacheContainer() {
        return this.gWebCacheContainer;
    }

    public synchronized void invokeQueryMoreHostsRequest(boolean bl) {
        if (this.isThreadRequestRunning) {
            return;
        }
        this.isThreadRequestRunning = true;
        QueryHostsRunner queryHostsRunner = new QueryHostsRunner(bl);
        ThreadPool.getInstance().addJob(queryHostsRunner, "GWebCacheQuery-" + Integer.toHexString(queryHostsRunner.hashCode()));
    }

    public void invokeUpdateRemoteGWebCache(DestAddress destAddress, boolean bl) {
        UpdateGWebCacheRunner updateGWebCacheRunner = new UpdateGWebCacheRunner(destAddress, bl);
        ThreadPool.getInstance().addJob(updateGWebCacheRunner, "GWebCacheQuery-" + Integer.toHexString(updateGWebCacheRunner.hashCode()));
    }

    public synchronized void invokeQueryMoreGWebCachesRequest(boolean bl) {
        if (this.isThreadRequestRunning) {
            return;
        }
        this.isThreadRequestRunning = true;
        QueryGWebCachesRunner queryGWebCachesRunner = new QueryGWebCachesRunner(bl);
        ThreadPool.getInstance().addJob(queryGWebCachesRunner, "GWebCacheQuery-" + Integer.toHexString(queryGWebCachesRunner.hashCode()));
    }

    public static GWebCacheManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        this.gWebCacheContainer = new GWebCacheContainer();
        return true;
    }

    public boolean onPostInitialization() {
        Environment.getInstance().scheduleTimerTask(new QueryGWebCacheTimer(), 0L, 600000L);
        Environment.getInstance().scheduleTimerTask(new UpdateGWebCacheTimer(), 3600000L, 3600000L);
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
    }

    private final class UpdateGWebCacheTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 3600000L;

        private UpdateGWebCacheTimer() {
        }

        public void run() {
            NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
            NetworkManager networkManager = NetworkManager.getInstance();
            if (networkManager.isConnected() || networkHostsContainer.getTotalConnectionCount() > 0) {
                IpAddress ipAddress;
                DestAddress destAddress = null;
                if (networkManager.hasConnectedIncoming() && (ipAddress = (destAddress = networkManager.getLocalAddress()).getIpAddress()) != null && ipAddress.isSiteLocalIP()) {
                    destAddress = null;
                }
                GWebCacheManager.this.invokeUpdateRemoteGWebCache(destAddress, true);
            }
        }
    }

    private final class QueryGWebCacheTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 600000L;

        private QueryGWebCacheTimer() {
        }

        public void run() {
            try {
                NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
                if (NetworkManager.getInstance().isConnected() || networkHostsContainer.getTotalConnectionCount() > 0) {
                    GWebCacheManager.this.invokeQueryMoreGWebCachesRequest(false);
                    GWebCacheManager.this.invokeQueryMoreHostsRequest(true);
                }
            }
            catch (Throwable throwable) {
                NLogger.error("GWEBCACHE", (Object)throwable, throwable);
            }
        }
    }

    private final class QueryHostsRunner
    implements Runnable {
        private boolean preferPhex;

        public QueryHostsRunner(boolean bl) {
            this.preferPhex = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                GWebCacheManager.this.gWebCacheContainer.queryMoreHosts(this.preferPhex);
            }
            finally {
                GWebCacheManager.this.isThreadRequestRunning = false;
            }
        }
    }

    private final class UpdateGWebCacheRunner
    implements Runnable {
        private final DestAddress myHostAddress;
        private boolean preferPhex;

        private UpdateGWebCacheRunner(DestAddress destAddress, boolean bl) {
            this.myHostAddress = destAddress;
            this.preferPhex = bl;
        }

        public void run() {
            GWebCacheManager.this.gWebCacheContainer.updateRemoteGWebCache(this.myHostAddress, this.preferPhex);
        }
    }

    private final class QueryGWebCachesRunner
    implements Runnable {
        private boolean preferPhex;

        public QueryGWebCachesRunner(boolean bl) {
            this.preferPhex = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                GWebCacheManager.this.gWebCacheContainer.queryMoreGWebCaches(this.preferPhex);
            }
            finally {
                GWebCacheManager.this.isThreadRequestRunning = false;
            }
        }
    }

    private static class Holder {
        protected static final GWebCacheManager manager = new GWebCacheManager();

        private Holder() {
        }
    }
}

