/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimerTask;
import java.util.TreeSet;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.address.AddressUtils;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.connection.NetworkManager;
import phex.event.AsynchronousDispatcher;
import phex.event.CaughtHostsChangeListener;
import phex.gwebcache.GWebCacheManager;
import phex.host.CatchedHostCache;
import phex.host.CaughtHost;
import phex.msg.PongMsg;
import phex.security.PhexSecurityManager;
import phex.udp.hostcache.UdpHostCache;
import phex.udp.hostcache.UdpHostCacheManager;
import phex.utils.IPUtils;
import phex.utils.NLogger;
import phex.utils.PriorityQueue;

public class CaughtHostsContainer {
    public static final short HIGH_PRIORITY = 2;
    public static final short NORMAL_PRIORITY = 1;
    public static final short LOW_PRIORITY = 0;
    private static final int FREE_SLOT_SET_SIZE = 8;
    private PriorityQueue caughtHosts;
    private HashSet uniqueCaughtHosts;
    private CatchedHostCache catchedHostCache;
    private Collection freeLeafSlotSet;
    private Collection freeUltrapeerSlotSet;
    private ArrayList listenerList = new ArrayList(2);
    private boolean hasChangedSinceLastSave;

    public CaughtHostsContainer() {
        int[] nArray = new int[3];
        nArray[2] = (int)Math.round((double)ServiceManager.sCfg.mNetMaxHostToCatch * 2.0 / 3.0);
        nArray[1] = (int)Math.round((double)(ServiceManager.sCfg.mNetMaxHostToCatch - nArray[2]) * 2.0 / 3.0);
        nArray[0] = ServiceManager.sCfg.mNetMaxHostToCatch - nArray[2] - nArray[1];
        this.caughtHosts = new PriorityQueue(nArray);
        this.uniqueCaughtHosts = new HashSet();
        this.catchedHostCache = new CatchedHostCache();
        Environment.getInstance().scheduleTimerTask(new SaveHostsContainerTimer(), 60000L, 60000L);
        this.freeUltrapeerSlotSet = this.createFreeSlotContainer();
        this.freeLeafSlotSet = this.createFreeSlotContainer();
    }

    public void initializeCaughtHostsContainer() {
        this.caughtHosts.clear();
        this.catchedHostCache.clear();
        this.hasChangedSinceLastSave = false;
        this.loadHostsFromFile();
    }

    public boolean addCaughtHost(PongMsg pongMsg) {
        Object object;
        Object object2;
        Object object3;
        Set set;
        short s;
        int n;
        byte[] byArray = pongMsg.getIP();
        DefaultDestAddress defaultDestAddress = new DefaultDestAddress(byArray, n = pongMsg.getPort());
        boolean bl = this.isValidCaughtHostAddress(defaultDestAddress);
        if (!bl) {
            return false;
        }
        CaughtHost caughtHost = new CaughtHost(defaultDestAddress);
        int n2 = pongMsg.getDailyUptime();
        if (n2 > 0) {
            caughtHost.setDailyUptime(n2);
        }
        if (pongMsg.isUltrapeerMarked()) {
            s = 2;
            if (pongMsg.hasFreeLeafSlots()) {
                this.addToFreeLeafSlotSet(caughtHost);
            }
            if (pongMsg.hasFreeUPSlots()) {
                this.addToFreeUltrapeerSlotSet(caughtHost);
            }
        } else {
            s = 0;
        }
        if ((set = pongMsg.getIPPDestAddresses()) != null) {
            object3 = set.iterator();
            while (object3.hasNext()) {
                object2 = (DestAddress)object3.next();
                if (!this.isValidCaughtHostAddress((DestAddress)object2)) continue;
                this.addToCaughtHostFetcher(caughtHost, (short)2);
            }
        }
        if ((object3 = pongMsg.getUdpHostCaches()) != null) {
            object2 = UdpHostCacheManager.getInstance();
            object = set.iterator();
            while (object.hasNext()) {
                UdpHostCache udpHostCache = (UdpHostCache)object.next();
                ((UdpHostCacheManager)object2).getUdpHostCacheContainer().addCache(udpHostCache);
            }
        }
        if ((object2 = pongMsg.getUdpHostCache()) != null) {
            object = UdpHostCacheManager.getInstance();
            ((UdpHostCacheManager)object).getUdpHostCacheContainer().addFunctionalCache((UdpHostCache)object2);
        }
        this.addPersistentCaughtHost(caughtHost);
        boolean bl2 = this.addToCaughtHostFetcher(caughtHost, s);
        return bl2;
    }

    public void addCaughtHost(DestAddress destAddress, short s) {
        boolean bl = this.isValidCaughtHostAddress(destAddress);
        if (!bl) {
            return;
        }
        CaughtHost caughtHost = new CaughtHost(destAddress);
        this.addPersistentCaughtHost(caughtHost);
        this.addToCaughtHostFetcher(caughtHost, s);
    }

    private synchronized boolean addToCaughtHostFetcher(CaughtHost caughtHost, short s) {
        boolean bl = false;
        if (!this.uniqueCaughtHosts.contains(caughtHost)) {
            bl = this.uniqueCaughtHosts.add(caughtHost);
            Object object = this.caughtHosts.addToHead(caughtHost, s);
            if (object != null) {
                this.uniqueCaughtHosts.remove(object);
            }
            this.fireCaughtHostsChanged();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPersistentCaughtHost(CaughtHost caughtHost) {
        CatchedHostCache catchedHostCache = this.catchedHostCache;
        synchronized (catchedHostCache) {
            DestAddress destAddress = caughtHost.getHostAddress();
            CaughtHost caughtHost2 = this.catchedHostCache.getCaughHost(destAddress);
            if (caughtHost2 == null) {
                this.catchedHostCache.add(caughtHost);
            } else {
                this.catchedHostCache.remove(caughtHost2);
                if (caughtHost.getDailyUptime() > 0) {
                    caughtHost2.setDailyUptime(caughtHost.getDailyUptime());
                }
                this.catchedHostCache.add(caughtHost2);
            }
            this.hasChangedSinceLastSave = true;
        }
    }

    public synchronized int getCaughtHostsCount() {
        return this.caughtHosts.getSize();
    }

    public synchronized DestAddress getNextCaughtHost() {
        this.ensureMinCaughHosts();
        if (!this.caughtHosts.isEmpty()) {
            CaughtHost caughtHost = (CaughtHost)this.caughtHosts.removeMaxPriority();
            return caughtHost.getHostAddress();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportConnectionStatus(DestAddress destAddress, boolean bl) {
        boolean bl2 = this.isValidCaughtHostAddress(destAddress);
        if (!bl2) {
            return;
        }
        CatchedHostCache catchedHostCache = this.catchedHostCache;
        synchronized (catchedHostCache) {
            CaughtHost caughtHost = this.catchedHostCache.getCaughHost(destAddress);
            if (caughtHost == null) {
                caughtHost = new CaughtHost(destAddress);
            } else {
                this.catchedHostCache.remove(caughtHost);
            }
            if (bl) {
                caughtHost.setLastSuccessfulConnection(System.currentTimeMillis());
            } else {
                caughtHost.setLastFailedConnection(System.currentTimeMillis());
            }
            this.catchedHostCache.add(caughtHost);
            this.hasChangedSinceLastSave = true;
        }
    }

    private void ensureMinCaughHosts() {
        int n = (int)Math.ceil((double)ServiceManager.sCfg.mNetMaxHostToCatch / 100.0);
        if (this.caughtHosts.getSize() < n) {
            UdpHostCacheManager.getInstance().invokeQueryCachesRequest();
            NLogger.info("GLOBAL", (Object)" Started a UDP HOST CACHE Query to ensure min no of hosts in the caughthost container");
            GWebCacheManager.getInstance().invokeQueryMoreHostsRequest(false);
        }
    }

    private boolean isValidCaughtHostAddress(DestAddress destAddress) {
        if (destAddress.isLocalHost() || !destAddress.isValidAddress() || destAddress.isSiteLocalAddress()) {
            return false;
        }
        return !IPUtils.isPortInUserInvalidList(destAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToFreeUltrapeerSlotSet(CaughtHost caughtHost) {
        Collection collection = this.freeUltrapeerSlotSet;
        synchronized (collection) {
            this.freeUltrapeerSlotSet.add(caughtHost);
            if (this.freeUltrapeerSlotSet.size() > 8) {
                TreeSet treeSet = (TreeSet)this.freeUltrapeerSlotSet;
                CaughtHost caughtHost2 = (CaughtHost)treeSet.last();
                this.freeUltrapeerSlotSet.remove(caughtHost2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToFreeLeafSlotSet(CaughtHost caughtHost) {
        Collection collection = this.freeLeafSlotSet;
        synchronized (collection) {
            this.freeLeafSlotSet.add(caughtHost);
            if (this.freeLeafSlotSet.size() > 8) {
                TreeSet treeSet = (TreeSet)this.freeLeafSlotSet;
                CaughtHost caughtHost2 = (CaughtHost)treeSet.last();
                this.freeLeafSlotSet.remove(caughtHost2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getFreeUltrapeerSlotHosts() {
        Collection collection = this.freeUltrapeerSlotSet;
        synchronized (collection) {
            ArrayList arrayList = new ArrayList(this.freeUltrapeerSlotSet);
            arrayList.trimToSize();
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getFreeLeafSlotHosts() {
        Collection collection = this.freeLeafSlotSet;
        synchronized (collection) {
            ArrayList arrayList = new ArrayList(this.freeLeafSlotSet);
            arrayList.trimToSize();
            return arrayList;
        }
    }

    private Collection createFreeSlotContainer() {
        TreeSet treeSet = new TreeSet(new SlotHostComparator());
        return treeSet;
    }

    private void loadHostsFromFile() {
        NLogger.debug(CaughtHostsContainer.class, (Object)"Loading hosts file.");
        try {
            String string;
            Object object;
            BufferedReader bufferedReader;
            NetworkManager networkManager = NetworkManager.getInstance();
            File file = networkManager.getGnutellaNetwork().getHostsFile();
            if (file.exists()) {
                bufferedReader = new BufferedReader(new FileReader(file));
            } else {
                NLogger.debug(CaughtHostsContainer.class, (Object)"Load default hosts file.");
                object = ClassLoader.getSystemResourceAsStream("phex/resources/phex.hosts");
                if (object != null) {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
                } else {
                    NLogger.debug(CaughtHostsContainer.class, (Object)"Default Phex Hosts file not found.");
                    return;
                }
            }
            object = PhexSecurityManager.getInstance();
            short s = 0;
            block5: while ((string = bufferedReader.readLine()) != null) {
                CaughtHost caughtHost;
                if (string.startsWith("#") || (caughtHost = this.parseCaughtHostFromLine(string)) == null) continue;
                byte by = ((PhexSecurityManager)object).controlHostAddressAccess(caughtHost.getHostAddress());
                switch (by) {
                    case 2: 
                    case 3: {
                        continue block5;
                    }
                }
                if (IPUtils.isPortInUserInvalidList(caughtHost.getHostAddress())) continue;
                this.addPersistentCaughtHost(caughtHost);
                if (s != 2 && this.caughtHosts.isFull(s)) {
                    s = (short)(s + 1);
                }
                this.addToCaughtHostFetcher(caughtHost, s);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            NLogger.warn(CaughtHostsContainer.class, (Object)iOException, (Throwable)iOException);
        }
    }

    private CaughtHost parseCaughtHostFromLine(String string) {
        long l;
        long l2;
        int n;
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = stringTokenizer.countTokens();
        if (n2 == 1) {
            string2 = string;
            n = -1;
            l2 = -1L;
            l = -1L;
        } else if (n2 == 4) {
            string2 = stringTokenizer.nextToken();
            try {
                l2 = Long.parseLong(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                l2 = -1L;
            }
            try {
                l = Long.parseLong(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                l = -1L;
            }
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        } else {
            NLogger.warn(CaughtHostsContainer.class, (Object)("Unknown HostCache line format: " + string));
            return null;
        }
        byte[] byArray = AddressUtils.parseIP(string2);
        if (byArray == null) {
            return null;
        }
        int n3 = AddressUtils.parsePort(string2);
        if (n3 == -1) {
            return null;
        }
        DefaultDestAddress defaultDestAddress = new DefaultDestAddress(byArray, n3);
        CaughtHost caughtHost = new CaughtHost(defaultDestAddress);
        if (n > 0) {
            caughtHost.setDailyUptime(n);
        }
        if (l2 > 0L) {
            caughtHost.setLastFailedConnection(l2);
        }
        if (l > 0L) {
            caughtHost.setLastSuccessfulConnection(l);
        }
        return caughtHost;
    }

    public void saveHostsContainer() {
        if (!this.hasChangedSinceLastSave) {
            return;
        }
        this.saveCaughtHosts();
        this.hasChangedSinceLastSave = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCaughtHosts() {
        NLogger.debug(CaughtHostsContainer.class, (Object)"Start saving caught hosts.");
        try {
            NetworkManager networkManager = NetworkManager.getInstance();
            File file = networkManager.getGnutellaNetwork().getHostsFile();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            CatchedHostCache catchedHostCache = this.catchedHostCache;
            synchronized (catchedHostCache) {
                Iterator iterator = this.catchedHostCache.iterator();
                while (iterator.hasNext()) {
                    CaughtHost caughtHost = (CaughtHost)iterator.next();
                    DestAddress destAddress = caughtHost.getHostAddress();
                    bufferedWriter.write(destAddress.getFullHostName() + "," + caughtHost.getLastFailedConnection() + "," + caughtHost.getLastSuccessfulConnection() + "," + caughtHost.getDailyUptime());
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            NLogger.error(CaughtHostsContainer.class, (Object)iOException, (Throwable)iOException);
        }
        NLogger.debug(CaughtHostsContainer.class, (Object)"Finish saving caught hosts.");
    }

    public void addCaughtHostsChangeListener(CaughtHostsChangeListener caughtHostsChangeListener) {
        this.listenerList.add(caughtHostsChangeListener);
    }

    public void removeCaughtHostsChangeListener(CaughtHostsChangeListener caughtHostsChangeListener) {
        this.listenerList.remove(caughtHostsChangeListener);
    }

    private void fireCaughtHostsChanged() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = CaughtHostsContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    CaughtHostsChangeListener caughtHostsChangeListener = (CaughtHostsChangeListener)objectArray[i];
                    caughtHostsChangeListener.caughtHostsChanged();
                }
            }
        });
    }

    private void fireAutoConnectHostAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = CaughtHostsContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    CaughtHostsChangeListener caughtHostsChangeListener = (CaughtHostsChangeListener)objectArray[i];
                    caughtHostsChangeListener.autoConnectHostAdded(n);
                }
            }
        });
    }

    private void fireAutoConnectHostRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = CaughtHostsContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    CaughtHostsChangeListener caughtHostsChangeListener = (CaughtHostsChangeListener)objectArray[i];
                    caughtHostsChangeListener.autoConnectHostRemoved(n);
                }
            }
        });
    }

    private class SlotHostComparator
    implements Comparator {
        private SlotHostComparator() {
        }

        public int compare(Object object, Object object2) {
            DestAddress destAddress;
            CaughtHost caughtHost = (CaughtHost)object;
            CaughtHost caughtHost2 = (CaughtHost)object2;
            DestAddress destAddress2 = caughtHost.getHostAddress();
            if (destAddress2.equals(destAddress = caughtHost2.getHostAddress())) {
                return 0;
            }
            if (caughtHost.getDailyUptime() > caughtHost2.getDailyUptime()) {
                return -1;
            }
            if (caughtHost.getDailyUptime() < caughtHost2.getDailyUptime()) {
                return 1;
            }
            return -1;
        }
    }

    private class SaveHostsContainerTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 60000L;

        private SaveHostsContainerTimer() {
        }

        public void run() {
            try {
                ThreadPool.getInstance().addJob(new SaveHostsContainerRunner(), "SaveHostsContainer");
            }
            catch (Throwable throwable) {
                NLogger.error(class$phex$host$CaughtHostsContainer == null ? (class$phex$host$CaughtHostsContainer = CaughtHostsContainer.class$("phex.host.CaughtHostsContainer")) : class$phex$host$CaughtHostsContainer, (Object)throwable, throwable);
            }
        }
    }

    private class SaveHostsContainerRunner
    implements Runnable {
        private SaveHostsContainerRunner() {
        }

        public void run() {
            CaughtHostsContainer.this.saveHostsContainer();
        }
    }
}

