/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.DataFormatException;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.msg.InvalidGGEPBlockException;
import phex.utils.HexConverter;
import phex.utils.IOUtil;
import phex.utils.NLogger;

public class GGEPBlock {
    public static final byte MAGIC_NUMBER = -61;
    public static final String BROWSE_HOST_HEADER_ID = "BH";
    public static final String ALTERNATE_LOCATIONS_HEADER_ID = "ALT";
    public static final String AVARAGE_DAILY_UPTIME = "DU";
    public static final String ULTRAPEER_ID = "UP";
    public static final String VENDOR_CODE_ID = "VC";
    public static final String PATH_INFO_HEADER_ID = "PATH";
    public static final String PUSH_PROXY_HEADER_ID = "PUSH";
    public static final String UDP_HOST_CACHE_UDPHC = "UDPHC";
    public static final String UDP_HOST_CACHE_IPP = "IPP";
    public static final String UDP_HOST_CACHE_SCP = "SCP";
    public static final String UDP_HOST_CACHE_PHC = "PHC";
    public static final String PHEX_EXTENDED_DESTINATION = "PHEX.EXDST";
    public static final String FEATURE_QUERY_HEADER_ID = "WH";
    public static final String CREATION_TIME_HEADER_ID = "CT";
    private HashMap headerToDataMap = new HashMap(3);
    private static byte[] browseHostGGEPBlock;
    static /* synthetic */ Class class$phex$msg$GGEPBlock;

    public void debugDump() {
        System.out.println("--------------------------------------");
        Iterator iterator = this.headerToDataMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            System.out.println(k + " = " + this.headerToDataMap.get(k));
        }
        System.out.println("--------------------------------------");
    }

    private void addExtension(String string) {
        this.addExtension(string, "".getBytes());
    }

    public void addExtension(String string, byte[] byArray) {
        this.headerToDataMap.put(string, byArray);
    }

    public void addExtension(String string, int n) {
        this.addExtension(string, IOUtil.serializeInt2MinLE(n));
    }

    public void addExtension(String string, long l) {
        this.addExtension(string, IOUtil.serializeLong2MinLE(l));
    }

    public void addExtension(String string, DestAddress[] destAddressArray, int n) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = Math.min(destAddressArray.length, n);
            for (int i = 0; i < n2; ++i) {
                IpAddress ipAddress = destAddressArray[i].getIpAddress();
                if (ipAddress == null) continue;
                byteArrayOutputStream.write(ipAddress.getHostIP());
                IOUtil.serializeShortLE((short)destAddressArray[i].getPort(), byteArrayOutputStream);
            }
            if (byteArrayOutputStream.size() > 0) {
                this.addExtension(string, byteArrayOutputStream.toByteArray());
            }
        }
        catch (IOException iOException) {
            NLogger.error("MESSAGE_ENCODE_DECODE", (Object)iOException, (Throwable)iOException);
        }
    }

    public void addAllExtensions(GGEPBlock gGEPBlock) {
        this.headerToDataMap.putAll(gGEPBlock.headerToDataMap);
    }

    public byte[] getExtensionData(String string) {
        return (byte[])this.headerToDataMap.get(string);
    }

    public long getLongExtensionData(String string, long l) {
        byte[] byArray = this.getExtensionData(string);
        if (byArray == null || byArray.length < 1 || byArray.length > 8) {
            return l;
        }
        return IOUtil.deserializeLongLE(byArray, 0, byArray.length);
    }

    private int checkIfCompressed(String string, int n) {
        if (string.equals(UDP_HOST_CACHE_PHC)) {
            n |= 0x20;
        }
        return n;
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(30);
        byteArrayOutputStream.write(-61);
        Iterator iterator = this.headerToDataMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            byte[] byArray = (byte[])this.headerToDataMap.get(string);
            int n = 0;
            n = this.checkIfCompressed(string, n);
            if (!iterator.hasNext()) {
                n |= 0x80;
            }
            byte[] byArray2 = string.getBytes();
            byteArrayOutputStream.write(n |= byArray2.length);
            byteArrayOutputStream.write(byArray2);
            int n2 = byArray.length;
            int n3 = n2 & 0x3F000;
            if (n3 != 0) {
                n3 >>= 12;
                n3 = 0x80 | n3;
                byteArrayOutputStream.write(n3);
            }
            if ((n3 = n2 & 0xFC0) != 0) {
                n3 >>= 6;
                n3 = 0x80 | n3;
                byteArrayOutputStream.write(n3);
            }
            n3 = n2 & 0x3F;
            n3 = 0x40 | n3;
            byteArrayOutputStream.write(n3);
            if (n2 <= 0) continue;
            byteArrayOutputStream.write(byArray);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public boolean isExtensionAvailable(String string) {
        return this.headerToDataMap.containsKey(string);
    }

    public static byte[] getQueryReplyGGEPBlock(boolean bl, DestAddress[] destAddressArray) {
        if (destAddressArray != null && destAddressArray.length > 0) {
            GGEPBlock gGEPBlock = new GGEPBlock();
            if (bl) {
                gGEPBlock.addExtension(BROWSE_HOST_HEADER_ID);
            }
            try {
                gGEPBlock.addExtension(PUSH_PROXY_HEADER_ID, destAddressArray, 4);
                byte[] byArray = gGEPBlock.getBytes();
                return byArray;
            }
            catch (IOException iOException) {
                NLogger.error("MESSAGE_ENCODE_DECODE", (Object)iOException, (Throwable)iOException);
                return IOUtil.EMPTY_BYTE_ARRAY;
            }
        }
        if (bl) {
            if (browseHostGGEPBlock == null) {
                GGEPBlock gGEPBlock = new GGEPBlock();
                gGEPBlock.addExtension(BROWSE_HOST_HEADER_ID);
                try {
                    browseHostGGEPBlock = gGEPBlock.getBytes();
                }
                catch (IOException iOException) {
                    NLogger.error("MESSAGE_ENCODE_DECODE", (Object)iOException, (Throwable)iOException);
                }
            }
            return browseHostGGEPBlock;
        }
        return IOUtil.EMPTY_BYTE_ARRAY;
    }

    public static byte[] getQueryReplyRecordGGEPBlock(long l, DestAddress[] destAddressArray) {
        if (l > 0L || destAddressArray != null && destAddressArray.length > 0) {
            GGEPBlock gGEPBlock = new GGEPBlock();
            if (l > 0L) {
                gGEPBlock.addExtension(CREATION_TIME_HEADER_ID, l / 1000L);
            }
            if (destAddressArray != null && destAddressArray.length > 0) {
                gGEPBlock.addExtension(ALTERNATE_LOCATIONS_HEADER_ID, destAddressArray, 10);
            }
            try {
                byte[] byArray = gGEPBlock.getBytes();
                return byArray;
            }
            catch (IOException iOException) {
                NLogger.error("MESSAGE_ENCODE_DECODE", (Object)iOException, (Throwable)iOException);
                return IOUtil.EMPTY_BYTE_ARRAY;
            }
        }
        return IOUtil.EMPTY_BYTE_ARRAY;
    }

    public static boolean isExtensionHeaderInBlocks(GGEPBlock[] gGEPBlockArray, String string) {
        for (int i = 0; i < gGEPBlockArray.length; ++i) {
            if (!gGEPBlockArray[i].isExtensionAvailable(string)) continue;
            return true;
        }
        return false;
    }

    public static byte[] getExtensionDataInBlocks(GGEPBlock[] gGEPBlockArray, String string) {
        for (int i = 0; i < gGEPBlockArray.length; ++i) {
            if (!gGEPBlockArray[i].isExtensionAvailable(string)) continue;
            return gGEPBlockArray[i].getExtensionData(string);
        }
        return null;
    }

    public static GGEPBlock mergeGGEPBlocks(GGEPBlock[] gGEPBlockArray) {
        GGEPBlock gGEPBlock = new GGEPBlock();
        for (int i = 0; i < gGEPBlockArray.length; ++i) {
            gGEPBlock.addAllExtensions(gGEPBlockArray[i]);
        }
        return gGEPBlock;
    }

    public static GGEPBlock[] parseGGEPBlocks(byte[] byArray, int n) throws InvalidGGEPBlockException {
        GGEPParser gGEPParser = new GGEPParser();
        return gGEPParser.parseGGEPBlocks(byArray, n);
    }

    public static GGEPBlock[] parseGGEPBlocks(PushbackInputStream pushbackInputStream) throws InvalidGGEPBlockException, IOException {
        GGEPParser gGEPParser = new GGEPParser();
        return gGEPParser.parseGGEPBlocks(pushbackInputStream);
    }

    public static void debugDumpBlocks(GGEPBlock[] gGEPBlockArray) {
        for (int i = 0; i < gGEPBlockArray.length; ++i) {
            gGEPBlockArray[i].debugDump();
        }
    }

    private static class GGEPParser {
        private int offset;
        private ArrayList ggepList = new ArrayList(3);

        public GGEPBlock[] parseGGEPBlocks(PushbackInputStream pushbackInputStream) throws InvalidGGEPBlockException, IOException {
            byte by;
            while ((by = (byte)pushbackInputStream.read()) != -1) {
                if (by != -61) {
                    pushbackInputStream.unread(by);
                    break;
                }
                this.ggepList.add(this.parseGGEPBlock(pushbackInputStream));
            }
            GGEPBlock[] gGEPBlockArray = new GGEPBlock[this.ggepList.size()];
            this.ggepList.toArray(gGEPBlockArray);
            return gGEPBlockArray;
        }

        private GGEPBlock parseGGEPBlock(InputStream inputStream) throws InvalidGGEPBlockException, IOException {
            GGEPBlock gGEPBlock = new GGEPBlock();
            boolean bl = false;
            while (!bl) {
                int n = inputStream.read();
                if ((n & 0x10) != 0) {
                    throw new InvalidGGEPBlockException();
                }
                bl = (n & 0x80) != 0;
                boolean bl2 = (n & 0x40) != 0;
                boolean bl3 = (n & 0x20) != 0;
                short s = (short)(n & 0xF);
                if (s == 0) {
                    throw new InvalidGGEPBlockException();
                }
                byte[] byArray = new byte[s];
                inputStream.read(byArray, 0, s);
                String string = new String(byArray, 0, (int)s);
                int n2 = this.parseDataLength(inputStream);
                byte[] byArray2 = null;
                try {
                    if (n2 > 0) {
                        byArray2 = new byte[n2];
                        inputStream.read(byArray2, 0, n2);
                        if (bl3) {
                            byArray2 = IOUtil.inflate(byArray2);
                        }
                        if (bl2) {
                            try {
                                byArray2 = IOUtil.cobsDecode(byArray2);
                            }
                            catch (IOException iOException) {
                                byArray2 = null;
                            }
                        }
                    } else {
                        byArray2 = new byte[]{};
                    }
                    if (byArray2 == null) continue;
                    gGEPBlock.addExtension(string, byArray2);
                }
                catch (DataFormatException dataFormatException) {
                    if (!NLogger.isWarnEnabled(class$phex$msg$GGEPBlock == null ? GGEPBlock.class$("phex.msg.GGEPBlock") : class$phex$msg$GGEPBlock)) continue;
                    NLogger.warn(class$phex$msg$GGEPBlock == null ? GGEPBlock.class$("phex.msg.GGEPBlock") : class$phex$msg$GGEPBlock, (Object)("Invalid GGEP data format. Header: '" + string + "' Data: '" + HexConverter.toHexString(byArray2) + "'."), (Throwable)dataFormatException);
                }
            }
            return gGEPBlock;
        }

        private int parseDataLength(InputStream inputStream) throws InvalidGGEPBlockException, IOException {
            byte by;
            int n = 0;
            int n2 = 0;
            do {
                if (++n2 > 3) {
                    throw new InvalidGGEPBlockException();
                }
                by = (byte)inputStream.read();
                n = n << 6 | by & 0x3F;
            } while (64 != (by & 0x40));
            return n;
        }

        public GGEPBlock[] parseGGEPBlocks(byte[] byArray, int n) throws InvalidGGEPBlockException {
            this.offset = n;
            while (byArray.length > this.offset && byArray[this.offset] == -61) {
                ++this.offset;
                this.ggepList.add(this.parseGGEPBlock(byArray));
            }
            GGEPBlock[] gGEPBlockArray = new GGEPBlock[this.ggepList.size()];
            this.ggepList.toArray(gGEPBlockArray);
            return gGEPBlockArray;
        }

        private GGEPBlock parseGGEPBlock(byte[] byArray) throws InvalidGGEPBlockException {
            GGEPBlock gGEPBlock = new GGEPBlock();
            boolean bl = false;
            while (!bl) {
                if (byArray.length > this.offset && (byArray[this.offset] & 0x10) != 0) {
                    throw new InvalidGGEPBlockException();
                }
                bl = (byArray[this.offset] & 0x80) != 0;
                boolean bl2 = (byArray[this.offset] & 0x40) != 0;
                boolean bl3 = (byArray[this.offset] & 0x20) != 0;
                short s = (short)(byArray[this.offset] & 0xF);
                if (s == 0) {
                    throw new InvalidGGEPBlockException();
                }
                ++this.offset;
                String string = new String(byArray, this.offset, (int)s);
                this.offset += s;
                int n = this.parseDataLength(byArray);
                byte[] byArray2 = null;
                try {
                    if (n > 0) {
                        byArray2 = new byte[n];
                        System.arraycopy(byArray, this.offset, byArray2, 0, n);
                        this.offset += n;
                        if (bl3) {
                            byArray2 = IOUtil.inflate(byArray2);
                        }
                        if (bl2) {
                            try {
                                byArray2 = IOUtil.cobsDecode(byArray2);
                            }
                            catch (IOException iOException) {
                                byArray2 = null;
                            }
                        }
                    } else {
                        byArray2 = new byte[]{};
                    }
                    if (byArray2 == null) continue;
                    gGEPBlock.addExtension(string, byArray2);
                }
                catch (DataFormatException dataFormatException) {
                    if (!NLogger.isWarnEnabled(class$phex$msg$GGEPBlock == null ? GGEPBlock.class$("phex.msg.GGEPBlock") : class$phex$msg$GGEPBlock)) continue;
                    NLogger.warn(class$phex$msg$GGEPBlock == null ? GGEPBlock.class$("phex.msg.GGEPBlock") : class$phex$msg$GGEPBlock, (Object)("Invalid GGEP data format. Header: '" + string + "' Data: '" + HexConverter.toHexString(byArray2) + "'."), (Throwable)dataFormatException);
                }
            }
            return gGEPBlock;
        }

        private int parseDataLength(byte[] byArray) throws InvalidGGEPBlockException {
            byte by;
            int n = 0;
            int n2 = 0;
            do {
                if (++n2 > 3) {
                    throw new InvalidGGEPBlockException();
                }
                by = byArray[this.offset];
                ++this.offset;
                n = n << 6 | by & 0x3F;
            } while (64 != (by & 0x40));
            return n;
        }
    }
}

