/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.util.HashSet;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.msg.GGEPBlock;
import phex.security.PhexSecurityManager;
import phex.utils.HexConverter;
import phex.utils.IOUtil;
import phex.utils.NLogger;

public class GGEPExtension {
    public static DestAddress[] parseAltExtensionData(GGEPBlock[] gGEPBlockArray) {
        byte[] byArray = GGEPBlock.getExtensionDataInBlocks(gGEPBlockArray, "ALT");
        if (byArray == null) {
            return null;
        }
        if (byArray.length % 6 != 0) {
            NLogger.warn("Network", (Object)("Invalid ALT GGEPBlock length: " + HexConverter.toHexString(byArray)));
            return null;
        }
        int n = byArray.length / 6;
        HashSet<DefaultDestAddress> hashSet = new HashSet<DefaultDestAddress>();
        PhexSecurityManager phexSecurityManager = PhexSecurityManager.getInstance();
        for (int i = 0; i < n; ++i) {
            int n2 = i * 6;
            byte[] byArray2 = new byte[]{byArray[n2], byArray[n2 + 1], byArray[n2 + 2], byArray[n2 + 3]};
            int n3 = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(byArray, n2 + 4));
            DefaultDestAddress defaultDestAddress = new DefaultDestAddress(byArray2, n3);
            if (!defaultDestAddress.isValidAddress() || phexSecurityManager.controlHostAddressAccess(defaultDestAddress) != 1) continue;
            hashSet.add(defaultDestAddress);
        }
        DestAddress[] destAddressArray = new DestAddress[hashSet.size()];
        hashSet.toArray(destAddressArray);
        return destAddressArray;
    }

    public static DestAddress[] parsePushProxyExtensionData(GGEPBlock[] gGEPBlockArray) {
        byte[] byArray = GGEPBlock.getExtensionDataInBlocks(gGEPBlockArray, "PUSH");
        if (byArray == null) {
            return null;
        }
        if (byArray.length % 6 != 0) {
            NLogger.warn("Network", (Object)("Invalid PushProxy GGEPBlock length: " + HexConverter.toHexString(byArray)));
            return null;
        }
        int n = byArray.length / 6;
        HashSet<DefaultDestAddress> hashSet = new HashSet<DefaultDestAddress>();
        PhexSecurityManager phexSecurityManager = PhexSecurityManager.getInstance();
        for (int i = 0; i < n; ++i) {
            int n2 = i * 6;
            byte[] byArray2 = new byte[]{byArray[n2], byArray[n2 + 1], byArray[n2 + 2], byArray[n2 + 3]};
            int n3 = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(byArray, n2 + 4));
            DefaultDestAddress defaultDestAddress = new DefaultDestAddress(byArray2, n3);
            if (!defaultDestAddress.isValidAddress() || phexSecurityManager.controlHostAddressAccess(defaultDestAddress) != 1) continue;
            hashSet.add(defaultDestAddress);
        }
        DestAddress[] destAddressArray = new DestAddress[hashSet.size()];
        hashSet.toArray(destAddressArray);
        return destAddressArray;
    }

    public static int parseIntExtensionData(GGEPBlock[] gGEPBlockArray, String string, int n) {
        byte[] byArray = GGEPBlock.getExtensionDataInBlocks(gGEPBlockArray, string);
        if (byArray == null) {
            return n;
        }
        if (byArray.length < 1) {
            return n;
        }
        if (byArray.length > 4) {
            return n;
        }
        return IOUtil.deserializeIntLE(byArray, 0, byArray.length);
    }
}

