/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import phex.utils.HexConverter;
import phex.utils.IOUtil;

public class GUID
implements Serializable {
    public static final int DATA_LENGTH = 16;
    public static final GUID EMPTY_GUID;
    public static final Random randomizer;
    private byte[] bytes;
    private String stringRepresentation = null;

    public GUID() {
        this.bytes = new byte[16];
        randomizer.nextBytes(this.bytes);
        this.bytes[8] = -1;
        this.bytes[15] = 0;
    }

    public GUID(String string) {
        this.fromHexString(string);
    }

    public GUID(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("Attempted to construct a GUID from an array of bytes not 16 long: " + byArray.length);
        }
        this.bytes = byArray;
        this.stringRepresentation = null;
    }

    public void setGuid(byte[] byArray) {
        System.arraycopy(byArray, 0, this.bytes, 0, 16);
        this.stringRepresentation = null;
    }

    public byte[] getGuid() {
        return this.bytes;
    }

    public boolean equals(Object object) {
        if (object instanceof GUID) {
            return Arrays.equals(this.bytes, ((GUID)object).bytes);
        }
        return false;
    }

    public void copy(byte[] byArray) {
        System.arraycopy(byArray, 0, this.bytes, 0, 16);
        this.stringRepresentation = null;
    }

    public int serialize(byte[] byArray, int n) {
        System.arraycopy(this.bytes, 0, byArray, n, 16);
        return n + 16;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.bytes);
    }

    public int deserialize(byte[] byArray, int n) {
        System.arraycopy(byArray, n, this.bytes, 0, 16);
        this.stringRepresentation = null;
        return n + 16;
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = this.generateString();
        }
        return this.stringRepresentation;
    }

    private String generateString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(HexConverter.toHexString(this.bytes, 0, 4));
        stringBuffer.append('-');
        stringBuffer.append(HexConverter.toHexString(this.bytes, 4, 2));
        stringBuffer.append('-');
        stringBuffer.append(HexConverter.toHexString(this.bytes, 6, 2));
        stringBuffer.append('-');
        stringBuffer.append(HexConverter.toHexString(this.bytes, 8, 2));
        stringBuffer.append('-');
        stringBuffer.append(HexConverter.toHexString(this.bytes, 10, 6));
        return stringBuffer.toString();
    }

    public String toHexString() {
        return HexConverter.toHexString(this.bytes);
    }

    public void fromHexString(String string) {
        this.bytes = HexConverter.toBytes(string);
        this.stringRepresentation = null;
    }

    public int hashCode() {
        int n = 0xFF & this.bytes[0] | 0xFF00 & this.bytes[1] << 8 | 0xFF0000 & this.bytes[2] << 16 | this.bytes[3] << 24;
        int n2 = 0xFF & this.bytes[4] | 0xFF00 & this.bytes[5] << 8 | 0xFF0000 & this.bytes[6] << 16 | this.bytes[7] << 24;
        int n3 = 0xFF & this.bytes[8] | 0xFF00 & this.bytes[9] << 8 | 0xFF0000 & this.bytes[10] << 16 | this.bytes[11] << 24;
        int n4 = 0xFF & this.bytes[12] | 0xFF00 & this.bytes[13] << 8 | 0xFF0000 & this.bytes[14] << 16 | this.bytes[15] << 24;
        return n ^ n2 ^ n3 ^ n4;
    }

    static {
        int n;
        EMPTY_GUID = new GUID(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        long l = System.currentTimeMillis();
        try {
            n = IOUtil.deserializeIntLE(InetAddress.getLocalHost().getAddress(), 0);
        }
        catch (Exception exception) {
            n = 0;
        }
        int n2 = IOUtil.determineBitCount(n);
        long l2 = l << n2;
        randomizer = new Random(l2 += (long)n);
    }

    public static class GUIDComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            GUID gUID = (GUID)object;
            GUID gUID2 = (GUID)object2;
            for (int i = 0; i < 16; ++i) {
                int n = gUID.bytes[i] - gUID2.bytes[i];
                if (n == 0) continue;
                return n;
            }
            return 0;
        }
    }
}

