/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import phex.common.URN;
import phex.msg.GGEPBlock;
import phex.msg.InvalidGGEPBlockException;
import phex.utils.NLogger;

public class HUGEBlock {
    private GGEPBlock[] ggepBlocks = null;
    private Set urns = null;
    private Set others = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HUGEBlock(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(64);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        PushbackInputStream pushbackInputStream = new PushbackInputStream(byteArrayInputStream);
        try {
            byte by;
            while ((by = (byte)pushbackInputStream.read()) != -1) {
                if (by == 0) {
                    return;
                }
                if (by == -61) {
                    pushbackInputStream.unread(by);
                    this.parseGGEPBlock(pushbackInputStream);
                    continue;
                }
                byteArrayOutputStream.reset();
                do {
                    byteArrayOutputStream.write(by);
                } while ((by = (byte)pushbackInputStream.read()) != -1 && by != 28);
                if (by != -1 && by != 28) continue;
                try {
                    String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
                    if (URN.isValidURN(string)) {
                        URN uRN = new URN(string);
                        if (this.urns == null) {
                            this.urns = new HashSet(3);
                        }
                        this.urns.add(uRN);
                        continue;
                    }
                    if (this.others == null) {
                        this.others = new HashSet(3);
                    }
                    this.others.add(string);
                }
                catch (IOException iOException) {}
            }
            return;
        }
        catch (IOException iOException) {
            NLogger.error(HUGEBlock.class, (Object)iOException, (Throwable)iOException);
        }
    }

    private void parseGGEPBlock(PushbackInputStream pushbackInputStream) {
        try {
            GGEPBlock[] gGEPBlockArray = GGEPBlock.parseGGEPBlocks(pushbackInputStream);
            this.ggepBlocks = gGEPBlockArray;
        }
        catch (InvalidGGEPBlockException invalidGGEPBlockException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public GGEPBlock[] getGGEPBlocks() {
        return this.ggepBlocks;
    }

    public Set getURNS() {
        if (this.urns == null) {
            return Collections.EMPTY_SET;
        }
        return this.urns;
    }

    public Set getOthers() {
        if (this.others == null) {
            return Collections.EMPTY_SET;
        }
        return this.others;
    }
}

