/*
 * Decompiled with CFR 0.152.
 */
package phex.msg.vendor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import phex.msg.InvalidMessageException;
import phex.msg.MsgHeader;
import phex.msg.vendor.VendorMsg;
import phex.utils.IOUtil;
import phex.utils.NLogger;

public class CapabilitiesVMsg
extends VendorMsg {
    private static final int VERSION = 0;
    private static final byte[] FEATURE_SEARCH_BYTES = new byte[]{87, 72, 65, 84};
    private static final int FEATURE_SEARCH_VERSION = 1;
    private static CapabilitiesVMsg myCapavilitiesVMsg;
    private final Set capabilitiesSet = new HashSet();

    public CapabilitiesVMsg(MsgHeader msgHeader, byte[] byArray, int n, int n2, byte[] byArray2) throws InvalidMessageException {
        super(msgHeader, byArray, n, n2, byArray2);
        if (n2 > 0) {
            throw new InvalidMessageException("Vendor Message 'MessagesSupported' with invalid version: " + n2);
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            int n3 = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(byteArrayInputStream));
            byte[] byArray3 = new byte[6];
            for (int i = 0; i < n3; ++i) {
                byteArrayInputStream.read(byArray3);
                SupportedCapability supportedCapability = new SupportedCapability(byArray3);
                this.capabilitiesSet.add(supportedCapability);
            }
        }
        catch (IOException iOException) {
            NLogger.error("MESSAGE_ENCODE_DECODE", (Object)iOException, (Throwable)iOException);
            throw new InvalidMessageException(iOException.getMessage());
        }
    }

    private CapabilitiesVMsg() {
        super(VENDORID_NULL, 10, 0, IOUtil.EMPTY_BYTE_ARRAY);
        this.createCapabilitiesMsgData();
    }

    public boolean isCapabilitySupported(byte[] byArray) {
        Iterator iterator = this.capabilitiesSet.iterator();
        while (iterator.hasNext()) {
            SupportedCapability supportedCapability = (SupportedCapability)iterator.next();
            if (!Arrays.equals(byArray, supportedCapability.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isFeatureSearchSupported() {
        return this.isCapabilitySupported(FEATURE_SEARCH_BYTES);
    }

    public static CapabilitiesVMsg getMyCapabilitiesVMsg() {
        if (myCapavilitiesVMsg == null) {
            myCapavilitiesVMsg = new CapabilitiesVMsg();
        }
        return myCapavilitiesVMsg;
    }

    private void createCapabilitiesMsgData() {
        SupportedCapability supportedCapability = null;
        supportedCapability = new SupportedCapability(FEATURE_SEARCH_BYTES, 1);
        this.capabilitiesSet.add(supportedCapability);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtil.serializeShortLE((short)this.capabilitiesSet.size(), byteArrayOutputStream);
            Iterator iterator = this.capabilitiesSet.iterator();
            while (iterator.hasNext()) {
                supportedCapability = (SupportedCapability)iterator.next();
                supportedCapability.serialize(byteArrayOutputStream);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.setVenderMsgData(byArray);
        }
        catch (IOException iOException) {
            NLogger.error("MESSAGE_ENCODE_DECODE", (Object)iOException, (Throwable)iOException);
        }
    }

    private static class SupportedCapability {
        private byte[] name;
        private int version;
        private int hashCode = -1;

        public SupportedCapability(byte[] byArray, int n) {
            this.name = byArray;
            this.version = n;
        }

        public SupportedCapability(byte[] byArray) throws InvalidMessageException {
            if (byArray.length < 6) {
                throw new InvalidMessageException("Invalid capability data.");
            }
            this.name = new byte[4];
            System.arraycopy(byArray, 0, this.name, 0, 4);
            this.version = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(byArray, 4));
        }

        public void serialize(OutputStream outputStream) throws IOException {
            outputStream.write(this.name);
            IOUtil.serializeShortLE((short)this.version, outputStream);
        }

        public byte[] getName() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (object instanceof SupportedCapability) {
                SupportedCapability supportedCapability = (SupportedCapability)object;
                return this.version == supportedCapability.version && Arrays.equals(this.name, supportedCapability.name);
            }
            return false;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                int n = 37 * this.version;
                for (int i = 0; i < this.name.length; ++i) {
                    n += 37 * this.name[i];
                }
                this.hashCode = n;
            }
            return this.hashCode;
        }

        public String toString() {
            return new String(this.name) + "/" + this.version;
        }
    }
}

