/*
 * Decompiled with CFR 0.152.
 */
package phex.msg.vendor;

import phex.common.address.AddressUtils;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.MsgHeader;
import phex.msg.vendor.VendorMsg;
import phex.utils.IOUtil;

public class PushProxyAcknowledgementVMsg
extends VendorMsg {
    private static final int VERSION = 2;
    private DestAddress hostAddress;

    public PushProxyAcknowledgementVMsg(DestAddress destAddress, GUID gUID) {
        super(VENDORID_LIME, 22, 2, PushProxyAcknowledgementVMsg.buildDataBody(destAddress));
        this.getHeader().setMsgID(gUID);
        this.hostAddress = destAddress;
    }

    public PushProxyAcknowledgementVMsg(MsgHeader msgHeader, byte[] byArray, int n, int n2, byte[] byArray2) throws InvalidMessageException {
        super(msgHeader, byArray, n, n2, byArray2);
        if (n2 < 2) {
            throw new InvalidMessageException("Vendor Message 'PushProxyAcknowledgement' with deprecated version: " + n2);
        }
        if (n2 > 2) {
            throw new InvalidMessageException("Vendor Message 'PushProxyAcknowledgement' with invalid version: " + n2);
        }
        if (byArray2.length != 6) {
            throw new InvalidMessageException("Vendor Message 'PushProxyAcknowledgement' invalid data length: " + byArray2.length);
        }
        byte[] byArray3 = new byte[]{byArray2[0], byArray2[1], byArray2[2], byArray2[3]};
        int n3 = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(byArray2, 4));
        if (!AddressUtils.isPortInRange(n3)) {
            throw new InvalidMessageException("Port out of range: " + n3);
        }
        this.hostAddress = new DefaultDestAddress(byArray3, n3);
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    private static byte[] buildDataBody(DestAddress destAddress) throws IllegalArgumentException {
        byte[] byArray = new byte[6];
        IpAddress ipAddress = destAddress.getIpAddress();
        if (ipAddress == null) {
            throw new IllegalArgumentException("Vendor Message 'PushProxyAcknowledgement' contains no IP.");
        }
        byte[] byArray2 = destAddress.getIpAddress().getHostIP();
        byArray[0] = byArray2[0];
        byArray[1] = byArray2[1];
        byArray[2] = byArray2[2];
        byArray[3] = byArray2[3];
        IOUtil.serializeShortLE((short)destAddress.getPort(), byArray, 4);
        return byArray;
    }
}

