/*
 * Decompiled with CFR 0.152.
 */
package phex.msg.vendor;

import java.io.IOException;
import java.util.Arrays;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.msg.vendor.CapabilitiesVMsg;
import phex.msg.vendor.HopsFlowVMsg;
import phex.msg.vendor.MessagesSupportedVMsg;
import phex.msg.vendor.PushProxyAcknowledgementVMsg;
import phex.msg.vendor.PushProxyRequestVMsg;
import phex.msg.vendor.TCPConnectBackVMsg;
import phex.msg.vendor.VendorMessageConstants;
import phex.utils.GnutellaOutputStream;
import phex.utils.HexConverter;
import phex.utils.IOUtil;

public abstract class VendorMsg
extends Message
implements VendorMessageConstants {
    private static final int VM_PREFIX_LENGTH = 8;
    private byte[] vendorId;
    private int subSelector;
    private int version;
    private byte[] data;

    public VendorMsg(MsgHeader msgHeader, byte[] byArray, int n, int n2, byte[] byArray2) {
        super(msgHeader);
        this.vendorId = byArray;
        this.subSelector = n;
        this.version = n2;
        this.data = byArray2;
    }

    public VendorMsg(byte[] byArray, int n, int n2, byte[] byArray2) {
        super(new MsgHeader(49, 1, 8 + byArray2.length));
        this.vendorId = byArray;
        this.subSelector = n;
        this.version = n2;
        this.data = byArray2;
    }

    public void writeMessage(GnutellaOutputStream gnutellaOutputStream) throws IOException {
        this.getHeader().writeHeader(gnutellaOutputStream);
        gnutellaOutputStream.write(this.vendorId);
        IOUtil.serializeShortLE((short)this.subSelector, gnutellaOutputStream);
        IOUtil.serializeShortLE((short)this.version, gnutellaOutputStream);
        gnutellaOutputStream.write(this.data);
    }

    public static VendorMsg parseMessage(MsgHeader msgHeader, byte[] byArray) throws InvalidMessageException {
        if (byArray.length < 8) {
            throw new InvalidMessageException("Vendor Message Wrong Format");
        }
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, 0, byArray2, 0, 4);
        int n = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(byArray, 4));
        int n2 = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(byArray, 6));
        byte[] byArray3 = new byte[byArray.length - 8];
        System.arraycopy(byArray, 8, byArray3, 0, byArray3.length);
        if (n == 0 && Arrays.equals(byArray2, VENDORID_NULL)) {
            return new MessagesSupportedVMsg(msgHeader, byArray2, n, n2, byArray3);
        }
        if (n == 7 && Arrays.equals(byArray2, VENDORID_BEAR)) {
            return new TCPConnectBackVMsg(msgHeader, byArray2, n, n2, byArray3);
        }
        if (n == 4 && Arrays.equals(byArray2, VENDORID_BEAR)) {
            return new HopsFlowVMsg(msgHeader, byArray2, n, n2, byArray3);
        }
        if (n == 21 && Arrays.equals(byArray2, VENDORID_LIME)) {
            return new PushProxyRequestVMsg(msgHeader, byArray2, n, n2, byArray3);
        }
        if (n == 22 && Arrays.equals(byArray2, VENDORID_LIME)) {
            return new PushProxyAcknowledgementVMsg(msgHeader, byArray2, n, n2, byArray3);
        }
        if (n == 10 && Arrays.equals(byArray2, VENDORID_NULL)) {
            return new CapabilitiesVMsg(msgHeader, byArray2, n, n2, byArray3);
        }
        if (n == 5 && Arrays.equals(byArray2, VENDORID_BEAR)) {
            throw new InvalidMessageException("Unsupported Vendor Message: " + new String(byArray2) + n + "v" + n2);
        }
        throw new InvalidMessageException("Unknown Vendor Message variant: " + new String(byArray2) + n + "v" + n2);
    }

    public void setVersion(int n) {
        this.version = n;
    }

    protected void setVenderMsgData(byte[] byArray) {
        this.data = byArray;
        this.getHeader().setDataLength(8 + byArray.length);
    }

    protected byte[] getVenderMsgData() {
        return this.data;
    }

    public String toString() {
        return "VendorMsg[ VendorId=" + new String(this.vendorId) + ", SubSelector=" + this.subSelector + ", Version=" + this.version + ", DataHEX=[" + HexConverter.toHexString(this.data) + "] ]";
    }
}

