/*
 * Decompiled with CFR 0.152.
 */
package phex.net;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.connection.IncomingConnectionDispatcher;
import phex.connection.NetworkManager;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.net.Server;
import phex.net.presentation.PresentationManager;
import phex.net.presentation.def.DefaultSocketFacade;
import phex.security.PhexSecurityException;
import phex.security.PhexSecurityManager;
import phex.utils.NLogger;

public class NIOServer
extends Server {
    private ServerSocketChannel listeningChannel;
    private Selector selector;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        Object object2;
        Object object3;
        if (NLogger.isDebugEnabled("SERVER")) {
            NLogger.debug("SERVER", (Object)("Listener started. Listening on: " + this.serverSocket.getInetAddress().getHostAddress() + ':' + this.serverSocket.getLocalPort()));
        }
        try {
            while (this.selector.isOpen()) {
                this.selector.select(10000L);
                if (this.selector.isOpen()) {
                    object3 = this.selector.selectedKeys().iterator();
                    while (object3.hasNext()) {
                        object2 = (SelectionKey)object3.next();
                        object3.remove();
                        if (!((SelectionKey)object2).isAcceptable()) continue;
                        object = (ServerSocketChannel)((SelectionKey)object2).channel();
                        try {
                            SocketChannel socketChannel = ((ServerSocketChannel)object).accept();
                            this.handleIncomingClientChannel(socketChannel);
                        }
                        catch (PhexSecurityException phexSecurityException) {
                            NLogger.debug("SERVER", (Object)phexSecurityException);
                        }
                        catch (IOException iOException) {
                            NLogger.debug("SERVER", (Object)iOException, (Throwable)iOException);
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            NLogger.error("SERVER", (Object)exception, (Throwable)exception);
        }
        this.isRunning = false;
        NLogger.debug("SERVER", (Object)"Listener stopped.");
        object3 = PresentationManager.getInstance();
        object2 = object3.createHostAddress(new IpAddress(IpAddress.LOCAL_HOST_IP), ServiceManager.sCfg.mListeningPort);
        NetworkManager.getInstance().updateLocalAddress((DestAddress)object2);
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    private void handleIncomingClientChannel(SocketChannel socketChannel) throws IOException, PhexSecurityException {
        socketChannel.configureBlocking(true);
        Socket socket = socketChannel.socket();
        socket.setSoTimeout(ServiceManager.sCfg.socketRWTimeout);
        IpAddress ipAddress = new IpAddress(socket.getInetAddress().getAddress());
        PresentationManager presentationManager = PresentationManager.getInstance();
        DestAddress destAddress = presentationManager.createHostAddress(ipAddress, socket.getPort());
        NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
        if (!networkHostsContainer.isConnectedToHost(destAddress) && !destAddress.getIpAddress().isSiteLocalIP()) {
            this.hasConnectedIncomming = true;
            this.lastInConnectionTime = System.currentTimeMillis();
        }
        byte by = PhexSecurityManager.getInstance().controlHostAddressAccess(destAddress);
        switch (by) {
            case 2: 
            case 3: {
                throw new PhexSecurityException("Host access denied: " + socket.getInetAddress().getHostAddress());
            }
        }
        NLogger.debug("SERVER", (Object)("Accepted incoming connection from: " + destAddress.getFullHostName()));
        DefaultSocketFacade defaultSocketFacade = new DefaultSocketFacade(socket);
        IncomingConnectionDispatcher incomingConnectionDispatcher = new IncomingConnectionDispatcher(defaultSocketFacade);
        ThreadPool.getInstance().addJob(incomingConnectionDispatcher, "IncomingConnectionDispatcher-" + Integer.toHexString(this.hashCode()));
    }

    protected synchronized void bind() throws IOException {
        boolean bl;
        if (!$assertionsDisabled && this.listeningChannel != null) {
            throw new AssertionError();
        }
        int n = ServiceManager.sCfg.mListeningPort;
        this.listeningChannel = ServerSocketChannel.open();
        this.serverSocket = this.listeningChannel.socket();
        this.listeningChannel.configureBlocking(false);
        int n2 = 0;
        do {
            bl = false;
            try {
                NLogger.debug("SERVER", (Object)("Binding to port " + n));
                this.serverSocket.bind(new InetSocketAddress(n));
            }
            catch (BindException bindException) {
                NLogger.debug("SERVER", (Object)("Binding failed to port " + n));
                if (n2 > 10) {
                    throw bindException;
                }
                bl = true;
                ++n;
                ++n2;
            }
        } while (bl);
        IpAddress ipAddress = this.resolveLocalHostIP();
        n = this.serverSocket.getLocalPort();
        DestAddress destAddress = PresentationManager.getInstance().createHostAddress(ipAddress, n);
        NetworkManager.getInstance().updateLocalAddress(destAddress);
        this.selector = Selector.open();
        this.listeningChannel.register(this.selector, 16);
    }

    protected void closeServer() {
        try {
            this.listeningChannel.close();
            SelectionKey selectionKey = this.listeningChannel.keyFor(this.selector);
            selectionKey.cancel();
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverSocket = null;
        this.listeningChannel = null;
    }

    static {
        $assertionsDisabled = !NIOServer.class.desiredAssertionStatus();
    }
}

