/*
 * Decompiled with CFR 0.152.
 */
package phex.net;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.connection.IncomingConnectionDispatcher;
import phex.connection.NetworkManager;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.net.Server;
import phex.net.presentation.PresentationManager;
import phex.net.presentation.SocketFacade;
import phex.net.presentation.def.DefaultSocketFacade;
import phex.security.PhexSecurityException;
import phex.security.PhexSecurityManager;
import phex.utils.NLogger;

public class OIOServer
extends Server {
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        Object object2;
        if (NLogger.isDebugEnabled("SERVER")) {
            NLogger.debug("SERVER", (Object)("Listener started. Listening on: " + this.serverSocket.getInetAddress().getHostAddress() + ':' + this.serverSocket.getLocalPort()));
        }
        try {
            while (this.serverSocket != null && !this.serverSocket.isClosed()) {
                try {
                    object2 = this.serverSocket.accept();
                    object = new DefaultSocketFacade((Socket)object2);
                    this.handleIncomingSocket((SocketFacade)object);
                }
                catch (SocketException socketException) {
                    NLogger.debug("SERVER", (Object)socketException);
                }
                catch (PhexSecurityException phexSecurityException) {
                    NLogger.debug("SERVER", (Object)phexSecurityException);
                }
                catch (IOException iOException) {
                    NLogger.error("SERVER", (Object)iOException, (Throwable)iOException);
                }
            }
        }
        catch (Exception exception) {
            NLogger.error("SERVER", (Object)exception, (Throwable)exception);
        }
        this.isRunning = false;
        NLogger.debug("SERVER", (Object)"Listener stopped.");
        object2 = PresentationManager.getInstance().createHostAddress(new IpAddress(IpAddress.LOCAL_HOST_IP), 6346);
        NetworkManager.getInstance().updateLocalAddress((DestAddress)object2);
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    private void handleIncomingSocket(SocketFacade socketFacade) throws IOException, PhexSecurityException {
        socketFacade.setSoTimeout(ServiceManager.sCfg.socketRWTimeout);
        DestAddress destAddress = socketFacade.getRemoteAddress();
        NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
        IpAddress ipAddress = destAddress.getIpAddress();
        if (!$assertionsDisabled && ipAddress == null) {
            throw new AssertionError();
        }
        if (!networkHostsContainer.isConnectedToHost(destAddress) && !ipAddress.isSiteLocalIP()) {
            this.hasConnectedIncomming = true;
            this.lastInConnectionTime = System.currentTimeMillis();
        }
        byte by = PhexSecurityManager.getInstance().controlHostAddressAccess(destAddress);
        switch (by) {
            case 2: 
            case 3: {
                throw new PhexSecurityException("Host access denied: " + destAddress);
            }
        }
        NLogger.debug("SERVER", (Object)("Accepted incoming connection from: " + destAddress.getFullHostName()));
        IncomingConnectionDispatcher incomingConnectionDispatcher = new IncomingConnectionDispatcher(socketFacade);
        ThreadPool.getInstance().addJob(incomingConnectionDispatcher, "IncomingConnectionDispatcher-" + Integer.toHexString(this.hashCode()));
    }

    protected synchronized void bind() throws IOException {
        boolean bl;
        if (!$assertionsDisabled && this.serverSocket != null) {
            throw new AssertionError();
        }
        int n = ServiceManager.sCfg.mListeningPort;
        this.serverSocket = new ServerSocket();
        int n2 = 0;
        do {
            bl = false;
            try {
                NLogger.debug("SERVER", (Object)("Binding to port " + n));
                this.serverSocket.bind(new InetSocketAddress(n));
            }
            catch (BindException bindException) {
                NLogger.debug("SERVER", (Object)("Binding failed to port " + n));
                if (n2 > 50) {
                    throw bindException;
                }
                bl = true;
                ++n;
                ++n2;
            }
        } while (bl);
        IpAddress ipAddress = this.resolveLocalHostIP();
        n = this.serverSocket.getLocalPort();
        DestAddress destAddress = PresentationManager.getInstance().createHostAddress(ipAddress, n);
        NetworkManager.getInstance().updateLocalAddress(destAddress);
    }

    protected synchronized void closeServer() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serverSocket = null;
        }
    }

    static {
        $assertionsDisabled = !OIOServer.class.desiredAssertionStatus();
    }
}

