/*
 * Decompiled with CFR 0.152.
 */
package phex.net.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import phex.common.ServiceManager;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.net.presentation.PresentationManager;
import phex.net.presentation.SocketFacade;
import phex.utils.IOUtil;

public final class OIOSocketFactory {
    private static final Object LOCK = new Object();
    private static int concurrentConnectAttempts = 0;

    private OIOSocketFactory() {
    }

    public static SocketFacade connect(DestAddress destAddress) throws IOException {
        return OIOSocketFactory.connect(destAddress, ServiceManager.sCfg.socketConnectTimeout, null);
    }

    public static SocketFacade connect(DestAddress destAddress, Runnable runnable) throws IOException {
        return OIOSocketFactory.connect(destAddress, ServiceManager.sCfg.socketConnectTimeout, runnable);
    }

    public static SocketFacade connect(DestAddress destAddress, int n) throws IOException {
        return OIOSocketFactory.connect(destAddress, n, null);
    }

    public static SocketFacade connect(DestAddress destAddress, int n, Runnable runnable) throws IOException {
        if (!destAddress.isValidAddress()) {
            throw new IOException("Invalid DestAddress: " + destAddress + " )");
        }
        if (ServiceManager.sCfg.mProxyUse) {
            return OIOSocketFactory.connectSock5(destAddress, runnable);
        }
        SocketFacade socketFacade = OIOSocketFactory.createSocket(destAddress, n, runnable);
        return socketFacade;
    }

    private static SocketFacade connectSock5(DestAddress destAddress, Runnable runnable) throws IOException {
        SocketFacade socketFacade = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            socketFacade = OIOSocketFactory.createSocket(new DefaultDestAddress(ServiceManager.sCfg.mProxyHost, ServiceManager.sCfg.mProxyPort), ServiceManager.sCfg.socketConnectTimeout, runnable);
            inputStream = socketFacade.getInputStream();
            outputStream = socketFacade.getOutputStream();
            byte[] byArray = ServiceManager.sCfg.mProxyUserName.length() > 0 ? new byte[]{5, 2, 0, 2} : new byte[]{5, 1, 0};
            outputStream.write(byArray, 0, byArray.length);
            int n = inputStream.read();
            if (n != 5) {
                throw new IOException("Invalid SOCKS server version: " + n);
            }
            byte by = (byte)inputStream.read();
            if (by == -1) {
                throw new IOException("SOCKS: No acceptable authentication.");
            }
            if (by != 0) {
                if (by == 2) {
                    OIOSocketFactory.authenticateUserPassword(inputStream, outputStream);
                } else {
                    throw new IOException("Unknown SOCKS5 authentication method required.");
                }
            }
            String string = destAddress.getHostName();
            int n2 = destAddress.getPort();
            byte[] byArray2 = new byte[10];
            byArray2[0] = 5;
            byArray2[1] = 1;
            byArray2[2] = 0;
            byArray2[3] = 1;
            IOUtil.serializeIP(string, byArray2, 4);
            byArray2[8] = (byte)(n2 >> 8);
            byArray2[9] = (byte)n2;
            outputStream.write(byArray2, 0, byArray2.length);
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            inputStream.read();
            int n5 = inputStream.read();
            if (n5 == 1) {
                inputStream.read();
                inputStream.read();
                inputStream.read();
                inputStream.read();
            } else if (n5 == 3) {
                int n6 = inputStream.read();
                if (n6 < 0) {
                    n6 += 256;
                }
                while (n6 > 0) {
                    inputStream.read();
                    --n6;
                }
            } else if (n5 == 4) {
                for (int i = 0; i < 16; ++i) {
                    inputStream.read();
                }
            } else {
                throw new IOException("Invalid return address type for SOCKS5: " + n5);
            }
            inputStream.read();
            inputStream.read();
            if (n3 != 5) {
                throw new IOException("Invalid SOCKS server version: " + n3);
            }
            switch (n4) {
                case 0: {
                    return socketFacade;
                }
                case 1: {
                    throw new IOException("SOCKS: General SOCKS server failure");
                }
                case 2: {
                    throw new IOException("SOCKS: Connection not allowed by ruleset");
                }
                case 3: {
                    throw new IOException("SOCKS: Network unreachable");
                }
                case 4: {
                    throw new IOException("SOCKS: Host unreachable");
                }
                case 5: {
                    throw new IOException("SOCKS: Connection refused");
                }
                case 6: {
                    throw new IOException("SOCKS: TTL expired");
                }
                case 7: {
                    throw new IOException("SOCKS: Command not supported");
                }
                case 8: {
                    throw new IOException("SOCKS: Address type not supported");
                }
            }
            throw new IOException("SOCKS: Unknown status response: " + n4);
        }
        catch (Exception exception) {
            IOUtil.closeQuietly(inputStream);
            IOUtil.closeQuietly(outputStream);
            IOUtil.closeQuietly(socketFacade);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException("Error: " + exception.getMessage());
        }
    }

    private static void authenticateUserPassword(InputStream inputStream, OutputStream outputStream) throws IOException {
        String string = ServiceManager.sCfg.mProxyUserName;
        String string2 = ServiceManager.sCfg.mProxyPassword;
        byte[] byArray = new byte[3 + string.length() + string2.length()];
        int n = 0;
        byArray[n++] = 1;
        byArray[n++] = (byte)string.length();
        n = IOUtil.serializeString(string, byArray, n);
        byArray[n++] = (byte)string2.length();
        n = IOUtil.serializeString(string2, byArray, n);
        outputStream.write(byArray, 0, n);
        if (inputStream.read() == 1 && inputStream.read() == 0) {
            return;
        }
        throw new IOException("Proxy server authentication failed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SocketFacade createSocket(DestAddress destAddress, int n, Runnable runnable) throws IOException, SocketException {
        Object object;
        Object object2;
        Object object3 = LOCK;
        synchronized (object3) {
            while (concurrentConnectAttempts >= ServiceManager.sCfg.maxConcurrentConnectAttempts) {
                try {
                    LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new SocketException(interruptedException.getMessage());
                }
            }
            ++concurrentConnectAttempts;
        }
        try {
            if (runnable != null) {
                runnable.run();
            }
            object3 = PresentationManager.getInstance().createSocket(destAddress, n);
            object3.setSoTimeout(ServiceManager.sCfg.socketRWTimeout);
            object2 = object3;
            Object var7_7 = null;
            object = LOCK;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Object object4 = LOCK;
            synchronized (object4) {
                --concurrentConnectAttempts;
                LOCK.notifyAll();
            }
            throw throwable;
        }
        synchronized (object) {
            --concurrentConnectAttempts;
            LOCK.notifyAll();
        }
        return object2;
    }
}

