/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.io.IOException;
import java.util.ArrayList;
import phex.common.ThreadPool;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.connection.BrowseHostConnection;
import phex.connection.BrowseHostException;
import phex.download.RemoteFile;
import phex.msg.GUID;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.query.QueryHitHost;
import phex.query.Search;
import phex.utils.NLogger;

public class BrowseHostResults
extends Search {
    public static final short INITIALIZING = 0;
    public static final short CONNECTING = 1;
    public static final short FETCHING = 2;
    public static final short FINISHED = 3;
    public static final short CONNECTION_ERROR = 4;
    public static final short BROWSE_HOST_ERROR = 5;
    private short browseHostStatus;
    private DestAddress destAddress;
    private GUID hostGUID;
    static /* synthetic */ Class class$phex$query$BrowseHostResults;

    public BrowseHostResults(DestAddress destAddress, GUID gUID) {
        this.destAddress = destAddress;
        this.hostGUID = gUID;
    }

    public DestAddress getDestAddress() {
        return this.destAddress;
    }

    public GUID getHostGUID() {
        return this.hostGUID;
    }

    public void startSearching() {
        this.isSearching = true;
        Runnable runnable = new Runnable(){

            public void run() {
                BrowseHostConnection browseHostConnection = new BrowseHostConnection(BrowseHostResults.this.destAddress, BrowseHostResults.this.hostGUID, BrowseHostResults.this);
                try {
                    browseHostConnection.sendBrowseHostRequest();
                    BrowseHostResults.this.browseHostStatus = (short)3;
                }
                catch (BrowseHostException browseHostException) {
                    NLogger.warn(class$phex$query$BrowseHostResults == null ? (class$phex$query$BrowseHostResults = BrowseHostResults.class$("phex.query.BrowseHostResults")) : class$phex$query$BrowseHostResults, (Object)browseHostException, (Throwable)browseHostException);
                    BrowseHostResults.this.browseHostStatus = (short)5;
                    BrowseHostResults.this.stopSearching();
                }
                catch (IOException iOException) {
                    NLogger.warn(class$phex$query$BrowseHostResults == null ? (class$phex$query$BrowseHostResults = BrowseHostResults.class$("phex.query.BrowseHostResults")) : class$phex$query$BrowseHostResults, (Object)iOException, (Throwable)iOException);
                    BrowseHostResults.this.browseHostStatus = (short)4;
                    BrowseHostResults.this.stopSearching();
                }
            }
        };
        ThreadPool.getInstance().addJob(runnable, "BrowseHostConnection-" + Integer.toHexString(runnable.hashCode()));
        this.fireSearchStarted();
    }

    public void setBrowseHostStatus(short s) {
        this.browseHostStatus = s;
    }

    public short getBrowseHostStatus() {
        return this.browseHostStatus;
    }

    public void stopSearching() {
        this.isSearching = false;
        this.fireSearchStoped();
    }

    public int getProgress() {
        switch (this.browseHostStatus) {
            case 0: {
                return 0;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 50;
            }
        }
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(QueryResponseMsg queryResponseMsg) {
        long l = queryResponseMsg.getRemoteHostSpeed();
        GUID gUID = queryResponseMsg.getRemoteClientID();
        DestAddress destAddress = queryResponseMsg.getDestAddress();
        QueryHitHost queryHitHost = new QueryHitHost(gUID, destAddress, l);
        queryHitHost.setQHDFlags(queryResponseMsg.getPushNeededFlag(), queryResponseMsg.getServerBusyFlag(), queryResponseMsg.getHasUploadedFlag(), queryResponseMsg.getUploadSpeedFlag());
        queryHitHost.setQueryResponseFields(queryResponseMsg);
        int n = queryResponseMsg.getRecordCount();
        ArrayList<RemoteFile> arrayList = new ArrayList<RemoteFile>(n);
        for (int i = 0; i < n; ++i) {
            QueryResponseRecord queryResponseRecord = queryResponseMsg.getMsgRecord(i);
            BrowseHostResults browseHostResults = this;
            synchronized (browseHostResults) {
                long l2 = queryResponseRecord.getFileSize();
                String string = queryResponseRecord.getFilename();
                URN uRN = queryResponseRecord.getURN();
                int n2 = queryResponseRecord.getFileIndex();
                String string2 = queryResponseRecord.getMetaData();
                String string3 = queryResponseRecord.getPathInfo();
                RemoteFile remoteFile = new RemoteFile(queryHitHost, n2, string, string3, l2, uRN, string2, 100);
                this.searchResultHolder.addQueryHit(remoteFile);
                arrayList.add(remoteFile);
                continue;
            }
        }
        if (arrayList.size() > 0) {
            if (this.queryEngine != null) {
                this.queryEngine.incrementResultCount(arrayList.size());
            }
            RemoteFile[] remoteFileArray = new RemoteFile[arrayList.size()];
            arrayList.toArray(remoteFileArray);
            this.fireSearchHitsAdded(remoteFileArray);
        }
    }

    public String toString() {
        return "[BrowseHostResults:" + this.destAddress + "," + "@" + Integer.toHexString(this.hashCode()) + "]";
    }
}

