/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import phex.common.address.DestAddress;
import phex.connection.NetworkManager;
import phex.msg.GUID;
import phex.msg.QueryResponseMsg;
import phex.query.QueryConstants;
import phex.utils.VendorCodes;

public class QueryHitHost
implements QueryConstants {
    private GUID hostGUID;
    private Long hostSpeedObj;
    private short pushNeededFlag;
    private short serverBusyFlag;
    private short hasUploadedFlag;
    private short uploadSpeedFlag;
    private String vendor;
    private boolean isChatSupported;
    private boolean isThexSupported;
    private boolean isBrowseHostSupported;
    private Short hostRating;
    private DestAddress hostAddress;
    private DestAddress[] pushProxyAddresses;

    public QueryHitHost(GUID gUID, DestAddress destAddress, long l) {
        this.hostGUID = gUID;
        this.hostAddress = destAddress;
        this.hostSpeedObj = new Long(l);
        this.setQHDFlags((short)-1, (short)-1, (short)-1, (short)-1);
        this.hostRating = new Short(-1);
    }

    public void setQueryResponseFields(QueryResponseMsg queryResponseMsg) {
        this.setVendorCode(queryResponseMsg.getVendorCode());
        this.setChatSupported(queryResponseMsg.isChatSupported());
        this.setBrowseHostSupported(queryResponseMsg.isBrowseHostSupported());
        this.setPushProxyAddresses(queryResponseMsg.getPushProxyAddresses());
    }

    public DestAddress[] getPushProxyAddresses() {
        return this.pushProxyAddresses;
    }

    public void setPushProxyAddresses(DestAddress[] destAddressArray) {
        this.pushProxyAddresses = destAddressArray;
    }

    public void setVendorCode(String string) {
        if (string != null) {
            this.vendor = VendorCodes.getVendorName(string);
        }
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setChatSupported(boolean bl) {
        this.isChatSupported = bl;
    }

    public boolean isChatSupported() {
        return this.isChatSupported;
    }

    public void setThexSupported(boolean bl) {
        this.isThexSupported = bl;
    }

    public boolean isThexSupported() {
        return this.isThexSupported;
    }

    public void setBrowseHostSupported(boolean bl) {
        this.isBrowseHostSupported = bl;
    }

    public boolean isBrowseHostSupported() {
        return this.isBrowseHostSupported;
    }

    public GUID getHostGUID() {
        return this.hostGUID;
    }

    public void setHostGUID(GUID gUID) {
        this.hostGUID = gUID;
    }

    public int getHostSpeed() {
        return this.hostSpeedObj.intValue();
    }

    public void setHostSpeed(long l) {
        this.hostSpeedObj = new Long(l);
        this.calculateHostRating();
    }

    public Long getHostSpeedObject() {
        return this.hostSpeedObj;
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public void setQHDFlags(short s, short s2, short s3, short s4) {
        this.pushNeededFlag = s;
        this.serverBusyFlag = s2;
        this.hasUploadedFlag = s3;
        this.uploadSpeedFlag = s4;
    }

    public boolean isPushNeeded() {
        return this.pushNeededFlag == 1;
    }

    public short getHostRating() {
        if (this.hostRating == -1) {
            this.calculateHostRating();
        }
        return this.hostRating;
    }

    public Short getHostRatingObject() {
        if (this.hostRating == -1) {
            this.calculateHostRating();
        }
        return this.hostRating;
    }

    private void calculateHostRating() {
        NetworkManager networkManager = NetworkManager.getInstance();
        if (this.pushNeededFlag == 1 && !networkManager.hasConnectedIncoming()) {
            this.hostRating = new Short(0);
            return;
        }
        if (this.serverBusyFlag == 1) {
            this.hostRating = new Short(1);
            return;
        }
        short s = this.pushNeededFlag == 1 ? (this.serverBusyFlag == 0 ? (short)3 : 2) : (this.pushNeededFlag == 0 ? (this.serverBusyFlag == 0 ? (short)6 : 5) : (!networkManager.hasConnectedIncoming() ? (short)3 : 4));
        if (this.hasUploadedFlag == 1) {
            s = (short)(s + 2);
        } else if (this.hasUploadedFlag == -1) {
            s = (short)(s + 1);
        }
        this.hostRating = new Short(s);
    }
}

