/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.event.AsynchronousDispatcher;
import phex.event.SearchDataEvent;
import phex.event.SearchDataListener;
import phex.msg.GUID;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.query.KeywordSearch;
import phex.query.QueryHitHost;
import phex.query.SearchFilter;

public class QueryResultMonitor {
    private ArrayList queryHitList = new ArrayList();
    private SearchFilter searchFilter;
    private ArrayList listenerList = new ArrayList(2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePassiveSearchFilter(SearchFilter searchFilter) {
        ArrayList arrayList = this.queryHitList;
        synchronized (arrayList) {
            this.searchFilter = searchFilter;
            if (this.searchFilter != null) {
                this.searchFilter.setLastTimeUsed(System.currentTimeMillis());
            }
        }
    }

    public SearchFilter getPassiveSearchFilter() {
        return this.searchFilter;
    }

    public void processResponse(QueryResponseMsg queryResponseMsg) {
        SwarmingManager swarmingManager = SwarmingManager.getInstance();
        long l = queryResponseMsg.getRemoteHostSpeed();
        GUID gUID = queryResponseMsg.getRemoteClientID();
        DestAddress destAddress = queryResponseMsg.getDestAddress();
        QueryHitHost queryHitHost = new QueryHitHost(gUID, destAddress, l);
        queryHitHost.setQHDFlags(queryResponseMsg.getPushNeededFlag(), queryResponseMsg.getServerBusyFlag(), queryResponseMsg.getHasUploadedFlag(), queryResponseMsg.getUploadSpeedFlag());
        queryHitHost.setQueryResponseFields(queryResponseMsg);
        ArrayList arrayList = new ArrayList();
        int n = queryResponseMsg.getRecordCount();
        for (int i = 0; i < n; ++i) {
            QueryResponseRecord queryResponseRecord = queryResponseMsg.getMsgRecord(i);
            if (ServiceManager.sCfg.enableHitSnooping) {
                this.snoopDownloadCandidates(swarmingManager, queryHitHost, queryResponseRecord);
            }
            if (this.searchFilter == null) continue;
            this.monitorPassiveSearch(queryHitHost, queryResponseRecord, arrayList);
        }
        if (arrayList.size() > 0) {
            RemoteFile[] remoteFileArray = new RemoteFile[arrayList.size()];
            arrayList.toArray(remoteFileArray);
            this.fireSearchHitsAdded(remoteFileArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorPassiveSearch(QueryHitHost queryHitHost, QueryResponseRecord queryResponseRecord, ArrayList arrayList) {
        ArrayList arrayList2 = this.queryHitList;
        synchronized (arrayList2) {
            DestAddress[] destAddressArray;
            int n = queryHitHost.getHostSpeed();
            short s = queryHitHost.getHostRating();
            long l = queryResponseRecord.getFileSize();
            String string = queryResponseRecord.getFilename();
            boolean bl = this.searchFilter.isFiltered(l, string, n, s);
            if (bl) {
                return;
            }
            URN uRN = queryResponseRecord.getURN();
            int n2 = queryResponseRecord.getFileIndex();
            String string2 = queryResponseRecord.getMetaData();
            RemoteFile remoteFile = this.findQueryHit(queryHitHost, uRN, string, l, n2);
            short s2 = KeywordSearch.calculateSearchScore(this.searchFilter.getFilterString(), string);
            if (remoteFile != null) {
                remoteFile.updateQueryHitHost(queryHitHost);
                remoteFile.setMetaData(string2);
            } else {
                destAddressArray = queryResponseRecord.getPathInfo();
                RemoteFile remoteFile2 = new RemoteFile(queryHitHost, n2, string, (String)destAddressArray, l, uRN, string2, s2);
                this.queryHitList.add(remoteFile2);
                arrayList.add(remoteFile2);
            }
            destAddressArray = queryResponseRecord.getAlternateLocations();
            if (uRN != null && destAddressArray != null) {
                for (int i = 0; i < destAddressArray.length; ++i) {
                    QueryHitHost queryHitHost2 = new QueryHitHost(null, destAddressArray[i], -1L);
                    remoteFile = this.findQueryHit(queryHitHost, uRN, string, l, n2);
                    if (remoteFile != null) {
                        remoteFile.updateQueryHitHost(queryHitHost);
                        remoteFile.setMetaData(string2);
                        continue;
                    }
                    RemoteFile remoteFile3 = new RemoteFile(queryHitHost2, -1, string, "", l, uRN, string2, s2);
                    this.queryHitList.add(remoteFile3);
                    arrayList.add(remoteFile3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteFile findQueryHit(QueryHitHost queryHitHost, URN uRN, String string, long l, int n) {
        GUID gUID = queryHitHost.getHostGUID();
        DestAddress destAddress = queryHitHost.getHostAddress();
        ArrayList arrayList = this.queryHitList;
        synchronized (arrayList) {
            int n2 = this.queryHitList.size();
            for (int i = 0; i < n2; ++i) {
                DestAddress destAddress2;
                RemoteFile remoteFile = (RemoteFile)this.queryHitList.get(i);
                GUID gUID2 = remoteFile.getQueryHitHost().getHostGUID();
                if (gUID2 == null || gUID == null ? !(destAddress2 = remoteFile.getQueryHitHost().getHostAddress()).equals(destAddress) : !gUID2.equals(gUID)) continue;
                if (uRN != null && remoteFile.getURN() != null) {
                    if (!uRN.equals(remoteFile.getURN())) continue;
                    return remoteFile;
                }
                if (n != remoteFile.getFileIndex() || l != remoteFile.getFileSize() || !string.equals(remoteFile.getFilename())) continue;
                return remoteFile;
            }
        }
        return null;
    }

    private QueryHitHost snoopDownloadCandidates(SwarmingManager swarmingManager, QueryHitHost queryHitHost, QueryResponseRecord queryResponseRecord) {
        SWDownloadFile sWDownloadFile = swarmingManager.getDownloadFile(queryResponseRecord.getFileSize(), queryResponseRecord.getURN());
        if (sWDownloadFile != null) {
            RemoteFile remoteFile = new RemoteFile(queryHitHost, queryResponseRecord.getFileIndex(), queryResponseRecord.getFilename(), queryResponseRecord.getPathInfo(), queryResponseRecord.getFileSize(), queryResponseRecord.getURN(), queryResponseRecord.getMetaData(), -1);
            sWDownloadFile.addDownloadCandidate(remoteFile);
        }
        return queryHitHost;
    }

    public void addSearchDataListener(SearchDataListener searchDataListener) {
        this.listenerList.add(searchDataListener);
    }

    public void removeSearchDataListener(SearchDataListener searchDataListener) {
        this.listenerList.remove(searchDataListener);
    }

    protected void fireSearchHitsAdded(RemoteFile[] remoteFileArray) {
        SearchDataEvent searchDataEvent = new SearchDataEvent(this, 1, remoteFileArray);
        this.fireSearchDataEvent(searchDataEvent);
    }

    private void fireSearchDataEvent(final SearchDataEvent searchDataEvent) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = QueryResultMonitor.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    if (!(objectArray[i] instanceof SearchDataListener)) continue;
                    SearchDataListener searchDataListener = (SearchDataListener)objectArray[i];
                    searchDataListener.searchDataChanged(searchDataEvent);
                }
            }
        });
    }
}

