/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.host.HostManager;
import phex.query.ResearchServiceConfig;
import phex.query.ResearchSetting;

public class ResearchService {
    private ResearchServiceConfig researchConfig;

    public ResearchService(ResearchServiceConfig researchServiceConfig) {
        this.researchConfig = researchServiceConfig;
    }

    public void startResearchSequence() {
        if (!this.researchConfig.isResearchEnabled()) {
            return;
        }
        SwarmingManager swarmingManager = SwarmingManager.getInstance();
        for (int i = swarmingManager.getDownloadFileCount(); i >= 0; --i) {
            SWDownloadFile sWDownloadFile = swarmingManager.getDownloadFile(i);
            if (sWDownloadFile == null) continue;
            this.performResearchOnDownload(sWDownloadFile);
        }
    }

    private void performResearchOnDownload(SWDownloadFile sWDownloadFile) {
        if (sWDownloadFile.isDownloadInProgress() || sWDownloadFile.isFileCompletedOrMoved() || sWDownloadFile.isDownloadStopped()) {
            return;
        }
        this.performResearchOnSetting(sWDownloadFile.getResearchSetting(), sWDownloadFile);
    }

    private void performResearchOnSetting(ResearchSetting researchSetting, SWDownloadFile sWDownloadFile) {
        HostManager hostManager = HostManager.getInstance();
        if (hostManager.getNetworkHostsContainer().getTotalConnectionCount() == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        if (this.isSearchRunning(researchSetting, l)) {
            return;
        }
        if (!this.isTimeForResearch(sWDownloadFile, researchSetting, l)) {
            return;
        }
        researchSetting.startSearch(this.researchConfig.getResearchTimeout());
    }

    private boolean isTimeForResearch(SWDownloadFile sWDownloadFile, ResearchSetting researchSetting, long l) {
        long l2 = researchSetting.getLastResearchStartTime();
        int n = researchSetting.getNoNewResultsCount();
        long l3 = this.researchConfig.getResearchIntervalMillis();
        int n2 = sWDownloadFile.getCandidatesCount();
        int n3 = this.researchConfig.getCandidatesIntervalThreshold();
        int n4 = researchSetting.getTotalResearchCount();
        long l4 = this.researchConfig.getResearchTimePenalty();
        long l5 = l3 + l3 * (long)n + l4 * (long)Math.max(0, n2 - n3) + l4 * (long)n4;
        long l6 = l2 + (l5 = Math.min(l5, this.researchConfig.getMaxResearchIntervalMillis()));
        return l > l6;
    }

    private boolean isSearchRunning(ResearchSetting researchSetting, long l) {
        return researchSetting.isSearchRunning();
    }
}

