/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import phex.common.Cfg;
import phex.common.URN;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.event.AsynchronousDispatcher;
import phex.event.SearchDataEvent;
import phex.event.SearchDataListener;
import phex.query.BackgroundSearchContainer;
import phex.query.QueryManager;
import phex.query.RuleFilteredSearch;
import phex.query.Search;
import phex.rules.Rule;
import phex.rules.condition.FileSizeCondition;
import phex.rules.condition.NotCondition;
import phex.rules.consequence.RemoveFromSearchConsequence;

public class ResearchSetting {
    private long lastResearchStartTime;
    private int noNewResultsCount;
    private int totalResearchCount;
    private String searchTerm;
    private RuleFilteredSearch ruledSearch;
    private boolean hasNewSearchResults;
    private SWDownloadFile downloadFile;
    private ResearchChangeListener researchChangeListener;

    public ResearchSetting(SWDownloadFile sWDownloadFile) {
        this.downloadFile = sWDownloadFile;
        this.researchChangeListener = new ResearchChangeListener();
    }

    public long getLastResearchStartTime() {
        return this.lastResearchStartTime;
    }

    public void setLastResearchStartTime(long l) {
        this.lastResearchStartTime = l;
    }

    public int getNoNewResultsCount() {
        return this.noNewResultsCount;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(String string) {
        this.searchTerm = string;
    }

    public String getSHA1() {
        URN uRN = this.downloadFile.getFileURN();
        if (uRN == null || !uRN.isSha1Nid()) {
            return "";
        }
        return uRN.getNamespaceSpecificString();
    }

    public void startSearch(long l) {
        long l2;
        if (this.ruledSearch != null && this.ruledSearch.isSearching()) {
            return;
        }
        if (this.searchTerm.length() < Cfg.MIN_SEARCH_TERM_LENGTH && this.downloadFile.getFileURN() == null) {
            return;
        }
        this.hasNewSearchResults = false;
        BackgroundSearchContainer backgroundSearchContainer = QueryManager.getInstance().getBackgroundSearchContainer();
        URN uRN = null;
        if (this.searchTerm.length() < Cfg.MIN_SEARCH_TERM_LENGTH && this.downloadFile.getFileURN() != null) {
            uRN = this.downloadFile.getFileURN();
        }
        Search search = backgroundSearchContainer.createSearch(this.searchTerm, uRN, l);
        Rule rule = new Rule();
        rule.addConsequence(RemoveFromSearchConsequence.INSTANCE);
        rule.addCondition(new NotCondition(new FileSizeCondition(this.downloadFile.getTotalDataSize(), this.downloadFile.getTotalDataSize())));
        this.ruledSearch = new RuleFilteredSearch(search, rule);
        this.ruledSearch.addSearchDataListener(this.researchChangeListener);
        ++this.totalResearchCount;
        this.lastResearchStartTime = l2 = System.currentTimeMillis();
    }

    public int getTotalResearchCount() {
        return this.totalResearchCount;
    }

    public void stopSearch() {
        if (this.ruledSearch == null || !this.ruledSearch.isSearching()) {
            return;
        }
        this.ruledSearch.stopSearching();
    }

    public int getSearchHitCount() {
        return this.ruledSearch.getResultCount();
    }

    public int getSearchProgress() {
        return this.ruledSearch.getProgress();
    }

    public boolean isSearchRunning() {
        if (this.ruledSearch == null) {
            return false;
        }
        return this.ruledSearch.isSearching();
    }

    static /* synthetic */ boolean access$002(ResearchSetting researchSetting, boolean bl) {
        researchSetting.hasNewSearchResults = bl;
        return researchSetting.hasNewSearchResults;
    }

    public class ResearchChangeListener
    implements SearchDataListener {
        public void searchDataChanged(SearchDataEvent searchDataEvent) {
            if (searchDataEvent.getType() == 4) {
                if (!ResearchSetting.this.hasNewSearchResults) {
                    ResearchSetting.this.noNewResultsCount++;
                } else {
                    ResearchSetting.this.noNewResultsCount = 0;
                }
            }
            if (searchDataEvent.getType() != 1) {
                SwarmingManager.getInstance().fireDownloadFileChanged(ResearchSetting.this.downloadFile);
                return;
            }
            if (searchDataEvent.getType() == 1) {
                AsynchronousDispatcher.invokeLater(new Runnable(this, searchDataEvent){
                    private final /* synthetic */ SearchDataEvent val$event;
                    private final /* synthetic */ ResearchChangeListener this$1;
                    {
                        this.this$1 = researchChangeListener;
                        this.val$event = searchDataEvent;
                    }

                    public void run() {
                        RemoteFile[] remoteFileArray = this.val$event.getSearchData();
                        for (int i = 0; i < remoteFileArray.length; ++i) {
                            boolean bl = ResearchSetting.access$200(ResearchChangeListener.access$300(this.this$1)).addDownloadCandidate(remoteFileArray[i]);
                            if (!bl) continue;
                            ResearchSetting.access$002(ResearchChangeListener.access$300(this.this$1), true);
                        }
                        SwarmingManager.getInstance().fireDownloadFileChanged(ResearchSetting.access$200(ResearchChangeListener.access$300(this.this$1)));
                    }
                });
            }
        }

        static /* synthetic */ ResearchSetting access$300(ResearchChangeListener researchChangeListener) {
            return researchChangeListener.ResearchSetting.this;
        }
    }
}

