/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import phex.common.IntObj;
import phex.download.RemoteFile;
import phex.event.AsynchronousDispatcher;
import phex.event.SearchDataEvent;
import phex.event.SearchDataListener;
import phex.msg.QueryMsg;
import phex.msg.QueryResponseMsg;
import phex.query.DynamicQueryEngine;
import phex.query.QueryManager;
import phex.query.SearchResultHolder;
import phex.utils.Logger;
import phex.utils.NLogger;

public abstract class Search {
    public static final long DEFAULT_SEARCH_TIMEOUT = 300000L;
    protected long startTime;
    protected DynamicQueryEngine queryEngine;
    protected QueryMsg queryMsg;
    private IntObj progressObj;
    protected boolean isSearching = false;
    protected SearchResultHolder searchResultHolder;
    private ArrayList listenerList = new ArrayList(2);
    static /* synthetic */ Class class$phex$query$Search;

    protected Search() {
        this.progressObj = new IntObj();
        this.searchResultHolder = new SearchResultHolder();
    }

    public int getQueryHitCount() {
        return this.searchResultHolder.getQueryHitCount();
    }

    public int getProgress() {
        if (!this.isSearching) {
            return 100;
        }
        if (this.queryEngine != null) {
            return this.queryEngine.getProgress();
        }
        long l = System.currentTimeMillis();
        int n = (int)(100.0 - (double)(this.startTime + 300000L - l) / 300000.0 * 100.0);
        return Math.min(n, 100);
    }

    public IntObj getProgressObj() {
        int n = this.getProgress();
        if (this.progressObj.value != n) {
            this.progressObj.value = n;
        }
        return this.progressObj;
    }

    public boolean isSearching() {
        return this.isSearching;
    }

    public void checkForSearchTimeout(long l) {
        if (this.queryEngine != null) {
            if (this.queryEngine.isQueryFinished()) {
                this.stopSearching();
            }
        } else if (l > this.startTime + 300000L) {
            this.stopSearching();
        }
    }

    public void startSearching() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Search.this.startTime = System.currentTimeMillis();
                Search.this.queryMsg.setCreationTime(Search.this.startTime);
                Logger.logMessage(Logger.FINER, (short)8, "Sending Query " + Search.this.queryMsg);
                Search.this.queryEngine = QueryManager.getInstance().sendMyQuery(Search.this.queryMsg);
                Search.this.isSearching = true;
                Search.this.fireSearchStarted();
            }
        });
    }

    public void stopSearching() {
        if (!this.isSearching) {
            return;
        }
        this.isSearching = false;
        if (this.queryEngine != null) {
            this.queryEngine.stopQuery();
        }
        this.fireSearchStoped();
    }

    public abstract void processResponse(QueryResponseMsg var1);

    public void addSearchChangeListener(SearchDataListener searchDataListener) {
        this.listenerList.add(searchDataListener);
    }

    public void removeSearchChangeListener(SearchDataListener searchDataListener) {
        this.listenerList.remove(searchDataListener);
    }

    protected void fireSearchStarted() {
        SearchDataEvent searchDataEvent = new SearchDataEvent(this, 0);
        this.fireSearchChangeEvent(searchDataEvent);
    }

    protected void fireSearchStoped() {
        SearchDataEvent searchDataEvent = new SearchDataEvent(this, 4);
        this.fireSearchChangeEvent(searchDataEvent);
    }

    public void fireSearchChanged() {
        SearchDataEvent searchDataEvent = new SearchDataEvent(this, 3);
        this.fireSearchChangeEvent(searchDataEvent);
    }

    protected void fireSearchHitsAdded(RemoteFile[] remoteFileArray) {
        SearchDataEvent searchDataEvent = new SearchDataEvent(this, 1, remoteFileArray);
        this.fireSearchChangeEvent(searchDataEvent);
    }

    private void fireSearchChangeEvent(final SearchDataEvent searchDataEvent) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                try {
                    Object[] objectArray = Search.this.listenerList.toArray();
                    for (int i = objectArray.length - 1; i >= 0; --i) {
                        if (!(objectArray[i] instanceof SearchDataListener)) continue;
                        SearchDataListener searchDataListener = (SearchDataListener)objectArray[i];
                        searchDataListener.searchDataChanged(searchDataEvent);
                    }
                }
                catch (Throwable throwable) {
                    NLogger.error(class$phex$query$Search == null ? (class$phex$query$Search = Search.class$("phex.query.Search")) : class$phex$query$Search, (Object)throwable, throwable);
                }
            }
        });
    }
}

