/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import phex.common.MediaType;
import phex.download.RemoteFile;

public class SearchFilter {
    private String name;
    private List filterTokens;
    private String filterString;
    private MediaType mediaType;
    private long minFileSize;
    private long maxFileSize;
    private long lastTimeUsed;

    public SearchFilter(String string) {
        this.name = string;
        this.filterTokens = new ArrayList();
        this.mediaType = MediaType.getMediaTypeAny();
        this.minFileSize = -1L;
        this.maxFileSize = -1L;
    }

    public SearchFilter() {
        this(null);
    }

    public void clearFilter() {
        this.filterTokens.clear();
        this.mediaType = MediaType.getMediaTypeAny();
        this.minFileSize = -1L;
        this.maxFileSize = -1L;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public List getFilterTokens() {
        return this.filterTokens;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public long getMinFileSize() {
        return this.minFileSize;
    }

    public String getName() {
        return this.name;
    }

    public long getLastTimeUsed() {
        return this.lastTimeUsed;
    }

    public void setLastTimeUsed(long l) {
        this.lastTimeUsed = l;
    }

    public String toString() {
        return this.name;
    }

    public void updateSearchFilter(String string) {
        this.setFilterString(string);
    }

    public void updateSearchFilter(String string, MediaType mediaType, long l, long l2) {
        this.setFilterString(string);
        this.mediaType = mediaType;
        this.minFileSize = l;
        this.maxFileSize = l2;
    }

    public void updateSearchFilter(long l, long l2) {
        this.minFileSize = l;
        this.maxFileSize = l2;
    }

    public boolean isFiltered(RemoteFile remoteFile) {
        return this.isFiltered(remoteFile.getFileSize(), remoteFile.getFilename(), remoteFile.getSpeed(), remoteFile.getQueryHitHost().getHostRating());
    }

    public boolean isFiltered(long l, String string, long l2, int n) {
        if (this.minFileSize > 0L && l < this.minFileSize || this.maxFileSize > 0L && l > this.maxFileSize) {
            return true;
        }
        if (!this.mediaType.isFilenameOf(string)) {
            return true;
        }
        return this.isFilenameFiltered(string);
    }

    private void setFilterString(String string) {
        this.filterString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.filterString, " ");
        this.filterTokens.clear();
        while (stringTokenizer.hasMoreTokens()) {
            this.filterTokens.add(stringTokenizer.nextToken().toLowerCase());
        }
    }

    private boolean isFilenameFiltered(String string) {
        if (this.filterTokens == null || this.filterTokens.size() == 0) {
            return false;
        }
        string = string.toLowerCase();
        Iterator iterator = this.filterTokens.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string.indexOf(string2) != -1) continue;
            return true;
        }
        return false;
    }
}

